/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.deser.SettableBeanProperty;
import tools.jackson.databind.deser.bean.PropertyValueBuffer;
import tools.jackson.databind.introspect.AnnotatedWithParams;

public abstract class ValueInstantiator {
    public abstract ValueInstantiator createContextual(DeserializationContext var1, BeanDescription.Supplier var2);

    public abstract Class<?> getValueClass();

    public abstract String getValueTypeDesc();

    public boolean canInstantiate() {
        return this.canCreateUsingDefault() || this.canCreateUsingDelegate() || this.canCreateUsingArrayDelegate() || this.canCreateFromObjectWith() || this.canCreateFromString() || this.canCreateFromInt() || this.canCreateFromLong() || this.canCreateFromDouble() || this.canCreateFromBoolean();
    }

    public boolean canCreateFromString() {
        return false;
    }

    public boolean canCreateFromInt() {
        return false;
    }

    public boolean canCreateFromLong() {
        return false;
    }

    public boolean canCreateFromBigInteger() {
        return false;
    }

    public boolean canCreateFromDouble() {
        return false;
    }

    public boolean canCreateFromBigDecimal() {
        return false;
    }

    public boolean canCreateFromBoolean() {
        return false;
    }

    public boolean canCreateUsingDefault() {
        return this.getDefaultCreator() != null;
    }

    public boolean canCreateUsingDelegate() {
        return false;
    }

    public boolean canCreateUsingArrayDelegate() {
        return false;
    }

    public boolean canCreateFromObjectWith() {
        return false;
    }

    public SettableBeanProperty[] getFromObjectArguments(DeserializationConfig config) {
        return null;
    }

    public JavaType getDelegateType(DeserializationConfig config) {
        return null;
    }

    public JavaType getArrayDelegateType(DeserializationConfig config) {
        return null;
    }

    public Object createUsingDefault(DeserializationContext ctxt) throws JacksonException {
        return ctxt.handleMissingInstantiator(this.getValueClass(), this, null, "no default no-arguments constructor found", new Object[0]);
    }

    public Object createFromObjectWith(DeserializationContext ctxt, Object[] args) throws JacksonException {
        return ctxt.handleMissingInstantiator(this.getValueClass(), this, null, "no creator with arguments specified", new Object[0]);
    }

    public Object createUsingDefaultOrWithoutArguments(DeserializationContext ctxt) throws JacksonException {
        return ctxt.handleMissingInstantiator(this.getValueClass(), this, null, "neither default (no-arguments) nor with-arguments Creator found", new Object[0]);
    }

    public Object createFromObjectWith(DeserializationContext ctxt, SettableBeanProperty[] props, PropertyValueBuffer buffer) throws JacksonException {
        return this.createFromObjectWith(ctxt, buffer.getParameters(ctxt, props));
    }

    public Object createUsingDelegate(DeserializationContext ctxt, Object delegate) throws JacksonException {
        return ctxt.handleMissingInstantiator(this.getValueClass(), this, null, "no delegate creator specified", new Object[0]);
    }

    public Object createUsingArrayDelegate(DeserializationContext ctxt, Object delegate) throws JacksonException {
        return ctxt.handleMissingInstantiator(this.getValueClass(), this, null, "no array delegate creator specified", new Object[0]);
    }

    public Object createFromString(DeserializationContext ctxt, String value) throws JacksonException {
        return ctxt.handleMissingInstantiator(this.getValueClass(), this, ctxt.getParser(), "no String-argument constructor/factory method to deserialize from String value ('%s')", value);
    }

    public Object createFromInt(DeserializationContext ctxt, int value) throws JacksonException {
        return ctxt.handleMissingInstantiator(this.getValueClass(), this, null, "no int/Int-argument constructor/factory method to deserialize from Number value (%s)", value);
    }

    public Object createFromLong(DeserializationContext ctxt, long value) throws JacksonException {
        return ctxt.handleMissingInstantiator(this.getValueClass(), this, null, "no long/Long-argument constructor/factory method to deserialize from Number value (%s)", value);
    }

    public Object createFromBigInteger(DeserializationContext ctxt, BigInteger value) throws JacksonException {
        return ctxt.handleMissingInstantiator(this.getValueClass(), this, null, "no BigInteger-argument constructor/factory method to deserialize from Number value (%s)", value);
    }

    public Object createFromDouble(DeserializationContext ctxt, double value) throws JacksonException {
        return ctxt.handleMissingInstantiator(this.getValueClass(), this, null, "no double/Double-argument constructor/factory method to deserialize from Number value (%s)", value);
    }

    public Object createFromBigDecimal(DeserializationContext ctxt, BigDecimal value) throws JacksonException {
        return ctxt.handleMissingInstantiator(this.getValueClass(), this, null, "no BigDecimal/double/Double-argument constructor/factory method to deserialize from Number value (%s)", value);
    }

    public Object createFromBoolean(DeserializationContext ctxt, boolean value) throws JacksonException {
        return ctxt.handleMissingInstantiator(this.getValueClass(), this, null, "no boolean/Boolean-argument constructor/factory method to deserialize from boolean value (%s)", value);
    }

    public AnnotatedWithParams getDefaultCreator() {
        return null;
    }

    public AnnotatedWithParams getDelegateCreator() {
        return null;
    }

    public AnnotatedWithParams getArrayDelegateCreator() {
        return null;
    }

    public AnnotatedWithParams getWithArgsCreator() {
        return null;
    }

    public static class Delegating
    extends ValueInstantiator
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final ValueInstantiator _delegate;

        protected Delegating(ValueInstantiator delegate) {
            this._delegate = delegate;
        }

        @Override
        public ValueInstantiator createContextual(DeserializationContext ctxt, BeanDescription.Supplier beanDescRef) {
            ValueInstantiator d = this._delegate.createContextual(ctxt, beanDescRef);
            return d == this._delegate ? this : new Delegating(d);
        }

        protected ValueInstantiator delegate() {
            return this._delegate;
        }

        @Override
        public Class<?> getValueClass() {
            return this.delegate().getValueClass();
        }

        @Override
        public String getValueTypeDesc() {
            return this.delegate().getValueTypeDesc();
        }

        @Override
        public boolean canInstantiate() {
            return this.delegate().canInstantiate();
        }

        @Override
        public boolean canCreateFromString() {
            return this.delegate().canCreateFromString();
        }

        @Override
        public boolean canCreateFromInt() {
            return this.delegate().canCreateFromInt();
        }

        @Override
        public boolean canCreateFromLong() {
            return this.delegate().canCreateFromLong();
        }

        @Override
        public boolean canCreateFromDouble() {
            return this.delegate().canCreateFromDouble();
        }

        @Override
        public boolean canCreateFromBoolean() {
            return this.delegate().canCreateFromBoolean();
        }

        @Override
        public boolean canCreateUsingDefault() {
            return this.delegate().canCreateUsingDefault();
        }

        @Override
        public boolean canCreateUsingDelegate() {
            return this.delegate().canCreateUsingDelegate();
        }

        @Override
        public boolean canCreateUsingArrayDelegate() {
            return this.delegate().canCreateUsingArrayDelegate();
        }

        @Override
        public boolean canCreateFromObjectWith() {
            return this.delegate().canCreateFromObjectWith();
        }

        @Override
        public SettableBeanProperty[] getFromObjectArguments(DeserializationConfig config) {
            return this.delegate().getFromObjectArguments(config);
        }

        @Override
        public JavaType getDelegateType(DeserializationConfig config) {
            return this.delegate().getDelegateType(config);
        }

        @Override
        public JavaType getArrayDelegateType(DeserializationConfig config) {
            return this.delegate().getArrayDelegateType(config);
        }

        @Override
        public Object createUsingDefault(DeserializationContext ctxt) throws JacksonException {
            return this.delegate().createUsingDefault(ctxt);
        }

        @Override
        public Object createFromObjectWith(DeserializationContext ctxt, Object[] args) throws JacksonException {
            return this.delegate().createFromObjectWith(ctxt, args);
        }

        @Override
        public Object createFromObjectWith(DeserializationContext ctxt, SettableBeanProperty[] props, PropertyValueBuffer buffer) throws JacksonException {
            return this.delegate().createFromObjectWith(ctxt, props, buffer);
        }

        @Override
        public Object createUsingDelegate(DeserializationContext ctxt, Object delegate) throws JacksonException {
            return this.delegate().createUsingDelegate(ctxt, delegate);
        }

        @Override
        public Object createUsingArrayDelegate(DeserializationContext ctxt, Object delegate) throws JacksonException {
            return this.delegate().createUsingArrayDelegate(ctxt, delegate);
        }

        @Override
        public Object createFromString(DeserializationContext ctxt, String value) throws JacksonException {
            return this.delegate().createFromString(ctxt, value);
        }

        @Override
        public Object createFromInt(DeserializationContext ctxt, int value) throws JacksonException {
            return this.delegate().createFromInt(ctxt, value);
        }

        @Override
        public Object createFromLong(DeserializationContext ctxt, long value) throws JacksonException {
            return this.delegate().createFromLong(ctxt, value);
        }

        @Override
        public Object createFromBigInteger(DeserializationContext ctxt, BigInteger value) throws JacksonException {
            return this.delegate().createFromBigInteger(ctxt, value);
        }

        @Override
        public Object createFromDouble(DeserializationContext ctxt, double value) throws JacksonException {
            return this.delegate().createFromDouble(ctxt, value);
        }

        @Override
        public Object createFromBigDecimal(DeserializationContext ctxt, BigDecimal value) throws JacksonException {
            return this.delegate().createFromBigDecimal(ctxt, value);
        }

        @Override
        public Object createFromBoolean(DeserializationContext ctxt, boolean value) throws JacksonException {
            return this.delegate().createFromBoolean(ctxt, value);
        }

        @Override
        public AnnotatedWithParams getDefaultCreator() {
            return this.delegate().getDefaultCreator();
        }

        @Override
        public AnnotatedWithParams getDelegateCreator() {
            return this.delegate().getDelegateCreator();
        }

        @Override
        public AnnotatedWithParams getArrayDelegateCreator() {
            return this.delegate().getArrayDelegateCreator();
        }

        @Override
        public AnnotatedWithParams getWithArgsCreator() {
            return this.delegate().getWithArgsCreator();
        }
    }

    public static class Base
    extends ValueInstantiator {
        protected final Class<?> _valueType;

        public Base(Class<?> type) {
            this._valueType = type;
        }

        public Base(JavaType type) {
            this._valueType = type.getRawClass();
        }

        @Override
        public ValueInstantiator createContextual(DeserializationContext ctxt, BeanDescription.Supplier beanDescRef) {
            return this;
        }

        @Override
        public String getValueTypeDesc() {
            return this._valueType.getName();
        }

        @Override
        public Class<?> getValueClass() {
            return this._valueType;
        }
    }

    public static interface Gettable {
        public ValueInstantiator getValueInstantiator();
    }
}

