/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;
import org.graalvm.collections.UnmodifiableEconomicSet;

public final class PolyglotAccess {
    private final EconomicMap<String, UnmodifiableEconomicSet<String>> evalAccess;
    private final EconomicSet<String> bindingsAccess;
    private final boolean allAccess;
    public static final PolyglotAccess NONE = new PolyglotAccess(false, null, null);
    public static final PolyglotAccess ALL = new PolyglotAccess(true, null, null);

    PolyglotAccess(boolean allAccess, EconomicMap<String, EconomicSet<String>> access, EconomicSet<String> bindingsAccess) {
        this.allAccess = allAccess;
        this.evalAccess = PolyglotAccess.copyMap(access);
        this.bindingsAccess = bindingsAccess;
    }

    private static EconomicMap<String, UnmodifiableEconomicSet<String>> copyMap(EconomicMap<String, EconomicSet<String>> values) {
        if (values == null) {
            return null;
        }
        EconomicMap newMap = EconomicMap.create((int)values.size());
        MapCursor cursor = values.getEntries();
        while (cursor.advance()) {
            newMap.put((Object)((String)cursor.getKey()), (Object)EconomicSet.create((Equivalence)Equivalence.DEFAULT, (UnmodifiableEconomicSet)((UnmodifiableEconomicSet)cursor.getValue())));
        }
        return newMap;
    }

    String validate(Set<String> availableLanguages) {
        if (this.evalAccess != null) {
            MapCursor entries = this.evalAccess.getEntries();
            while (entries.advance()) {
                String invalidKey = null;
                if (!availableLanguages.contains(entries.getKey())) {
                    invalidKey = (String)entries.getKey();
                }
                if (invalidKey == null) {
                    for (String entry : (UnmodifiableEconomicSet)entries.getValue()) {
                        if (availableLanguages.contains(entry)) continue;
                        invalidKey = entry;
                        break;
                    }
                }
                if (invalidKey == null) continue;
                return String.format("Language '%s' configured in polyglot evaluation rule %s -> %s is not installed or available.", invalidKey, entries.getKey(), PolyglotAccess.toStringSet((UnmodifiableEconomicSet<String>)((UnmodifiableEconomicSet)entries.getValue())));
            }
        }
        if (this.bindingsAccess != null) {
            for (String language : this.bindingsAccess) {
                if (availableLanguages.contains(language)) continue;
                return String.format("Language '%s' configured in polyglot bindings access rule is not installed or available.", language);
            }
        }
        return null;
    }

    static String toStringSet(UnmodifiableEconomicSet<String> set) {
        StringBuilder b = new StringBuilder();
        String sep = "";
        for (String entry : set) {
            b.append(sep);
            b.append(entry);
            sep = ", ";
        }
        return b.toString();
    }

    Set<String> getEvalAccess(String language) {
        if (this.allAccess) {
            return null;
        }
        if (this.evalAccess == null) {
            return Set.of();
        }
        UnmodifiableEconomicSet a = (UnmodifiableEconomicSet)this.evalAccess.get((Object)language);
        if (a == null) {
            return Set.of();
        }
        return Set.of((String[])a.toArray((Object[])new String[a.size()]));
    }

    Map<String, Set<String>> getEvalAccess() {
        if (this.allAccess) {
            return null;
        }
        if (this.evalAccess == null) {
            return Map.of();
        }
        LinkedHashMap<String, Set<String>> map = new LinkedHashMap<String, Set<String>>();
        MapCursor mapCursor = this.evalAccess.getEntries();
        while (mapCursor.advance()) {
            UnmodifiableEconomicSet set = (UnmodifiableEconomicSet)mapCursor.getValue();
            Set<String> newSet = null;
            if (set != null) {
                newSet = Set.of((String[])set.toArray((Object[])new String[set.size()]));
            }
            map.put((String)mapCursor.getKey(), newSet);
        }
        return map;
    }

    Set<String> getBindingsAccess() {
        if (this.allAccess) {
            return null;
        }
        if (this.bindingsAccess == null) {
            return Set.of();
        }
        return Set.of((String[])this.bindingsAccess.toArray((Object[])new String[this.bindingsAccess.size()]));
    }

    public static Builder newBuilder() {
        return NONE.new Builder();
    }

    public final class Builder {
        private EconomicMap<String, EconomicSet<String>> evalAccess;
        private EconomicSet<String> bindingsAccess;

        Builder() {
        }

        public Builder allowEvalBetween(String ... languages) {
            Objects.requireNonNull(languages);
            if (this.evalAccess == null) {
                this.evalAccess = EconomicMap.create();
            }
            for (String language : languages) {
                LinkedHashSet<String> filteredList;
                Objects.requireNonNull(language);
                EconomicSet languageAccess = (EconomicSet)this.evalAccess.get((Object)language);
                if (languageAccess == null) {
                    languageAccess = EconomicSet.create();
                    this.evalAccess.put((Object)language, (Object)languageAccess);
                }
                if ((filteredList = new LinkedHashSet<String>(Arrays.asList(languages))).size() > 1) {
                    filteredList.remove(language);
                }
                languageAccess.addAll(filteredList);
            }
            return this;
        }

        public Builder denyEvalBetween(String ... languages) {
            Objects.requireNonNull(languages);
            if (this.evalAccess != null) {
                for (String language : languages) {
                    Objects.requireNonNull(language);
                    EconomicSet languageAccess = (EconomicSet)this.evalAccess.get((Object)language);
                    if (languageAccess == null) continue;
                    languageAccess.removeAll(Arrays.asList(languages));
                }
            }
            return this;
        }

        public Builder allowEval(String from, String to) {
            EconomicSet languageAccess;
            Objects.requireNonNull(from);
            Objects.requireNonNull(to);
            if (this.evalAccess == null) {
                this.evalAccess = EconomicMap.create();
            }
            if ((languageAccess = (EconomicSet)this.evalAccess.get((Object)from)) == null) {
                languageAccess = EconomicSet.create();
                this.evalAccess.put((Object)from, (Object)languageAccess);
            }
            languageAccess.add((Object)to);
            return this;
        }

        public Builder denyEval(String from, String to) {
            EconomicSet languageAccess;
            Objects.requireNonNull(from);
            Objects.requireNonNull(to);
            if (this.evalAccess != null && (languageAccess = (EconomicSet)this.evalAccess.get((Object)from)) != null) {
                languageAccess.remove((Object)to);
            }
            return this;
        }

        public Builder allowBindingsAccess(String language) {
            Objects.requireNonNull(language);
            if (this.bindingsAccess == null) {
                this.bindingsAccess = EconomicSet.create();
            }
            this.bindingsAccess.add((Object)language);
            return this;
        }

        public Builder denyBindingsAccess(String language) {
            Objects.requireNonNull(language);
            if (this.bindingsAccess != null) {
                this.bindingsAccess.remove((Object)language);
            }
            return this;
        }

        public PolyglotAccess build() {
            return new PolyglotAccess(false, this.evalAccess, this.bindingsAccess);
        }
    }
}

