/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.cache;

import org.thymeleaf.cache.ICacheEntryValidity;

public class TTLCacheEntryValidity
implements ICacheEntryValidity {
    private final long cacheTTLMs;
    private final long creationTimeInMillis;

    public TTLCacheEntryValidity(long cacheTTLMs) {
        this.cacheTTLMs = cacheTTLMs;
        this.creationTimeInMillis = System.currentTimeMillis();
    }

    public long getCacheTTLMs() {
        return this.cacheTTLMs;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    @Override
    public boolean isCacheStillValid() {
        long currentTimeInMillis = System.currentTimeMillis();
        return currentTimeInMillis < this.creationTimeInMillis + this.cacheTTLMs;
    }
}

