/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.listeners;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public abstract class AbstractListenerDispatcher<TListener>
implements Iterable<TListener> {
    private final CopyOnWriteArrayList<TListener> listeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<WeakReference<TListener>> weakListeners = new CopyOnWriteArrayList();
    private volatile boolean shutdown = false;

    public final void addListener(TListener listener) {
        if (listener == this) {
            throw new IllegalArgumentException("Adding this instance to itself is not allowed");
        }
        if (this.isShutdown()) {
            return;
        }
        this.listeners.addIfAbsent(listener);
    }

    public final void addWeakListener(TListener listener) {
        if (listener == this) {
            throw new IllegalArgumentException("Adding this instance to itself is not allowed");
        }
        if (this.isShutdown() || this.listeners.contains(listener)) {
            return;
        }
        this.removeListener(listener);
        WeakReference<TListener> weakReference = new WeakReference<TListener>(listener);
        this.weakListeners.add(weakReference);
        this.cleanWeakListeners();
    }

    public final void removeListener(TListener listener) {
        if (this.listeners.remove(listener)) {
            return;
        }
        for (WeakReference<TListener> ref : this.weakListeners) {
            Object refValue = ref.get();
            if (refValue == listener) {
                this.weakListeners.remove(ref);
                return;
            }
            if (refValue != null) continue;
            this.weakListeners.remove(ref);
        }
    }

    protected final void notify(Consumer<TListener> notificationHandler, String notificationLogName) {
        for (TListener listener : this) {
            try {
                notificationHandler.accept(listener);
            }
            catch (Exception e) {
                this.logError("Error on notify " + notificationLogName + " to listener " + listener, e);
            }
        }
    }

    protected abstract void logError(String var1, Throwable var2);

    public final void removeAllListeners() {
        this.listeners.clear();
        this.weakListeners.clear();
    }

    public final void shutdown() {
        this.shutdown = true;
        this.removeAllListeners();
    }

    public final boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public final Iterator<TListener> iterator() {
        this.cleanWeakListeners();
        return new ListenerIterator(this.listeners, this.weakListeners);
    }

    private void cleanWeakListeners() {
        this.weakListeners.removeIf(ref -> ref.get() == null);
    }

    private static final class ListenerIterator<TListener>
    implements Iterator<TListener> {
        private final ListIterator<TListener> strongIterator;
        private final ListIterator<WeakReference<TListener>> weakIterator;
        private boolean useStrongIterator;
        private TListener nextWeakListener;

        private ListenerIterator(CopyOnWriteArrayList<TListener> strongListeners, CopyOnWriteArrayList<WeakReference<TListener>> weakListeners) {
            this.strongIterator = ListenerIterator.listIteratorAtEnd(strongListeners);
            this.weakIterator = ListenerIterator.listIteratorAtEnd(weakListeners);
        }

        @Override
        public boolean hasNext() {
            if (!this.useStrongIterator) {
                if (this.getNextWeakListener() != null) {
                    return true;
                }
                this.useStrongIterator = true;
            }
            return this.strongIterator.hasPrevious();
        }

        @Override
        public TListener next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.useStrongIterator) {
                return this.strongIterator.previous();
            }
            TListener next = this.nextWeakListener;
            this.nextWeakListener = null;
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        private TListener getNextWeakListener() {
            ListIterator<WeakReference<TListener>> weakIterator = this.weakIterator;
            Object nextWeakListener = this.nextWeakListener;
            while (nextWeakListener == null && weakIterator.hasPrevious()) {
                WeakReference<TListener> currentRef = weakIterator.previous();
                nextWeakListener = currentRef.get();
            }
            this.nextWeakListener = nextWeakListener;
            return this.nextWeakListener;
        }

        private static <T> ListIterator<T> listIteratorAtEnd(CopyOnWriteArrayList<T> list) {
            ListIterator<T> listIterator;
            try {
                listIterator = list.listIterator(Math.max(0, list.size() - 1));
            }
            catch (IndexOutOfBoundsException e) {
                listIterator = list.listIterator();
            }
            while (listIterator.hasNext()) {
                listIterator.next();
            }
            return listIterator;
        }
    }
}

