/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.CreateObjectNodeFactory;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Properties;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSDictionary;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.JSPromise;
import com.oracle.truffle.js.runtime.builtins.JSPromiseObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Null;

public abstract class CreateObjectNode
extends JavaScriptBaseNode {
    protected final JSContext context;

    protected CreateObjectNode(JSContext context) {
        this.context = context;
    }

    @NeverDefault
    public static CreateObjectNode create(JSContext context) {
        return new CreateOrdinaryObjectNode(context);
    }

    @NeverDefault
    public static CreateObjectWithPrototypeNode createOrdinaryWithPrototype(JSContext context) {
        return CreateObjectNode.createWithPrototype(context, JSOrdinary.INSTANCE);
    }

    @NeverDefault
    public static CreateObjectWithPrototypeNode createWithPrototype(JSContext context, JSClass jsclass) {
        return CreateObjectWithPrototypeNode.create(context, jsclass);
    }

    @NeverDefault
    static CreateObjectNode createDictionary(JSContext context) {
        return new CreateDictionaryObjectNode(context);
    }

    public final JSObject execute(JSRealm realm) {
        return this.executeWithPrototype(realm, (Object)realm.getObjectPrototype());
    }

    public abstract JSObject executeWithPrototype(JSRealm var1, Object var2);

    public boolean seenArrayPrototype() {
        return false;
    }

    private static class CreateOrdinaryObjectNode
    extends CreateObjectNode {
        protected CreateOrdinaryObjectNode(JSContext context) {
            super(context);
        }

        @Override
        public JSObject executeWithPrototype(JSRealm realm, Object proto) {
            assert (proto == realm.getObjectPrototype()) : proto;
            return JSOrdinary.create(this.context, realm);
        }
    }

    public static abstract class CreateObjectWithPrototypeNode
    extends CreateObjectNode {
        protected final JSClass jsclass;
        @Node.Child
        private DynamicObjectLibrary protoFlagsNode;
        @CompilerDirectives.CompilationFinal
        private boolean seenArrayPrototype;

        protected CreateObjectWithPrototypeNode(JSContext context, JSClass jsclass) {
            super(context);
            this.jsclass = jsclass;
            assert (this.isOrdinaryObject() || this.isPromiseObject());
        }

        public abstract JSObject execute(Object var1);

        @Override
        public final JSObject executeWithPrototype(JSRealm realm, Object proto) {
            return this.execute(proto);
        }

        protected static CreateObjectWithPrototypeNode create(JSContext context, JSClass jsclass) {
            return CreateObjectNodeFactory.CreateObjectWithPrototypeNodeGen.create(context, jsclass);
        }

        @Specialization(guards={"!context.isMultiContext()", "isValidPrototype(cachedPrototype)", "prototype == cachedPrototype"}, limit="1")
        final JSObject doCachedPrototype(JSDynamicObject prototype, @Cached(value="prototype") JSDynamicObject cachedPrototype, @Cached(value="getProtoChildShape(cachedPrototype)") Shape protoChildShape) {
            if (this.isPromiseObject()) {
                return JSPromise.create(this.context, protoChildShape, cachedPrototype);
            }
            if (this.isOrdinaryObject()) {
                return JSOrdinary.create(this.context, protoChildShape, cachedPrototype);
            }
            throw Errors.unsupported("unsupported object type");
        }

        @Specialization(guards={"isOrdinaryObject()", "isValidPrototype(prototype)"}, replaces={"doCachedPrototype"})
        final JSObject doOrdinaryInstancePrototype(JSDynamicObject prototype, @CachedLibrary(limit="3") @Cached.Shared DynamicObjectLibrary setProtoNode) {
            JSObject object = JSOrdinary.createWithoutPrototype(this.context, prototype);
            Properties.put(setProtoNode, object, JSObject.HIDDEN_PROTO, (Object)prototype);
            this.handleArrayPrototype(object, prototype);
            return object;
        }

        @Specialization(guards={"isPromiseObject()", "isValidPrototype(prototype)"}, replaces={"doCachedPrototype"})
        final JSObject doPromiseInstancePrototype(JSDynamicObject prototype, @CachedLibrary(limit="3") @Cached.Shared DynamicObjectLibrary setProtoNode) {
            JSPromiseObject object = JSPromise.createWithoutPrototype(this.context, prototype);
            Properties.put(setProtoNode, object, JSObject.HIDDEN_PROTO, (Object)prototype);
            return object;
        }

        @Specialization(guards={"isOrdinaryObject() || isPromiseObject()", "!isValidPrototype(prototype)"})
        final JSObject doNotJSObjectOrNull(Object prototype) {
            return JSOrdinary.create(this.context, this.getRealm());
        }

        @NeverDefault
        final Shape getProtoChildShape(JSDynamicObject prototype) {
            if (prototype == Null.instance) {
                return this.context.getEmptyShapeNullPrototype();
            }
            Shape derivedShape = JSObjectUtil.getProtoChildShape(prototype, this.jsclass, this.context);
            if (this.isOrdinaryObject() && JSShape.isArrayPrototypeOrDerivative(prototype)) {
                this.seenArrayPrototype = true;
                derivedShape = Shape.newBuilder((Shape)derivedShape).shapeFlags(derivedShape.getFlags() | 0x10).build();
            }
            return derivedShape;
        }

        @Idempotent
        final boolean isOrdinaryObject() {
            return this.jsclass == JSOrdinary.INSTANCE;
        }

        @Idempotent
        final boolean isPromiseObject() {
            return this.jsclass == JSPromise.INSTANCE;
        }

        private void handleArrayPrototype(JSObject object, JSDynamicObject proto) {
            if (JSShape.isArrayPrototypeOrDerivative(proto)) {
                this.markAsArrayPrototype(object);
            }
        }

        private void markAsArrayPrototype(JSObject object) {
            if (this.protoFlagsNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.seenArrayPrototype = true;
                this.protoFlagsNode = (DynamicObjectLibrary)this.insert((Node)((DynamicObjectLibrary)DynamicObjectLibrary.getFactory().createDispatched(5)));
            }
            assert (JSOrdinary.isJSOrdinaryObject(object)) : object;
            this.protoFlagsNode.setShapeFlags((DynamicObject)object, this.protoFlagsNode.getShapeFlags((DynamicObject)object) | 0x10);
        }

        @Override
        public boolean seenArrayPrototype() {
            return this.seenArrayPrototype;
        }
    }

    private static class CreateDictionaryObjectNode
    extends CreateObjectNode {
        protected CreateDictionaryObjectNode(JSContext context) {
            super(context);
        }

        @Override
        public JSObject executeWithPrototype(JSRealm realm, Object proto) {
            assert (proto == realm.getObjectPrototype()) : proto;
            return JSDictionary.create(this.context, realm);
        }
    }
}

