/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.options;

import java.util.HashMap;
import java.util.Map;
import schemacrawler.schemacrawler.IdentifierQuotingStrategy;
import schemacrawler.schemacrawler.OptionsBuilder;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.options.ConfigOptionsBuilder;
import schemacrawler.tools.options.ConfigUtility;
import schemacrawler.tools.text.options.BaseTextOptions;
import schemacrawler.tools.text.options.DatabaseObjectColorMap;

public abstract class BaseTextOptionsBuilder<B extends BaseTextOptionsBuilder<B, O>, O extends BaseTextOptions>
implements OptionsBuilder<BaseTextOptionsBuilder<B, O>, O>,
ConfigOptionsBuilder<BaseTextOptionsBuilder<B, O>, O> {
    protected static final String SCHEMACRAWLER_FORMAT_PREFIX = "schemacrawler.format.";
    private static final String NO_SCHEMACRAWLER_INFO = "schemacrawler.format.no_schemacrawler_info";
    private static final String SHOW_DATABASE_INFO = "schemacrawler.format.show_database_info";
    private static final String SHOW_JDBC_DRIVER_INFO = "schemacrawler.format.show_jdbc_driver_info";
    private static final String SHOW_UNQUALIFIED_NAMES = "schemacrawler.format.show_unqualified_names";
    private static final String SORT_ALPHABETICALLY_TABLES = "schemacrawler.format.sort_alphabetically.tables";
    private static final String SORT_ALPHABETICALLY_TABLE_COLUMNS = "schemacrawler.format.sort_alphabetically.table_columns";
    private static final String SORT_ALPHABETICALLY_ROUTINES = "schemacrawler.format.sort_alphabetically.routines";
    private static final String SORT_ALPHABETICALLY_ROUTINE_PARAMETERS = "schemacrawler.format.sort_alphabetically.routine_columns";
    private static final String NO_SCHEMA_COLORS = "schemacrawler.format.no_schema_colors";
    private static final String SCHEMA_COLOR_MAP = "schemacrawler.format.color_map";
    private static final String IDENTIFIER_QUOTING_STRATEGY = "schemacrawler.format.identifier_quoting_strategy";
    protected boolean isAlphabeticalSortForRoutineParameters;
    protected boolean isAlphabeticalSortForRoutines;
    protected boolean isAlphabeticalSortForTableColumns;
    protected boolean isAlphabeticalSortForTables = true;
    protected boolean isNoSchemaCrawlerInfo;
    protected boolean isShowDatabaseInfo;
    protected boolean isShowJdbcDriverInfo;
    protected boolean isShowUnqualifiedNames;
    protected boolean isNoSchemaColors;
    protected IdentifierQuotingStrategy identifierQuotingStrategy = IdentifierQuotingStrategy.quote_if_special_characters_and_reserved_words;
    protected DatabaseObjectColorMap colorMap = new DatabaseObjectColorMap(new HashMap<String, String>());

    protected BaseTextOptionsBuilder() {
    }

    public B fromConfig(Config map) {
        if (map == null) {
            return (B)this;
        }
        Config config = ConfigUtility.fromConfig(map);
        this.isShowDatabaseInfo = config.getBooleanValue(SHOW_DATABASE_INFO);
        this.isShowJdbcDriverInfo = config.getBooleanValue(SHOW_JDBC_DRIVER_INFO);
        this.isNoSchemaCrawlerInfo = config.getBooleanValue(NO_SCHEMACRAWLER_INFO);
        this.isShowUnqualifiedNames = config.getBooleanValue(SHOW_UNQUALIFIED_NAMES);
        this.isAlphabeticalSortForTables = config.getBooleanValue(SORT_ALPHABETICALLY_TABLES, this.isAlphabeticalSortForTables);
        this.isAlphabeticalSortForTableColumns = config.getBooleanValue(SORT_ALPHABETICALLY_TABLE_COLUMNS, this.isAlphabeticalSortForTableColumns);
        this.isAlphabeticalSortForRoutines = config.getBooleanValue(SORT_ALPHABETICALLY_ROUTINES, this.isAlphabeticalSortForRoutines);
        this.isAlphabeticalSortForRoutineParameters = config.getBooleanValue(SORT_ALPHABETICALLY_ROUTINE_PARAMETERS, this.isAlphabeticalSortForRoutineParameters);
        this.isNoSchemaColors = config.getBooleanValue(NO_SCHEMA_COLORS);
        this.identifierQuotingStrategy = config.getEnumValue(IDENTIFIER_QUOTING_STRATEGY, IdentifierQuotingStrategy.quote_if_special_characters_and_reserved_words);
        if (this.isNoSchemaColors) {
            this.colorMap = new DatabaseObjectColorMap();
        } else {
            Map<String, Object> subMap = config.getSubMap(SCHEMA_COLOR_MAP);
            if (subMap != null && !subMap.isEmpty()) {
                HashMap<String, String> properties = new HashMap<String, String>();
                for (Map.Entry<String, Object> subMapEntry : subMap.entrySet()) {
                    String key = subMapEntry.getKey();
                    String value = String.valueOf(subMapEntry.getValue());
                    properties.put(key, value);
                }
                this.colorMap = new DatabaseObjectColorMap(properties);
            }
        }
        this.fromConfigCommandLineOverride(map);
        return (B)this;
    }

    public B fromOptions(O options) {
        if (options == null) {
            return (B)this;
        }
        this.isShowDatabaseInfo = ((BaseTextOptions)options).isShowDatabaseInfo();
        this.isShowJdbcDriverInfo = ((BaseTextOptions)options).isShowJdbcDriverInfo();
        this.isNoSchemaCrawlerInfo = ((BaseTextOptions)options).isNoSchemaCrawlerInfo();
        this.isShowUnqualifiedNames = ((BaseTextOptions)options).isShowUnqualifiedNames();
        this.isAlphabeticalSortForTables = ((BaseTextOptions)options).isAlphabeticalSortForTables();
        this.isAlphabeticalSortForTableColumns = ((BaseTextOptions)options).isAlphabeticalSortForTableColumns();
        this.isAlphabeticalSortForRoutines = ((BaseTextOptions)options).isAlphabeticalSortForRoutines();
        this.isAlphabeticalSortForRoutineParameters = ((BaseTextOptions)options).isAlphabeticalSortForRoutineParameters();
        this.isNoSchemaColors = ((BaseTextOptions)options).isNoSchemaColors();
        this.identifierQuotingStrategy = ((BaseTextOptions)options).getIdentifierQuotingStrategy();
        this.colorMap = ((BaseTextOptions)options).getColorMap();
        return (B)this;
    }

    public final B noInfo() {
        return this.noInfo(true);
    }

    public final B noInfo(boolean value) {
        this.isNoSchemaCrawlerInfo = value;
        this.isShowDatabaseInfo = !value;
        this.isShowJdbcDriverInfo = !value;
        return (B)this;
    }

    public final B noSchemaColors() {
        return this.noSchemaColors(true);
    }

    public final B noSchemaColors(boolean value) {
        this.isNoSchemaColors = value;
        return (B)this;
    }

    public final B noSchemaCrawlerInfo() {
        return this.noSchemaCrawlerInfo(true);
    }

    public final B noSchemaCrawlerInfo(boolean value) {
        this.isNoSchemaCrawlerInfo = value;
        return (B)this;
    }

    public final B showDatabaseInfo() {
        return this.showDatabaseInfo(true);
    }

    public final B showDatabaseInfo(boolean value) {
        this.isShowDatabaseInfo = value;
        return (B)this;
    }

    public final B showJdbcDriverInfo() {
        return this.showJdbcDriverInfo(true);
    }

    public final B showJdbcDriverInfo(boolean value) {
        this.isShowJdbcDriverInfo = value;
        return (B)this;
    }

    public final B showUnqualifiedNames() {
        return this.showUnqualifiedNames(true);
    }

    public final B showUnqualifiedNames(boolean value) {
        this.isShowUnqualifiedNames = value;
        return (B)this;
    }

    public final B sortRoutineParameters() {
        return this.sortRoutineParameters(true);
    }

    public final B sortRoutineParameters(boolean value) {
        this.isAlphabeticalSortForRoutineParameters = value;
        return (B)this;
    }

    public final B sortRoutines() {
        return this.sortRoutines(true);
    }

    public final B sortRoutines(boolean value) {
        this.isAlphabeticalSortForRoutines = value;
        return (B)this;
    }

    public final B sortTableColumns() {
        return this.sortTableColumns(true);
    }

    public final B sortTableColumns(boolean value) {
        this.isAlphabeticalSortForTableColumns = value;
        return (B)this;
    }

    public final B sortTables() {
        return this.sortTables(true);
    }

    public final B sortTables(boolean value) {
        this.isAlphabeticalSortForTables = value;
        return (B)this;
    }

    @Override
    public Config toConfig() {
        Config config = ConfigUtility.newConfig();
        config.put(NO_SCHEMACRAWLER_INFO, this.isNoSchemaCrawlerInfo);
        config.put(SHOW_DATABASE_INFO, this.isShowDatabaseInfo);
        config.put(SHOW_JDBC_DRIVER_INFO, this.isShowJdbcDriverInfo);
        config.put(SHOW_UNQUALIFIED_NAMES, this.isShowUnqualifiedNames);
        config.put(SORT_ALPHABETICALLY_TABLES, this.isAlphabeticalSortForTables);
        config.put(SORT_ALPHABETICALLY_TABLE_COLUMNS, this.isAlphabeticalSortForTableColumns);
        config.put(SORT_ALPHABETICALLY_ROUTINES, this.isAlphabeticalSortForRoutines);
        config.put(SORT_ALPHABETICALLY_ROUTINE_PARAMETERS, this.isAlphabeticalSortForRoutineParameters);
        config.put(NO_SCHEMA_COLORS, this.isNoSchemaColors);
        config.put(IDENTIFIER_QUOTING_STRATEGY, (Object)this.identifierQuotingStrategy);
        return config;
    }

    public B withColorMap(DatabaseObjectColorMap colorMap) {
        this.colorMap = colorMap == null ? new DatabaseObjectColorMap() : colorMap;
        return (B)this;
    }

    public final B withIdentifierQuotingStrategy(IdentifierQuotingStrategy identifierQuotingStrategy) {
        this.identifierQuotingStrategy = identifierQuotingStrategy == null ? IdentifierQuotingStrategy.quote_if_special_characters_and_reserved_words : identifierQuotingStrategy;
        return (B)this;
    }

    private void fromConfigCommandLineOverride(Config config) {
        String noinfoKey = "no-info";
        if (config.containsKey("no-info")) {
            this.noInfo(config.getBooleanValue("no-info"));
        }
        String sorttablesKey = "sort-tables";
        if (config.containsKey("sort-tables")) {
            this.sortTables(config.getBooleanValue("sort-tables"));
        }
        String sortcolumnsKey = "sort-columns";
        if (config.containsKey("sort-columns")) {
            this.sortTableColumns(config.getBooleanValue("sort-columns"));
        }
        String sortroutinesKey = "sort-routines";
        if (config.containsKey("sort-routines")) {
            this.sortRoutines(config.getBooleanValue("sort-routines"));
        }
    }
}

