/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.MutableTrigger;
import schemacrawler.crawl.RetrievalCounts;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.crawl.SchemaSetter;
import schemacrawler.schema.ActionOrientationType;
import schemacrawler.schema.ConditionTimingType;
import schemacrawler.schema.EventManipulationType;
import schemacrawler.schema.Schema;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import us.fatehi.utility.EnumUtility;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

final class TriggerRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(TriggerRetriever.class.getName());

    TriggerRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrieveTriggerInformation() throws SQLException {
        if (this.catalog.getTables().isEmpty()) {
            LOGGER.log(Level.FINE, "No tables found");
            return;
        }
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.TRIGGERS)) {
            LOGGER.log(Level.INFO, "Not retrieving trigger definitions, since this was not requested");
            LOGGER.log(Level.FINE, "Trigger definition SQL statement was not provided");
            return;
        }
        Query triggerInformationSql = informationSchemaViews.getQuery(InformationSchemaKey.TRIGGERS);
        switch (this.getRetrieverConnection().get(SchemaInfoMetadataRetrievalStrategy.triggersRetrievalStrategy)) {
            case data_dictionary_over_schemas: {
                LOGGER.log(Level.INFO, "Retrieving triggers, using fast data dictionary retrieval over schemas");
                this.retrieveTriggerOverSchemas(triggerInformationSql);
                break;
            }
            default: {
                LOGGER.log(Level.INFO, "Retrieving triggers, using fast data dictionary retrieval");
                this.retrieveTriggerFromDataDictionary(triggerInformationSql);
            }
        }
    }

    private boolean createTrigger(MetadataResultSet results) throws SQLException {
        MutableTrigger trigger;
        String catalogName = this.normalizeCatalogName(results.getString("TRIGGER_CATALOG"));
        String schemaName = this.normalizeSchemaName(results.getString("TRIGGER_SCHEMA"));
        String triggerName = results.getString("TRIGGER_NAME");
        LOGGER.log(Level.FINER, new StringFormat("Retrieving trigger <%s>", triggerName));
        String tableName = results.getString("EVENT_OBJECT_TABLE");
        Optional<MutableTable> tableOptional = this.lookupTable(catalogName, schemaName, tableName);
        if (tableOptional.isEmpty()) {
            LOGGER.log(Level.FINE, new StringFormat("Cannot find table <%s.%s.%s>", catalogName, schemaName, tableName));
            return false;
        }
        MutableTable table = tableOptional.get();
        Set<EventManipulationType> eventManipulationTypes = this.getEventManipulationType(results);
        int actionOrder = results.getInt("ACTION_ORDER", 0);
        String actionCondition = results.getString("ACTION_CONDITION");
        String actionStatement = results.getString("ACTION_STATEMENT");
        ActionOrientationType actionOrientation = results.getEnum("ACTION_ORIENTATION", ActionOrientationType.unknown);
        String conditionTimingString = results.getString("ACTION_TIMING");
        if (conditionTimingString == null) {
            conditionTimingString = results.getString("CONDITION_TIMING");
        }
        ConditionTimingType conditionTiming = ConditionTimingType.valueOfFromValue(conditionTimingString);
        Optional<MutableTrigger> optionalTrigger = table.lookupTrigger(triggerName);
        if (optionalTrigger.isPresent()) {
            trigger = optionalTrigger.get();
        } else {
            trigger = new MutableTrigger(table, triggerName);
            trigger.setActionOrder(actionOrder);
            trigger.appendActionCondition(actionCondition);
            trigger.appendActionStatement(actionStatement);
            trigger.setActionOrientation(actionOrientation);
            trigger.setConditionTiming(conditionTiming);
        }
        trigger.withQuoting(this.getRetrieverConnection().getIdentifiers());
        trigger.setEventManipulationTypes(eventManipulationTypes);
        trigger.addAttributes(results.getAttributes());
        table.addTrigger(trigger);
        return true;
    }

    private Set<EventManipulationType> getEventManipulationType(MetadataResultSet results) {
        if (results == null) {
            return null;
        }
        String eventManipulationString = results.getString("EVENT_MANIPULATION");
        if (Utility.isBlank(eventManipulationString)) {
            return null;
        }
        eventManipulationString = eventManipulationString.toLowerCase(Locale.ENGLISH);
        String oracleSeparator = " or ";
        String plainSeparator = ",";
        String splitBy = eventManipulationString.contains(" or ") ? " or " : (eventManipulationString.contains(",") ? "," : "");
        return EnumUtility.enumValues(eventManipulationString, splitBy, EventManipulationType.unknown);
    }

    private void retrieveTriggerFromDataDictionary(Query triggerInformationSql) throws SQLException {
        String name = "trigger definitions";
        RetrievalCounts retrievalCounts = new RetrievalCounts("trigger definitions");
        try (Connection connection = this.getRetrieverConnection().getConnection("trigger definitions");
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(triggerInformationSql, statement, this.getLimitMap());){
            while (results.next()) {
                retrievalCounts.count();
                boolean added = this.createTrigger(results);
                retrievalCounts.countIfIncluded(added);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve triggers", e);
        }
        retrievalCounts.log();
    }

    private void retrieveTriggerOverSchemas(Query triggerInformationSql) throws SQLException {
        String name = "trigger definitions";
        RetrievalCounts retrievalCounts = new RetrievalCounts("trigger definitions");
        for (Schema schema : this.getAllSchemas()) {
            if (this.catalog.getTables(schema).isEmpty()) continue;
            try (Connection connection = this.getRetrieverConnection().getConnection("trigger definitions");
                 SchemaSetter schemaSetter = new SchemaSetter(connection, schema);
                 Statement statement = connection.createStatement();
                 MetadataResultSet results = new MetadataResultSet(triggerInformationSql, statement, this.getLimitMap(schema));){
                while (results.next()) {
                    retrievalCounts.count(schema.key());
                    boolean added = this.createTrigger(results);
                    retrievalCounts.countIfIncluded(schema.key(), added);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e, new StringFormat("Could not retrieve triggers for schema <%s>", schema));
            }
            retrievalCounts.log(schema.key());
        }
        retrievalCounts.log();
    }
}

