/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.dcn.RowChangeDescription;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.ROWID;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class NTFDCNRowChanges
implements RowChangeDescription {
    EnumSet<RowChangeDescription.RowOperation> opcode;
    int rowidLength;
    byte[] rowid;
    ROWID rowidObj;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    NTFDCNRowChanges(EnumSet<RowChangeDescription.RowOperation> _opcode, int _rowidLength, byte[] _rowid) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, NTFDCNRowChanges.class, $$$methodRef$$$3, null, _opcode, _rowidLength, _rowid);
            }
            this.opcode = _opcode;
            this.rowidLength = _rowidLength;
            this.rowid = _rowid;
            this.rowidObj = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, NTFDCNRowChanges.class, $$$methodRef$$$3, null);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NTFDCNRowChanges.class, $$$methodRef$$$3, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NTFDCNRowChanges.class, $$$methodRef$$$3, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public ROWID getRowid() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, NTFDCNRowChanges.class, $$$methodRef$$$0, this, new Object[0]);
            }
            if (this.rowidObj == null) {
                this.rowidObj = new ROWID(this.rowid);
            }
            ROWID rOWID = this.rowidObj;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, NTFDCNRowChanges.class, $$$methodRef$$$0, this, rOWID);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NTFDCNRowChanges.class, $$$methodRef$$$0, this, null);
            }
            return rOWID;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NTFDCNRowChanges.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Deprecated
    public RowChangeDescription.RowOperation getRowOperation() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            Iterator iterator;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, NTFDCNRowChanges.class, $$$methodRef$$$1, this, new Object[0]);
            }
            if ((iterator = this.opcode.iterator()).hasNext()) {
                RowChangeDescription.RowOperation op;
                RowChangeDescription.RowOperation rowOperation = op = (RowChangeDescription.RowOperation)((Object)iterator.next());
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, NTFDCNRowChanges.class, $$$methodRef$$$1, this, (Object)rowOperation);
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NTFDCNRowChanges.class, $$$methodRef$$$1, this, null);
                }
                return rowOperation;
            }
            RowChangeDescription.RowOperation rowOperation = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, NTFDCNRowChanges.class, $$$methodRef$$$1, this, rowOperation);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NTFDCNRowChanges.class, $$$methodRef$$$1, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NTFDCNRowChanges.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public EnumSet<RowChangeDescription.RowOperation> getRowOperations() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, NTFDCNRowChanges.class, $$$methodRef$$$2, this, new Object[0]);
            }
            EnumSet<RowChangeDescription.RowOperation> enumSet = this.opcode;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, NTFDCNRowChanges.class, $$$methodRef$$$2, this, enumSet);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NTFDCNRowChanges.class, $$$methodRef$$$2, this, null);
            }
            return enumSet;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NTFDCNRowChanges.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    @DisableTrace
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("      ROW:  operation=" + this.getRowOperations() + ", ROWID=" + new String(this.rowid) + "\n");
        return sb.toString();
    }

    static {
        try {
            $$$methodRef$$$3 = NTFDCNRowChanges.class.getDeclaredConstructor(EnumSet.class, Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NTFDCNRowChanges.class.getDeclaredMethod("getRowOperations", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NTFDCNRowChanges.class.getDeclaredMethod("getRowOperation", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NTFDCNRowChanges.class.getDeclaredMethod("getRowid", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

