/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.generator.jdt;

import com.ibm.db2.cmx.annotation.Call;
import com.ibm.db2.cmx.annotation.Cursor;
import com.ibm.db2.cmx.annotation.Handler;
import com.ibm.db2.cmx.annotation.Select;
import com.ibm.db2.cmx.annotation.Update;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.exception.WarningFactory;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.statement.JavaType;
import com.ibm.db2.cmx.tools.internal.ToolsLogger;
import com.ibm.db2.cmx.tools.internal.generator.PatternContainer;
import com.ibm.db2.cmx.tools.internal.generator.PatternProcessor;
import com.ibm.db2.cmx.tools.internal.generator.jdt.ASTProcessor;
import com.ibm.db2.cmx.tools.internal.generator.jdt.JoinColumnValues;
import com.ibm.db2.cmx.tools.internal.generator.jdt.TypeHelper;
import com.ibm.db2.cmx.tools.internal.generator.metadata.BeanInformation;
import com.ibm.db2.cmx.tools.internal.generator.metadata.BeanPropertyInformation;
import com.ibm.db2.cmx.tools.internal.generator.metadata.ClassInfo;
import com.ibm.db2.cmx.tools.internal.generator.metadata.MethodInfo;
import com.ibm.db2.cmx.tools.internal.generator.metadata.TypeInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeParameter;

public class NodeProcessor {
    Map<String, IBinding> bindingsMap_;
    ClassInfo classInfo_;
    boolean allowGetterSetterMethodWithPublicField_;
    boolean ignoreOrphanGetterSetterMethods_;
    int uniqueId_;
    HashMap<String, String> listOfPropertiesToBeUpdatedFromNestedBeanIds_;

    public NodeProcessor(Map<String, IBinding> map, ClassInfo classInfo) {
        this.bindingsMap_ = map;
        this.classInfo_ = classInfo;
        this.allowGetterSetterMethodWithPublicField_ = true;
        this.ignoreOrphanGetterSetterMethods_ = true;
        this.uniqueId_ = 1;
        this.listOfPropertiesToBeUpdatedFromNestedBeanIds_ = new HashMap();
    }

    public void processParameter(SingleVariableDeclaration singleVariableDeclaration, TypeInfo typeInfo, MethodInfo methodInfo, int n2) {
        typeInfo.setName(singleVariableDeclaration.getName().getFullyQualifiedName());
        typeInfo.setVarargs(singleVariableDeclaration.isVarargs());
        this.processType(singleVariableDeclaration.getType(), typeInfo, methodInfo, n2, true);
        this.setBaseType(typeInfo, methodInfo);
    }

    public void processTypeParameter(TypeParameter typeParameter, MethodInfo methodInfo) {
        methodInfo.addMethodTypeParameterName(typeParameter.getName().toString());
    }

    public void processReturnType(Type type, TypeInfo typeInfo, MethodInfo methodInfo, int n2) {
        Set<String> set;
        this.processType(type, typeInfo, methodInfo, 1, false);
        typeInfo.setTypeString(type.toString());
        methodInfo.setReturnType(typeInfo);
        this.setBaseType(typeInfo, methodInfo);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nMethod Name: ");
        stringBuilder.append(methodInfo.getMethodName());
        stringBuilder.append(" Return Type: ");
        stringBuilder.append(typeInfo.toString());
        stringBuilder.append("\n");
        Map<String, BeanInformation> map = methodInfo.getOutputBeanInfoMap();
        if (map != null) {
            set = map.keySet();
            for (String string : set) {
                stringBuilder.append("************OutputBeanInfoMap key " + string + "\n");
                stringBuilder.append(map.get(string));
            }
        }
        map = methodInfo.getNestedBeansInfoMap();
        set = map.keySet();
        for (String string : set) {
            stringBuilder.append(">>>>>>>>NestedBeans key " + string + "\n");
            stringBuilder.append(map.get(string) + "\n");
        }
        ToolsLogger.getLogger().log(Level.FINEST, stringBuilder.toString());
    }

    String getModifierAsString(List<ASTNode> list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (ASTNode aSTNode : list) {
            if (aSTNode.getClass() != Modifier.class) continue;
            Modifier modifier = (Modifier)aSTNode;
            stringBuffer.append(modifier.getKeyword().toString());
        }
        return stringBuffer.toString();
    }

    void processModifierAndAnnotations(List<ASTNode> list, MethodInfo methodInfo) {
        StringBuffer stringBuffer = new StringBuffer();
        for (ASTNode aSTNode : list) {
            switch (aSTNode.getNodeType()) {
                case 83: {
                    stringBuffer.append(((Modifier)aSTNode).getKeyword().toString());
                    break;
                }
                case 77: {
                    NormalAnnotation normalAnnotation = (NormalAnnotation)aSTNode;
                    IAnnotationBinding iAnnotationBinding = normalAnnotation.resolveAnnotationBinding();
                    if (iAnnotationBinding == null) {
                        throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_RESOLVE_NODE", normalAnnotation.toString()), null, 10134, null, methodInfo);
                    }
                    Object object = this.getAnnotationType(iAnnotationBinding);
                    Object object2 = iAnnotationBinding.getDeclaredMemberValuePairs();
                    if (Select.class == object || Update.class == object || Call.class == object) {
                        methodInfo.setAnnotationType((Class<?>)object);
                        this.processMemberValuePairForAnnotation((IMemberValuePairBinding[])object2, methodInfo);
                    }
                    if (Cursor.class == object) {
                        this.processCursorAnnotation((IMemberValuePairBinding[])object2, methodInfo);
                        break;
                    }
                    if (Handler.class != object) break;
                    this.processMemberValuePairForHandlerAnnotation((IMemberValuePairBinding[])object2, methodInfo);
                    break;
                }
                case 79: {
                    NormalAnnotation normalAnnotation = (SingleMemberAnnotation)aSTNode;
                    IAnnotationBinding iAnnotationBinding = normalAnnotation.resolveAnnotationBinding();
                    if (iAnnotationBinding == null) {
                        throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_RESOLVE_NODE", normalAnnotation.toString()), null, 10749, null, methodInfo);
                    }
                    Object object = iAnnotationBinding.getDeclaredMemberValuePairs();
                    Object object2 = this.getAnnotationType(iAnnotationBinding);
                    if (Select.class != object2 && Update.class != object2 && Call.class != object2) break;
                    methodInfo.setAnnotationType((Class<?>)object2);
                    this.processMemberValuePairForAnnotation((IMemberValuePairBinding[])object, methodInfo);
                    break;
                }
                case 78: {
                    NormalAnnotation normalAnnotation = (MarkerAnnotation)aSTNode;
                    IAnnotationBinding iAnnotationBinding = normalAnnotation.resolveAnnotationBinding();
                    if (iAnnotationBinding == null) {
                        throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_RESOLVE_NODE", normalAnnotation.toString()), null, 10135, null, methodInfo);
                    }
                    Object object = this.getAnnotationType(iAnnotationBinding);
                    if (Select.class != object && Update.class != object && Call.class != object) break;
                    methodInfo.setAnnotationType((Class<?>)object);
                }
            }
            methodInfo.setModifier(stringBuffer.toString());
        }
    }

    protected Class<?> getAnnotationType(IAnnotationBinding iAnnotationBinding) {
        Class clazz = null;
        ITypeBinding iTypeBinding = iAnnotationBinding.getAnnotationType();
        if (iTypeBinding.isSubTypeCompatible((ITypeBinding)this.bindingsMap_.get(ASTProcessor.COM_IBM_PDQ_ANNOTATION_SELECT_KEY))) {
            clazz = Select.class;
        } else if (iTypeBinding.isSubTypeCompatible((ITypeBinding)this.bindingsMap_.get(ASTProcessor.COM_IBM_PDQ_ANNOTATION_UPDATE_KEY))) {
            clazz = Update.class;
        } else if (iTypeBinding.isSubTypeCompatible((ITypeBinding)this.bindingsMap_.get(ASTProcessor.COM_IBM_PDQ_ANNOTATION_CALL_KEY))) {
            clazz = Call.class;
        } else if (iTypeBinding.isSubTypeCompatible((ITypeBinding)this.bindingsMap_.get(ASTProcessor.COM_IBM_PDQ_ANNOTATION_CURSOR_KEY))) {
            clazz = Cursor.class;
        } else if (iTypeBinding.isSubTypeCompatible((ITypeBinding)this.bindingsMap_.get(ASTProcessor.COM_IBM_PDQ_ANNOTATION_HANDLER_KEY))) {
            clazz = Handler.class;
        }
        return clazz;
    }

    private void processMemberValuePairForAnnotation(IMemberValuePairBinding[] iMemberValuePairBindingArray, MethodInfo methodInfo) {
        for (IMemberValuePairBinding iMemberValuePairBinding : iMemberValuePairBindingArray) {
            String string;
            String string2 = iMemberValuePairBinding.getName();
            if ("sql".equals(string2) || "value".equals(string2)) {
                string = (String)iMemberValuePairBinding.getValue();
                if ("".equals(string)) continue;
                methodInfo.setSql(string);
                continue;
            }
            if ("pattern".equals(string2)) {
                string = (String)iMemberValuePairBinding.getValue();
                methodInfo.setPatternString(string);
                this.processPattern(methodInfo);
                continue;
            }
            if (!"positionedCursorName".equals(string2) || (string = (String)iMemberValuePairBinding.getValue()) == null || string.length() <= 0) continue;
            methodInfo.setPositionedCursorName(string);
        }
    }

    private void processMemberValuePairForHandlerAnnotation(IMemberValuePairBinding[] iMemberValuePairBindingArray, MethodInfo methodInfo) {
        for (IMemberValuePairBinding iMemberValuePairBinding : iMemberValuePairBindingArray) {
            String string = iMemberValuePairBinding.getName();
            if ("callHandlerWithParameters".equals(string)) {
                methodInfo.setCallHandlerClassNameFromAnnotation(this.getValueNameAndSetPackageInClassInfoImportList(iMemberValuePairBinding));
                methodInfo.setQualifiedCallHandlerClassNameFromAnnotation(((ITypeBinding)iMemberValuePairBinding.getValue()).getQualifiedName());
                methodInfo.setCallHandlerType(MethodInfo.HandlerType.HandlerProvidedInMethodAnnotation);
                continue;
            }
            if ("rowHandler".equals(string)) {
                methodInfo.setRowHandlerClassNameFromAnnotation(this.getValueNameAndSetPackageInClassInfoImportList(iMemberValuePairBinding));
                methodInfo.setQualifiedRowHandlerClassNameFromAnnotation(((ITypeBinding)iMemberValuePairBinding.getValue()).getQualifiedName());
                methodInfo.setRowHandlerType(MethodInfo.HandlerType.HandlerProvidedInMethodAnnotation);
                continue;
            }
            if ("rowHandlerWithParameters".equals(string)) {
                methodInfo.setRowHandlerWithParametersClassNameFromAnnotation(this.getValueNameAndSetPackageInClassInfoImportList(iMemberValuePairBinding));
                methodInfo.setQualifiedRowHandlerWithParametersClassNameFromAnnotation(((ITypeBinding)iMemberValuePairBinding.getValue()).getQualifiedName());
                methodInfo.setRowHandlerWithParametersType(MethodInfo.HandlerType.HandlerProvidedInMethodAnnotation);
                continue;
            }
            if ("resultHandler".equals(string)) {
                methodInfo.setResultHandlerClassNameFromAnnotation(this.getValueNameAndSetPackageInClassInfoImportList(iMemberValuePairBinding));
                methodInfo.setQualifiedResultHandlerClassNameFromAnnotation(((ITypeBinding)iMemberValuePairBinding.getValue()).getQualifiedName());
                methodInfo.setResultHandlerType(MethodInfo.HandlerType.HandlerProvidedInMethodAnnotation);
                continue;
            }
            if (!"parameterHandler".equals(string)) continue;
            methodInfo.setParameterHandlerClassNameFromAnnotation(this.getValueNameAndSetPackageInClassInfoImportList(iMemberValuePairBinding));
            methodInfo.setQualifiedParameterHandlerClassNameFromAnnotation(((ITypeBinding)iMemberValuePairBinding.getValue()).getQualifiedName());
            methodInfo.setParameterHandlerType(MethodInfo.HandlerType.HandlerProvidedInMethodAnnotation);
        }
    }

    private String getValueNameAndSetPackageInClassInfoImportList(IMemberValuePairBinding iMemberValuePairBinding) {
        ITypeBinding iTypeBinding = (ITypeBinding)iMemberValuePairBinding.getValue();
        if (iTypeBinding == null) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_RESOLVE_NODE", iMemberValuePairBinding.toString()), null, 10831, null, null);
        }
        this.classInfo_.addImportDeclaration(iTypeBinding.getQualifiedName());
        return iTypeBinding.getName();
    }

    ITypeBinding processSimpleType(SimpleType simpleType, TypeInfo typeInfo, MethodInfo methodInfo) {
        String string;
        ITypeBinding iTypeBinding = simpleType.resolveBinding();
        if (iTypeBinding == null) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_RESOLVE_NODE", simpleType.toString()), null, 10136, (ASTNode)simpleType, methodInfo);
        }
        typeInfo.setSimpleType(true);
        IPackageBinding iPackageBinding = iTypeBinding.getPackage();
        ITypeBinding[] iTypeBindingArray = iTypeBinding.getTypeArguments();
        if (iTypeBindingArray != null && iTypeBindingArray.length > 0) {
            typeInfo.setBaseType(this.getTypeInfo(null, iTypeBindingArray[0], simpleType));
        }
        typeInfo.setTypeName(iTypeBinding.getName());
        String string2 = null;
        if (!iTypeBinding.isTypeVariable() && !iTypeBinding.isWildcardType()) {
            if (null == iPackageBinding) {
                throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_ITYPEBINDING_WITH_NULL_PACKAGE", iTypeBinding.getQualifiedName()), null, 10561, (ASTNode)simpleType, methodInfo);
            }
            string2 = iPackageBinding.getName();
            typeInfo.setPackageName(string2);
        }
        typeInfo.setQualifiedName(iTypeBinding.getQualifiedName());
        if (!iTypeBinding.isTypeVariable()) {
            this.addImportStatement(string2, typeInfo.getTypeNameToImport());
        }
        typeInfo.setJavaType(TypeHelper.getJavaType(iTypeBinding.getTypeDeclaration().getQualifiedName(), simpleType.getAST(), iTypeBinding, this.bindingsMap_));
        if (typeInfo.getJavaType() == JavaType.BEAN && !string2.startsWith("java.")) {
            typeInfo.setBeanType(true);
        } else {
            typeInfo.setBeanType(false);
        }
        if ("java.lang".equals(string2) && ("Integer".equals(string = typeInfo.getTypeName()) || "Short".equals(string) || "Float".equals(string) || "Double".equals(string) || "Character".equals(string) || "Boolean".equals(string) || "Long".equals(string) || "Byte".equals(string))) {
            typeInfo.setPrimitiveOrWrapper(true);
        }
        return iTypeBinding;
    }

    void processSimpleType(SimpleType simpleType, TypeInfo typeInfo, MethodInfo methodInfo, int n2, boolean bl2) {
        ITypeBinding iTypeBinding = this.processSimpleType(simpleType, typeInfo, methodInfo);
        if (typeInfo.isBeanType()) {
            this.processBeanInformation(iTypeBinding.getErasure(), methodInfo, simpleType, typeInfo, n2, bl2, false);
        }
    }

    private ITypeBinding getParameterOrReturnTypeBinding(IMethodBinding iMethodBinding, String string) {
        ITypeBinding iTypeBinding = null;
        if (string.startsWith("get")) {
            iTypeBinding = iMethodBinding.getReturnType();
        } else if (string.startsWith("set")) {
            ITypeBinding[] iTypeBindingArray = iMethodBinding.getParameterTypes();
            iTypeBinding = iTypeBindingArray.length > 0 ? iTypeBindingArray[0] : null;
        }
        return iTypeBinding;
    }

    private void addColumnOverrideToMap(ITypeBinding iTypeBinding, Map<String, BeanPropertyInformation> map, SimpleType simpleType, MethodInfo methodInfo) {
        IAnnotationBinding[] iAnnotationBindingArray;
        boolean bl2 = false;
        boolean bl3 = false;
        for (IAnnotationBinding iAnnotationBinding : iAnnotationBindingArray = iTypeBinding.getAnnotations()) {
            ITypeBinding iTypeBinding2 = iAnnotationBinding.getAnnotationType();
            String string = iTypeBinding2.getQualifiedName();
            if ("com.ibm.db2.cmx.annotation.ColumnOverrides".equals(string)) {
                IMemberValuePairBinding[] iMemberValuePairBindingArray;
                if (bl3) {
                    throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_COLOVER", iTypeBinding.getQualifiedName()), null, 10137, (ASTNode)simpleType, methodInfo);
                }
                bl2 = true;
                for (IMemberValuePairBinding iMemberValuePairBinding : iMemberValuePairBindingArray = iAnnotationBinding.getDeclaredMemberValuePairs()) {
                    Object[] objectArray;
                    for (Object object : objectArray = (Object[])iMemberValuePairBinding.getValue()) {
                        IAnnotationBinding iAnnotationBinding2 = (IAnnotationBinding)object;
                        this.getColumnOverrideAnnotation(map, iAnnotationBinding2);
                    }
                }
                continue;
            }
            if (!"com.ibm.db2.cmx.annotation.ColumnOverride".equals(string)) continue;
            if (bl2) {
                throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_COLOVER2", iTypeBinding.getQualifiedName()), null, 10138, (ASTNode)simpleType, methodInfo);
            }
            bl3 = true;
            this.getColumnOverrideAnnotation(map, iAnnotationBinding);
        }
        iTypeBinding = iTypeBinding.getSuperclass();
    }

    private void getColumnOverrideAnnotation(Map<String, BeanPropertyInformation> map, IAnnotationBinding iAnnotationBinding) {
        IMemberValuePairBinding[] iMemberValuePairBindingArray;
        String string = null;
        String string2 = null;
        for (IMemberValuePairBinding iMemberValuePairBinding : iMemberValuePairBindingArray = iAnnotationBinding.getAllMemberValuePairs()) {
            String string3 = iMemberValuePairBinding.getName();
            if ("propertyName".equals(string3)) {
                string2 = (String)iMemberValuePairBinding.getValue();
                if (iMemberValuePairBinding.isDefault() || "".equals(string2)) {
                    string2 = null;
                }
            }
            if (!"column".equals(string3)) continue;
            string = (String)iMemberValuePairBinding.getValue();
            if (!iMemberValuePairBinding.isDefault() && !"".equals(string)) continue;
            string = null;
        }
        if (string != null && string2 != null && !map.containsKey(string2)) {
            map.put(string2, new BeanPropertyInformation(string));
        }
    }

    private String getPropertyName(String string, MethodInfo methodInfo) {
        if (string.startsWith("get")) {
            return string.substring(3, 4).toLowerCase() + string.substring(4, string.indexOf(40));
        }
        if (string.startsWith("is")) {
            return string.substring(2, 3).toLowerCase() + string.substring(3, string.indexOf(40));
        }
        if (string.startsWith("set")) {
            return string.substring(3, 4).toLowerCase() + string.substring(4, string.indexOf(40));
        }
        throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_INV_METHOD", string), null, 10139, null, methodInfo);
    }

    private String getSetterMethodName(String string, MethodInfo methodInfo) {
        if (string.startsWith("get")) {
            return "set" + string.substring(3);
        }
        if (string.startsWith("is")) {
            return "set" + string.substring(2);
        }
        throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_INV_METHOD", string), null, 10140, null, methodInfo);
    }

    private String getGetterMethodName(String string, MethodInfo methodInfo) {
        if (string.startsWith("set")) {
            return "get" + string.substring(3);
        }
        throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_INV_METHOD", string), null, 11207, null, methodInfo);
    }

    private String getMethodNameFromSignature(String string) {
        return string.substring(0, string.indexOf(40));
    }

    void processBeanInformation(ITypeBinding iTypeBinding, MethodInfo methodInfo, SimpleType simpleType, TypeInfo typeInfo, int n2, boolean bl2, boolean bl3) {
        HashMap<String, IVariableBinding> hashMap = new HashMap<String, IVariableBinding>();
        HashMap<String, IMethodBinding> hashMap2 = new HashMap<String, IMethodBinding>();
        HashMap<String, IMethodBinding> hashMap3 = new HashMap<String, IMethodBinding>();
        HashMap<String, BeanPropertyInformation> hashMap4 = new HashMap<String, BeanPropertyInformation>();
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        this.getInherited(simpleType, iTypeBinding, linkedList, linkedList2, hashMap, hashMap3, hashMap2, hashMap4, methodInfo);
        ToolsLogger.getLogger().log(Level.FINEST, "[DEBUG] Table Annotation: " + linkedList2.toString());
        BeanInformation beanInformation = new BeanInformation(iTypeBinding.getQualifiedName());
        beanInformation.setBeanInteritanceList(linkedList);
        beanInformation.setHasGenericSetWithParamsMethod(this.hasAllPurposeSetMethod(iTypeBinding));
        beanInformation.setBeanTypeInfo(typeInfo);
        if (linkedList2.size() > 0 && methodInfo.getPatternContainer() == null) {
            beanInformation.setTableNameAnnotation(linkedList2.getFirst());
        }
        this.extractBeanPropertyInformationFromMethods(simpleType, bl2, hashMap, hashMap2, hashMap3, hashMap4, beanInformation, methodInfo, false);
        HashMap<String, IMethodBinding> hashMap5 = new HashMap<String, IMethodBinding>();
        Set set = hashMap2.keySet();
        for (String string : set) {
            String string2 = this.getGetterMethodName(string, methodInfo);
            String string3 = this.getPropertyName(string2, methodInfo);
            if (beanInformation.getPropertyUsingCaseSensitiveName(string3) != null) continue;
            hashMap5.put(string2, (IMethodBinding)hashMap2.get(string));
        }
        if (hashMap5.size() > 0) {
            this.extractBeanPropertyInformationFromMethods(simpleType, bl2, hashMap, hashMap2, hashMap5, hashMap4, beanInformation, methodInfo, true);
        }
        this.extractBeanPropertyInformationFromFields(simpleType, bl2, hashMap, hashMap4, beanInformation, methodInfo);
        ToolsLogger.getLogger().log(Level.FINEST, "[DEBUG] processBeanInformation, new bean: " + beanInformation.getFullyQualifiedName() + "\n" + beanInformation.toString());
        if (bl2) {
            methodInfo.addInputBeanInfo(n2, beanInformation);
        } else if (bl3) {
            if (beanInformation.getIdKeys().size() > 0) {
                methodInfo.addToNestedBeansInfoMap(iTypeBinding.getQualifiedName(), beanInformation);
                this.checkBeanForNestedBean(simpleType, iTypeBinding, methodInfo, hashMap, hashMap2, hashMap3, hashMap4, beanInformation);
            } else {
                beanInformation.setIdLessBean(true);
                methodInfo.addToNestedBeansInfoMap(iTypeBinding.getQualifiedName(), beanInformation);
            }
        } else {
            methodInfo.addOutputBeanInfoMap(iTypeBinding.getQualifiedName(), beanInformation);
            this.checkBeanForNestedBean(simpleType, iTypeBinding, methodInfo, hashMap, hashMap2, hashMap3, hashMap4, beanInformation);
        }
    }

    private void checkBeanForNestedBean(SimpleType simpleType, ITypeBinding iTypeBinding, MethodInfo methodInfo, Map<String, IVariableBinding> map, Map<String, IMethodBinding> map2, Map<String, IMethodBinding> map3, Map<String, BeanPropertyInformation> map4, BeanInformation beanInformation) {
        Logger logger = ToolsLogger.getLogger();
        logger.log(Level.FINEST, "methodName: " + methodInfo.getMethodName() + " , simpleType: " + simpleType.toString() + ", simpleTypeBinding: " + iTypeBinding.getQualifiedName() + ", variableBindingMap: " + map.keySet().toString() + ", setterMethodBindingMap: " + map2.keySet().toString() + ", getterMethodBindingMap: " + map3.keySet().toString() + ", Ids: " + beanInformation.getIdKeys().toString() + ", IdsTable: " + beanInformation.getIdKeysTable().toString() + "\nbeanInfo:\n" + beanInformation.toString() + "\ncolumnOverrideMap: " + map4.keySet().toString() + this.printArray(false, map4.values().toArray()));
        Map<String, BeanPropertyInformation> map5 = beanInformation.getBeanPropertyMap();
        Set<String> set = map5.keySet();
        for (String string : set) {
            BeanPropertyInformation beanPropertyInformation = map5.get(string);
            while (beanPropertyInformation != null) {
                TypeInfo typeInfo = beanPropertyInformation.getPropertyTypeInfo();
                if (typeInfo.getJavaType() == JavaType.LIST) {
                    TypeInfo typeInfo2 = typeInfo.getBaseType();
                    if (typeInfo2 == null || typeInfo2.getJavaType() != JavaType.BEAN) {
                        beanPropertyInformation = beanPropertyInformation.getNextBeanPropInfo();
                        continue;
                    }
                    typeInfo = typeInfo2;
                } else if (typeInfo.getJavaType() != JavaType.BEAN) {
                    beanPropertyInformation = beanPropertyInformation.getNextBeanPropInfo();
                    continue;
                }
                String string2 = typeInfo.getQualifiedName();
                if (!methodInfo.getOutputBeanInfoMap().containsKey(string2) && !methodInfo.getNestedBeansInfoMap().containsKey(string2)) {
                    logger.log(Level.FINEST, "Nested Bean added(dummy): " + string2);
                    methodInfo.addToNestedBeansInfoMap(string2, null);
                    ITypeBinding iTypeBinding2 = null;
                    String string3 = beanPropertyInformation.getField();
                    logger.log(Level.FINEST, "field name: " + string3);
                    if (string3 != null) {
                        logger.log(Level.FINEST, "found field name: " + string3);
                        IVariableBinding iVariableBinding = map.get(string3);
                        iTypeBinding2 = iVariableBinding.getType();
                        iTypeBinding2 = this.getBeanITypeBinding(simpleType, iTypeBinding2, string3);
                    } else {
                        iTypeBinding2 = this.getReturnBeanITypeBinging(simpleType, map3, beanPropertyInformation);
                        if (iTypeBinding2 == null) {
                            iTypeBinding2 = this.getParameter1BeanITypeBinding(simpleType, map2, beanPropertyInformation);
                        }
                    }
                    if (iTypeBinding2 == null) {
                        logger.log(Level.FINEST, "logic error, propertyName: " + beanPropertyInformation.getCaseSensitivePropertyName() + ", could not find field, setter or getter method");
                    }
                    logger.log(Level.FINEST, "call processBeanInformation for: " + iTypeBinding2.getQualifiedName());
                    this.processBeanInformation(iTypeBinding2, methodInfo, simpleType, typeInfo, 0, false, true);
                }
                beanPropertyInformation = beanPropertyInformation.getNextBeanPropInfo();
            }
        }
    }

    private ITypeBinding getParameter1BeanITypeBinding(SimpleType simpleType, Map<String, IMethodBinding> map, BeanPropertyInformation beanPropertyInformation) {
        Logger logger = ToolsLogger.getLogger();
        ITypeBinding iTypeBinding = null;
        String string = beanPropertyInformation.getWriteMethod();
        logger.log(Level.FINEST, "setter name: " + string);
        if (string != null) {
            logger.log(Level.FINEST, "found setter name: " + string);
            String string2 = string + "(";
            Set<String> set = map.keySet();
            for (String string3 : set) {
                if (!string3.startsWith(string2)) continue;
                string = string3;
            }
            IMethodBinding iMethodBinding = map.get(string);
            if (iMethodBinding != null) {
                logger.log(Level.FINEST, "found setter method binding: " + string);
                ITypeBinding[] iTypeBindingArray = iMethodBinding.getParameterTypes();
                if (iTypeBindingArray.length > 0) {
                    logger.log(Level.FINEST, "found setter parm 1 binding: " + string);
                    iTypeBinding = iTypeBindingArray[0];
                    iTypeBinding = this.getBeanITypeBinding(simpleType, iTypeBinding, string);
                }
            } else {
                logger.log(Level.FINEST, "logic error, setter Method: " + string + ", setter method does not have at least 1 parm");
            }
        }
        return iTypeBinding;
    }

    private ITypeBinding getReturnBeanITypeBinging(SimpleType simpleType, Map<String, IMethodBinding> map, BeanPropertyInformation beanPropertyInformation) {
        Logger logger = ToolsLogger.getLogger();
        ITypeBinding iTypeBinding = null;
        String string = beanPropertyInformation.getReadMethod();
        logger.log(Level.FINEST, "getter name: " + string);
        if (string != null) {
            logger.log(Level.FINEST, "found getter name: " + string);
            String string2 = string + "(";
            Set<String> set = map.keySet();
            for (String string3 : set) {
                if (!string3.startsWith(string2)) continue;
                string = string3;
            }
            IMethodBinding iMethodBinding = map.get(string);
            if (iMethodBinding != null) {
                logger.log(Level.FINEST, "found getter method binding: " + string);
                iTypeBinding = iMethodBinding.getReturnType();
                logger.log(Level.FINEST, "getReturnBeanITypeBinging, getter Return Type binding: " + (iTypeBinding != null ? iTypeBinding.getErasure().getQualifiedName() : "null"));
                if (iTypeBinding != null) {
                    iTypeBinding = this.getBeanITypeBinding(simpleType, iTypeBinding, string);
                }
            }
        }
        return iTypeBinding;
    }

    private ITypeBinding getBeanITypeBinding(SimpleType simpleType, ITypeBinding iTypeBinding, String string) {
        Logger logger = ToolsLogger.getLogger();
        logger.log(Level.FINEST, "name: " + string);
        TypeInfo typeInfo = this.getTypeInfo(string, iTypeBinding, simpleType);
        if (typeInfo.getJavaType() == JavaType.LIST) {
            logger.log(Level.FINEST, "LIST, name: " + string);
            typeInfo = typeInfo.getBaseType();
            if (typeInfo.getJavaType() != JavaType.BEAN) {
                logger.log(Level.FINEST, "logic error, fieldName: " + string + ", is TYPE LIST and BaseType is " + (Object)((Object)typeInfo.getJavaType()) + ", should be BEAN");
            }
            logger.log(Level.FINEST, "Base Type is BEAN name: " + string);
            ITypeBinding[] iTypeBindingArray = iTypeBinding.getTypeArguments();
            if (iTypeBindingArray != null && iTypeBindingArray.length > 0) {
                iTypeBinding = iTypeBindingArray[0];
            }
        } else {
            if (typeInfo.getJavaType() != JavaType.BEAN) {
                logger.log(Level.FINEST, "logic error, fieldName: " + string + ", is TYPE: " + (Object)((Object)typeInfo.getJavaType()) + ", should be BEAN");
            }
            logger.log(Level.FINEST, "Base Type is BEAN name: " + string);
        }
        logger.log(Level.FINEST, "Bean Type is: " + iTypeBinding.getQualifiedName() + " for: " + string);
        return iTypeBinding;
    }

    private void extractBeanPropertyInformationFromFields(SimpleType simpleType, boolean bl2, Map<String, IVariableBinding> map, Map<String, BeanPropertyInformation> map2, BeanInformation beanInformation, MethodInfo methodInfo) {
        String string = beanInformation.getTableNameAnnotation();
        Set<String> set = map.keySet();
        for (String string2 : set) {
            String string3;
            BeanPropertyInformation beanPropertyInformation;
            Object object;
            Object object2;
            boolean bl3 = false;
            boolean bl4 = false;
            String string4 = string2.toLowerCase();
            BeanPropertyInformation beanPropertyInformation2 = beanInformation.getPropertyUsingCaseSensitiveName(string4);
            if (beanPropertyInformation2 != null) {
                if (beanPropertyInformation2.getWriteMethod() != null && beanPropertyInformation2.getReadMethod() != null) continue;
                beanPropertyInformation2.setField(string2);
                continue;
            }
            IVariableBinding iVariableBinding = map.get(string2);
            TypeInfo typeInfo = this.getFieldInfo(string2, iVariableBinding, simpleType);
            List<JoinColumnValues> list = null;
            if (!bl2 && (list = this.getJoinColumnAnnotations((IBinding)iVariableBinding)).size() > 0) {
                bl4 = true;
            }
            BeanPropertyInformation beanPropertyInformation3 = new BeanPropertyInformation(string2);
            String string5 = beanPropertyInformation3.getCaseSensitivePropertyName();
            String string6 = beanPropertyInformation3.getCaseSensitivePropertyName().toLowerCase();
            BeanPropertyInformation beanPropertyInformation4 = null;
            BeanPropertyInformation beanPropertyInformation5 = null;
            if (bl4) {
                int n2 = list.size();
                object2 = beanInformation.getFullyQualifiedName();
                for (int i10 = 0; i10 < n2; ++i10) {
                    object = list.get(i10);
                    if (i10 == 0 && ((JoinColumnValues)object).joinColumnColumnPropertyName.equals("*")) {
                        ((JoinColumnValues)object).joinColumnColumnPropertyName = ((JoinColumnValues)object).joinColumnColumnName = this.generateUniqueId();
                        this.listOfPropertiesToBeUpdatedFromNestedBeanIds_.put(((JoinColumnValues)object).joinColumnColumnPropertyName, (String)object2);
                        ToolsLogger.getLogger().log(Level.FINEST, "[DEBUG] Adding to List of beans with default JoinPoint, Bean name: " + (String)object2 + ", propertyName: " + ((JoinColumnValues)object).joinColumnColumnPropertyName);
                    }
                    BeanPropertyInformation beanPropertyInformation6 = new BeanPropertyInformation();
                    beanPropertyInformation6.setPropertyTypeInfo(typeInfo);
                    beanPropertyInformation6.setField(string2);
                    beanPropertyInformation6.setCaseSensitivePropertyName(string2);
                    beanPropertyInformation6.setDerivedProperty(true);
                    beanPropertyInformation6.setInputValueRequired(this.getRequiredAnnotation((IBinding)iVariableBinding));
                    this.checkAndSetFormatterClassFromAnnotationOnField((IBinding)iVariableBinding, beanPropertyInformation6);
                    if (((JoinColumnValues)object).joinColumnColumnTableName != null) {
                        beanPropertyInformation6.setTableName(((JoinColumnValues)object).joinColumnColumnTableName.toLowerCase());
                    }
                    if (n2 > 1 && ((JoinColumnValues)object).joinColumnPropertyNameFromDefault) {
                        String string7 = typeInfo.getJavaType() == JavaType.BEAN ? typeInfo.getQualifiedName() : typeInfo.getBaseType().getQualifiedName();
                        throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_RESULTHANDLER_ACTUAL_PROP_NAME", object2, string7, ((JoinColumnValues)object).joinColumnColumnPropertyName), null, 11202, null, methodInfo);
                    }
                    beanPropertyInformation6.setJoinPointPropertyName(((JoinColumnValues)object).joinColumnColumnPropertyName, ((JoinColumnValues)object).joinColumnPropertyNameFromDefault);
                    beanPropertyInformation6.setJoinPointColumnPrefix(((JoinColumnValues)object).joinColumnColumnPrefix);
                    beanPropertyInformation6.setJoinPointProperty(true);
                    beanInformation.addBeanPropertyMap(((JoinColumnValues)object).joinColumnColumnName.toLowerCase(), beanPropertyInformation6);
                    if (beanPropertyInformation4 == null) {
                        beanPropertyInformation4 = beanPropertyInformation6;
                        beanPropertyInformation5 = beanPropertyInformation6;
                        beanPropertyInformation6.setNextJoinPointPropInfo(beanPropertyInformation6);
                        continue;
                    }
                    beanPropertyInformation6.setNextJoinPointPropInfo(beanPropertyInformation5.getNextJoinPointPropInfo());
                    beanPropertyInformation5.setNextJoinPointPropInfo(beanPropertyInformation6);
                    beanPropertyInformation5 = beanPropertyInformation6;
                }
            } else {
                object = this.getColumnAnnotation((IBinding)iVariableBinding, string);
                beanPropertyInformation = map2.get(string2);
                if (beanPropertyInformation != null) {
                    beanPropertyInformation3 = beanPropertyInformation;
                    bl3 = true;
                } else if (object != null) {
                    beanPropertyInformation3 = object;
                    bl3 = true;
                }
                string5 = beanPropertyInformation3.getCaseSensitivePropertyName();
                string6 = string5.toLowerCase();
                if (bl3) {
                    object2 = new BeanPropertyInformation(string2);
                    ((BeanPropertyInformation)object2).setPropertyTypeInfo(typeInfo);
                    ((BeanPropertyInformation)object2).setField(string2);
                    ((BeanPropertyInformation)object2).setCaseSensitivePropertyName(string2);
                    ((BeanPropertyInformation)object2).setDerivedProperty(true);
                    ((BeanPropertyInformation)object2).setTableName(beanPropertyInformation3.getTableName());
                    ((BeanPropertyInformation)object2).setJoinPointPropertyName(string6, true);
                    ((BeanPropertyInformation)object2).setInputValueRequired(this.getRequiredAnnotation((IBinding)iVariableBinding));
                    this.checkAndSetFormatterClassFromAnnotationOnField((IBinding)iVariableBinding, (BeanPropertyInformation)object2);
                    beanInformation.addBeanPropertyMap(string6, (BeanPropertyInformation)object2);
                }
            }
            if ((string3 = this.getGeneratedKeyInformation((IBinding)iVariableBinding, beanPropertyInformation3.getCaseSensitivePropertyName())) != null) {
                beanInformation.addAutoGeneratedKeys(string3);
                object = null;
                if (bl3) {
                    object = beanPropertyInformation3.getTableName();
                }
                ToolsLogger.getLogger().log(Level.FINEST, "Has @GeneratedKey annotation: , ColumnName: " + string5 + ", TableName: " + (String)object);
            }
            if ((object = this.getIdInformation((IBinding)iVariableBinding, string5)) != null) {
                beanInformation.addIdKeys((String)object);
                String string8 = string;
                if (bl3) {
                    string8 = beanPropertyInformation3.getTableName();
                }
                beanInformation.addIdKeysTable(string8);
                ToolsLogger.getLogger().log(Level.FINEST, "Has @Id annotation. ColumnName: " + (String)object + ", TableName: " + string8);
            }
            beanPropertyInformation = new BeanPropertyInformation();
            beanPropertyInformation.setPropertyTypeInfo(typeInfo);
            beanPropertyInformation.setField(string2);
            beanPropertyInformation.setCaseSensitivePropertyName(string2);
            beanPropertyInformation.setTableName(string);
            beanPropertyInformation.setJoinPointPropertyName(string2, false);
            beanPropertyInformation.setOverriddenProperty(bl3 | bl4);
            beanPropertyInformation.setInputValueRequired(this.getRequiredAnnotation((IBinding)iVariableBinding));
            this.checkAndSetFormatterClassFromAnnotationOnField((IBinding)iVariableBinding, beanPropertyInformation);
            if (bl4) {
                beanPropertyInformation.setNextJoinPointPropInfo(beanPropertyInformation4);
                beanPropertyInformation5.setNextJoinPointPropInfo(beanPropertyInformation);
            }
            beanInformation.addBeanPropertyMap(string4.toLowerCase(), beanPropertyInformation);
        }
    }

    private boolean hasAllPurposeSetMethod(ITypeBinding iTypeBinding) {
        IMethodBinding[] iMethodBindingArray;
        for (IMethodBinding iMethodBinding : iMethodBindingArray = iTypeBinding.getDeclaredMethods()) {
            ITypeBinding[] iTypeBindingArray;
            String string = iMethodBinding.getName();
            if (!"set".equals(string) || iMethodBinding == null || !"void".equals(iMethodBinding.getReturnType().getQualifiedName()) || !Modifier.isPublic((int)iMethodBinding.getModifiers()) || (iTypeBindingArray = iMethodBinding.getParameterTypes()).length != 4 || !"java.lang.String".equals(iTypeBindingArray[0].getQualifiedName()) || !"java.lang.String".equals(iTypeBindingArray[1].getQualifiedName()) || !"int".equals(iTypeBindingArray[2].getQualifiedName()) || !"java.lang.Object".equals(iTypeBindingArray[3].getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    private void extractBeanPropertyInformationFromMethods(SimpleType simpleType, boolean bl2, Map<String, IVariableBinding> map, Map<String, IMethodBinding> map2, Map<String, IMethodBinding> map3, Map<String, BeanPropertyInformation> map4, BeanInformation beanInformation, MethodInfo methodInfo, boolean bl3) {
        List<JoinColumnValues> list;
        Object object;
        String string = beanInformation.getTableNameAnnotation();
        Set<String> set = map3.keySet();
        StringBuilder stringBuilder = new StringBuilder();
        Object object2 = set.iterator();
        while (object2.hasNext()) {
            Object object3;
            String string2;
            Object object4;
            object = object2.next();
            List<JoinColumnValues> list2 = null;
            List<JoinColumnValues> list3 = null;
            List<JoinColumnValues> list4 = null;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            BeanPropertyInformation beanPropertyInformation = null;
            BeanPropertyInformation beanPropertyInformation2 = null;
            BeanPropertyInformation beanPropertyInformation3 = null;
            if (((String)object).equals("get")) {
                object4 = map2.remove("set");
                beanInformation.setParameterWrapperForGetMethod("get");
                if (object4 == null) continue;
                beanInformation.setParameterWrapperForGetMethod("set");
                continue;
            }
            object4 = new BeanPropertyInformation(this.getPropertyName((String)object, methodInfo));
            String string3 = this.getSetterMethodName((String)object, methodInfo);
            IMethodBinding iMethodBinding = map2.remove(string3);
            IMethodBinding iMethodBinding2 = map3.get(object);
            if (iMethodBinding == null && !this.ignoreOrphanGetterSetterMethods_) {
                stringBuilder.append("\n" + Messages.getText("ERR_BEAN_GET_NO_SET", iMethodBinding2.toString()));
                continue;
            }
            IVariableBinding iVariableBinding = map.remove(this.getPropertyName((String)object, methodInfo));
            if (iVariableBinding != null) {
                if (!this.allowGetterSetterMethodWithPublicField_) {
                    stringBuilder.append("\n" + Messages.getText("ERR_PUBLIC_FIELD_AND_PUBLIC_METHOD", iMethodBinding2.toString()));
                    continue;
                }
                if (iMethodBinding == null || iMethodBinding2 == null) {
                    map.put(this.getPropertyName((String)object, methodInfo), iVariableBinding);
                }
                list2 = this.getJoinColumnAnnotations((IBinding)iVariableBinding);
                if (!bl2 && list2.size() > 0) {
                    bl5 = true;
                } else {
                    beanPropertyInformation = this.getColumnAnnotation((IBinding)iVariableBinding, string);
                }
            }
            TypeInfo typeInfo = !bl3 ? this.getTypeInfo(((BeanPropertyInformation)object4).getCaseSensitivePropertyName(), iMethodBinding2.getReturnType(), simpleType) : this.getTypeInfo(((BeanPropertyInformation)object4).getCaseSensitivePropertyName(), iMethodBinding2.getParameterTypes()[0], simpleType);
            list3 = this.getJoinColumnAnnotations((IBinding)iMethodBinding2);
            if (!bl2 && list3.size() > 0) {
                bl6 = true;
            } else {
                beanPropertyInformation3 = this.getColumnAnnotation((IBinding)iMethodBinding2, string);
            }
            if (!bl3 && iMethodBinding != null) {
                list4 = this.getJoinColumnAnnotations((IBinding)iMethodBinding);
                if (!bl2 && list4.size() > 0) {
                    bl7 = true;
                } else {
                    beanPropertyInformation2 = this.getColumnAnnotation((IBinding)iMethodBinding, string);
                }
            }
            if (!bl3 && beanPropertyInformation3 != null && beanPropertyInformation2 != null && !beanPropertyInformation3.equals(beanPropertyInformation2)) {
                stringBuilder.append("\n" + Messages.getText("ERR_ANNOT_DIFF", beanPropertyInformation3, beanPropertyInformation2));
                continue;
            }
            if (beanPropertyInformation3 != null && beanPropertyInformation != null && !beanPropertyInformation3.equals(beanPropertyInformation)) {
                stringBuilder.append("\n" + Messages.getText("ERR_ANNOT_DIFF_FIELD_VS_METHOD", beanPropertyInformation3, beanPropertyInformation));
                continue;
            }
            if (!bl3 && bl6 && bl7 && !list3.equals(list4)) {
                stringBuilder.append("\n" + Messages.getText("ERR_REF_ANNOT_DIFF", list3, list4));
                continue;
            }
            if (bl6 && bl5 && !list3.equals(list2)) {
                stringBuilder.append("\n" + Messages.getText("ERR_REF_ANNOT_DIFF_FIELD_VS_METHOD", list3, list2));
                continue;
            }
            if (bl7 && bl5 && !list4.equals(list2)) {
                stringBuilder.append("\n" + Messages.getText("ERR_REF_ANNOT_DIFF_FIELD_VS_METHOD", list4, list2));
                continue;
            }
            String string4 = ((BeanPropertyInformation)object4).getCaseSensitivePropertyName();
            String string5 = ((BeanPropertyInformation)object4).getCaseSensitivePropertyName().toLowerCase();
            BeanPropertyInformation beanPropertyInformation4 = null;
            BeanPropertyInformation beanPropertyInformation5 = null;
            if (bl6 || bl7 || bl5) {
                bl8 = true;
                list = bl6 ? list3 : (bl7 ? list4 : list2);
                int n2 = list.size();
                string2 = beanInformation.getFullyQualifiedName();
                for (int i10 = 0; i10 < n2; ++i10) {
                    object3 = list.get(i10);
                    if (i10 == 0 && ((JoinColumnValues)object3).joinColumnColumnPropertyName.equals("*")) {
                        ((JoinColumnValues)object3).joinColumnColumnPropertyName = ((JoinColumnValues)object3).joinColumnColumnName = this.generateUniqueId();
                        this.listOfPropertiesToBeUpdatedFromNestedBeanIds_.put(((JoinColumnValues)object3).joinColumnColumnPropertyName, string2);
                        ToolsLogger.getLogger().log(Level.FINEST, "[DEBUG] Adding to List of beans with default JoinPoint, Bean name: " + string2 + ", propertyName: " + ((JoinColumnValues)object3).joinColumnColumnPropertyName);
                    }
                    BeanPropertyInformation beanPropertyInformation6 = new BeanPropertyInformation();
                    beanPropertyInformation6.setPropertyTypeInfo(typeInfo);
                    beanPropertyInformation6.setField(null);
                    if (!bl3 && iMethodBinding2 != null) {
                        beanPropertyInformation6.setReadMethod(this.getMethodNameFromSignature((String)object));
                    }
                    if (iMethodBinding != null) {
                        beanPropertyInformation6.setWriteMethod(this.getMethodNameFromSignature(string3));
                    }
                    beanPropertyInformation6.setCaseSensitivePropertyName(((BeanPropertyInformation)object4).getCaseSensitivePropertyName());
                    beanPropertyInformation6.setDerivedProperty(true);
                    beanPropertyInformation6.setInputValueRequired(this.getRequiredAnnotationOnMethod(iMethodBinding2));
                    this.checkAndSetFormatterClassFromAnnotationOnMethod(iMethodBinding2, beanPropertyInformation6);
                    if (((JoinColumnValues)object3).joinColumnColumnTableName != null) {
                        beanPropertyInformation6.setTableName(((JoinColumnValues)object3).joinColumnColumnTableName.toLowerCase());
                    }
                    if (n2 > 1 && ((JoinColumnValues)object3).joinColumnPropertyNameFromDefault) {
                        String string6 = typeInfo.getJavaType() == JavaType.BEAN ? typeInfo.getQualifiedName() : typeInfo.getBaseType().getQualifiedName();
                        throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_RESULTHANDLER_ACTUAL_PROP_NAME", string2, string6, ((JoinColumnValues)object3).joinColumnColumnPropertyName), null, 11201, null, methodInfo);
                    }
                    beanPropertyInformation6.setJoinPointPropertyName(((JoinColumnValues)object3).joinColumnColumnPropertyName, ((JoinColumnValues)object3).joinColumnPropertyNameFromDefault);
                    beanPropertyInformation6.setJoinPointColumnPrefix(((JoinColumnValues)object3).joinColumnColumnPrefix);
                    beanPropertyInformation6.setJoinPointProperty(true);
                    beanInformation.addBeanPropertyMap(((JoinColumnValues)object3).joinColumnColumnName.toLowerCase(), beanPropertyInformation6);
                    if (beanPropertyInformation4 == null) {
                        beanPropertyInformation4 = beanPropertyInformation6;
                        beanPropertyInformation5 = beanPropertyInformation6;
                        beanPropertyInformation6.setNextJoinPointPropInfo(beanPropertyInformation6);
                        continue;
                    }
                    beanPropertyInformation6.setNextJoinPointPropInfo(beanPropertyInformation5.getNextJoinPointPropInfo());
                    beanPropertyInformation5.setNextJoinPointPropInfo(beanPropertyInformation6);
                    beanPropertyInformation5 = beanPropertyInformation6;
                }
            } else {
                Object object5 = object4;
                object3 = map4.get(((BeanPropertyInformation)object4).getCaseSensitivePropertyName());
                if (object3 != null) {
                    object5 = object3;
                    bl4 = true;
                } else if (beanPropertyInformation3 != null) {
                    object5 = beanPropertyInformation3;
                    list = list3;
                    bl4 = true;
                } else if (beanPropertyInformation2 != null) {
                    object5 = beanPropertyInformation2;
                    list = list4;
                    bl4 = true;
                } else if (beanPropertyInformation != null) {
                    object5 = beanPropertyInformation;
                    list = list2;
                    bl4 = true;
                }
                string4 = ((BeanPropertyInformation)object5).getCaseSensitivePropertyName();
                string5 = string4.toLowerCase();
                if (bl4) {
                    BeanPropertyInformation beanPropertyInformation7 = new BeanPropertyInformation(this.getPropertyName((String)object, methodInfo));
                    beanPropertyInformation7.setTableName(((BeanPropertyInformation)object5).getTableName());
                    beanPropertyInformation7.setPropertyTypeInfo(typeInfo);
                    beanPropertyInformation7.setField(null);
                    if (!bl3 && iMethodBinding2 != null) {
                        beanPropertyInformation7.setReadMethod(this.getMethodNameFromSignature((String)object));
                    }
                    if (iMethodBinding != null) {
                        beanPropertyInformation7.setWriteMethod(this.getMethodNameFromSignature(string3));
                    }
                    beanPropertyInformation7.setDerivedProperty(true);
                    beanPropertyInformation7.setInputValueRequired(this.getRequiredAnnotationOnMethod(iMethodBinding2));
                    this.checkAndSetFormatterClassFromAnnotationOnMethod(iMethodBinding2, beanPropertyInformation7);
                    beanPropertyInformation7.setJoinPointPropertyName(string5, true);
                    beanInformation.addBeanPropertyMap(string5, beanPropertyInformation7);
                }
                String string7 = this.getGeneratedKeyInformation((IBinding)iMethodBinding2, string4);
                if (!bl3 && string7 == null && iMethodBinding != null) {
                    string7 = this.getGeneratedKeyInformation((IBinding)iMethodBinding, string4);
                }
                if (string7 != null) {
                    beanInformation.addAutoGeneratedKeys(string7);
                    string2 = null;
                    if (bl4) {
                        string2 = ((BeanPropertyInformation)object5).getTableName();
                    }
                    ToolsLogger.getLogger().log(Level.FINEST, "Has @GeneratedKey annotation. ColumnName: " + string7 + ", TableName: " + string2);
                }
                string2 = this.getIdInformation((IBinding)iMethodBinding2, string4);
                if (!bl3 && string2 == null && iMethodBinding != null) {
                    string2 = this.getIdInformation((IBinding)iMethodBinding, string4);
                }
                if (string2 != null) {
                    beanInformation.addIdKeys(string2);
                    String string8 = string;
                    if (bl4) {
                        string8 = ((BeanPropertyInformation)object5).getTableName();
                    }
                    beanInformation.addIdKeysTable(string8);
                    ToolsLogger.getLogger().log(Level.FINEST, "Has @Id annotation. ColumnName: " + string2 + ", TableName: " + string8);
                }
            }
            object3 = ((BeanPropertyInformation)object4).getCaseSensitivePropertyName().toLowerCase();
            if (bl4 && string5.equals(object3) && !bl8) continue;
            BeanPropertyInformation beanPropertyInformation8 = new BeanPropertyInformation();
            beanPropertyInformation8.setPropertyTypeInfo(typeInfo);
            beanPropertyInformation8.setInputValueRequired(this.getRequiredAnnotationOnMethod(iMethodBinding2));
            this.checkAndSetFormatterClassFromAnnotationOnMethod(iMethodBinding2, beanPropertyInformation8);
            beanPropertyInformation8.setField(null);
            if (!bl3 && iMethodBinding2 != null) {
                beanPropertyInformation8.setReadMethod(this.getMethodNameFromSignature((String)object));
            }
            if (iMethodBinding != null) {
                beanPropertyInformation8.setWriteMethod(this.getMethodNameFromSignature(string3));
            }
            beanPropertyInformation8.setCaseSensitivePropertyName(((BeanPropertyInformation)object4).getCaseSensitivePropertyName());
            beanPropertyInformation8.setTableName(string);
            beanPropertyInformation8.setJoinPointPropertyName(((BeanPropertyInformation)object4).getCaseSensitivePropertyName(), false);
            beanPropertyInformation8.setOverriddenProperty(bl4 | bl8);
            if (bl8) {
                beanPropertyInformation8.setNextJoinPointPropInfo(beanPropertyInformation4);
                beanPropertyInformation5.setNextJoinPointPropInfo(beanPropertyInformation8);
            }
            beanInformation.addBeanPropertyMap((String)object3, beanPropertyInformation8);
        }
        if (!this.ignoreOrphanGetterSetterMethods_ && (object2 = map2.keySet()).size() > 0) {
            object = object2.iterator();
            while (object.hasNext()) {
                list = (String)object.next();
                stringBuilder.append("\n" + Messages.getText("ERR_BEAN_SET_NO_GET", list));
            }
        }
        if (stringBuilder.length() > 0) {
            beanInformation.setErrorString(stringBuilder.toString());
        }
    }

    private String getGeneratedKeyInformation(IBinding iBinding, String string) {
        IAnnotationBinding[] iAnnotationBindingArray;
        for (IAnnotationBinding iAnnotationBinding : iAnnotationBindingArray = iBinding.getAnnotations()) {
            String string2 = iAnnotationBinding.getAnnotationType().getQualifiedName();
            if (!"com.ibm.db2.cmx.annotation.GeneratedKey".equals(string2)) continue;
            return string;
        }
        return null;
    }

    private String getIdInformation(IBinding iBinding, String string) {
        IAnnotationBinding[] iAnnotationBindingArray;
        for (IAnnotationBinding iAnnotationBinding : iAnnotationBindingArray = iBinding.getAnnotations()) {
            String string2 = iAnnotationBinding.getAnnotationType().getQualifiedName();
            if (!"com.ibm.db2.cmx.annotation.Id".equals(string2)) continue;
            return string;
        }
        return null;
    }

    private boolean getRequiredAnnotation(IBinding iBinding) {
        IAnnotationBinding[] iAnnotationBindingArray;
        for (IAnnotationBinding iAnnotationBinding : iAnnotationBindingArray = iBinding.getAnnotations()) {
            String string = iAnnotationBinding.getAnnotationType().getQualifiedName();
            if (!"com.ibm.db2.cmx.annotation.Required".equals(string)) continue;
            return true;
        }
        return false;
    }

    private boolean getRequiredAnnotationOnMethod(IMethodBinding iMethodBinding) {
        IAnnotationBinding[] iAnnotationBindingArray;
        for (IAnnotationBinding iAnnotationBinding : iAnnotationBindingArray = iMethodBinding.getAnnotations()) {
            String string = iAnnotationBinding.getAnnotationType().getQualifiedName();
            if (!"com.ibm.db2.cmx.annotation.Required".equals(string)) continue;
            return true;
        }
        return false;
    }

    private void checkAndSetFormatterClassFromAnnotationOnField(IBinding iBinding, BeanPropertyInformation beanPropertyInformation) {
        IAnnotationBinding[] iAnnotationBindingArray;
        boolean bl2 = false;
        boolean bl3 = false;
        for (IAnnotationBinding iAnnotationBinding : iAnnotationBindingArray = iBinding.getAnnotations()) {
            IMemberValuePairBinding[] iMemberValuePairBindingArray;
            String string = iAnnotationBinding.getAnnotationType().getQualifiedName();
            if (!"com.ibm.db2.cmx.annotation.Format".equals(string)) continue;
            for (IMemberValuePairBinding iMemberValuePairBinding : iMemberValuePairBindingArray = iAnnotationBinding.getDeclaredMemberValuePairs()) {
                String string2 = iMemberValuePairBinding.getName();
                if (string2.equals("formatterClass")) {
                    beanPropertyInformation.setFormatterClassQualifiedName(((ITypeBinding)iMemberValuePairBinding.getValue()).getQualifiedName());
                    beanPropertyInformation.setFormatterClassName(((ITypeBinding)iMemberValuePairBinding.getValue()).getName());
                    bl2 = true;
                }
                if (!string2.equals("formattingOptions")) continue;
                beanPropertyInformation.setFormattingOptions(((ITypeBinding)iMemberValuePairBinding.getValue()).getQualifiedName());
                bl3 = true;
            }
            if (bl2) continue;
        }
        if (!bl2) {
            beanPropertyInformation.setFormatterClassQualifiedName(null);
            beanPropertyInformation.setFormatterClassName(null);
        }
        if (!bl3) {
            beanPropertyInformation.setFormattingOptions(null);
        }
    }

    private void checkAndSetFormatterClassFromAnnotationOnMethod(IMethodBinding iMethodBinding, BeanPropertyInformation beanPropertyInformation) {
        IAnnotationBinding[] iAnnotationBindingArray;
        boolean bl2 = false;
        boolean bl3 = false;
        for (IAnnotationBinding iAnnotationBinding : iAnnotationBindingArray = iMethodBinding.getAnnotations()) {
            IMemberValuePairBinding[] iMemberValuePairBindingArray;
            String string = iAnnotationBinding.getAnnotationType().getQualifiedName();
            if (!"com.ibm.db2.cmx.annotation.Format".equals(string)) continue;
            for (IMemberValuePairBinding iMemberValuePairBinding : iMemberValuePairBindingArray = iAnnotationBinding.getDeclaredMemberValuePairs()) {
                String string2 = iMemberValuePairBinding.getName();
                if (string2.equals("formatterClass")) {
                    beanPropertyInformation.setFormatterClassQualifiedName(((ITypeBinding)iMemberValuePairBinding.getValue()).getQualifiedName());
                    beanPropertyInformation.setFormatterClassName(((ITypeBinding)iMemberValuePairBinding.getValue()).getName());
                    bl2 = true;
                }
                if (!string2.equals("formattingOptions")) continue;
                beanPropertyInformation.setFormattingOptions((String)iMemberValuePairBinding.getValue());
                bl3 = true;
            }
            if (bl2) continue;
        }
        if (!bl2) {
            beanPropertyInformation.setFormatterClassQualifiedName(null);
            beanPropertyInformation.setFormatterClassName(null);
        }
        if (!bl3) {
            beanPropertyInformation.setFormattingOptions(null);
        }
    }

    private IMethodBinding findMatchingAccessorMethodAndSetBeanInfo(BeanInformation beanInformation, boolean bl2, IMethodBinding[] iMethodBindingArray, int n2, String string, String string2, String string3, ITypeBinding iTypeBinding, TypeInfo typeInfo) {
        String string4 = beanInformation.getTableNameAnnotation();
        for (int i10 = n2 + 1; i10 < iMethodBindingArray.length; ++i10) {
            ITypeBinding iTypeBinding2;
            String string5;
            IMethod iMethod;
            IMethodBinding iMethodBinding = iMethodBindingArray[i10];
            if (!this.checkModifiersForVisibility(iMethodBinding.getModifiers()) || (iMethod = (IMethod)iMethodBinding.getJavaElement()) == null || !(string5 = iMethod.getElementName()).equals(string3) || (iTypeBinding2 = this.getParameterOrReturnTypeBinding(iMethodBinding, string5)) == null || !iTypeBinding.getQualifiedName().equals(iTypeBinding2.getQualifiedName())) continue;
            BeanPropertyInformation beanPropertyInformation = new BeanPropertyInformation();
            beanPropertyInformation.setPropertyTypeInfo(typeInfo);
            if (bl2) {
                beanPropertyInformation.setReadMethod(string);
                beanPropertyInformation.setWriteMethod(string3);
            } else {
                beanPropertyInformation.setReadMethod(string3);
                beanPropertyInformation.setWriteMethod(string);
            }
            beanPropertyInformation.setCaseSensitivePropertyName(string2);
            beanPropertyInformation.setTableName(string4);
            beanInformation.addBeanPropertyMap(string2.toLowerCase(), beanPropertyInformation);
            return iMethodBinding;
        }
        return null;
    }

    private TypeInfo getTypeInfo(String string, ITypeBinding iTypeBinding, SimpleType simpleType) {
        String string2;
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.setTypeName(iTypeBinding.getName());
        typeInfo.setName(string);
        String string3 = iTypeBinding.getPackage() == null ? null : iTypeBinding.getPackage().getName();
        typeInfo.setPackageName(string3);
        typeInfo.setSimpleType(true);
        typeInfo.setQualifiedName(iTypeBinding.getQualifiedName());
        typeInfo.setPrimitive(iTypeBinding.isPrimitive());
        ITypeBinding[] iTypeBindingArray = iTypeBinding.getTypeArguments();
        if (iTypeBindingArray != null && iTypeBindingArray.length > 0) {
            typeInfo.setBaseType(this.getTypeInfo(null, iTypeBindingArray[0], simpleType));
        }
        typeInfo.setJavaType(TypeHelper.getJavaType(iTypeBinding.getTypeDeclaration().getQualifiedName(), simpleType.getAST(), iTypeBinding, this.bindingsMap_));
        if (string3 != null && typeInfo.getJavaType() == JavaType.BEAN && !string3.startsWith("java.")) {
            typeInfo.setBeanType(true);
        } else {
            typeInfo.setBeanType(false);
        }
        if ("java.lang".equals(string3) && ("Integer".equals(string2 = typeInfo.getTypeName()) || "Short".equals(string2) || "Float".equals(string2) || "Double".equals(string2) || "Character".equals(string2) || "Boolean".equals(string2) || "Long".equals(string2) || "Byte".equals(string2))) {
            typeInfo.setPrimitiveOrWrapper(true);
        }
        return typeInfo;
    }

    private TypeInfo getFieldInfo(String string, IVariableBinding iVariableBinding, SimpleType simpleType) {
        TypeInfo typeInfo = this.getTypeInfo(string, iVariableBinding.getType(), simpleType);
        return typeInfo;
    }

    private boolean checkModifiersForVisibility(int n2) {
        return !Modifier.isPrivate((int)n2) && !Modifier.isProtected((int)n2) && !Modifier.isFinal((int)n2);
    }

    private BeanPropertyInformation getColumnAnnotation(IBinding iBinding, String string) {
        IAnnotationBinding[] iAnnotationBindingArray;
        for (IAnnotationBinding iAnnotationBinding : iAnnotationBindingArray = iBinding.getAnnotations()) {
            IMemberValuePairBinding[] iMemberValuePairBindingArray;
            String string2 = iAnnotationBinding.getAnnotationType().getQualifiedName();
            if (!"com.ibm.db2.cmx.annotation.Column".equals(string2)) continue;
            BeanPropertyInformation beanPropertyInformation = new BeanPropertyInformation();
            for (IMemberValuePairBinding iMemberValuePairBinding : iMemberValuePairBindingArray = iAnnotationBinding.getAllMemberValuePairs()) {
                String string3;
                String string4 = iMemberValuePairBinding.getName();
                if ("name".equals(string4)) {
                    string3 = (String)iMemberValuePairBinding.getValue();
                    if (iMemberValuePairBinding.isDefault() && "".equals(string3)) continue;
                    beanPropertyInformation.setCaseSensitivePropertyName(string3);
                    continue;
                }
                if (!"table".equals(string4)) continue;
                string3 = (String)iMemberValuePairBinding.getValue();
                if (!(iMemberValuePairBinding.isDefault() && "*".equals(string3) || "".equals(string3))) {
                    beanPropertyInformation.setTableName(string3.toLowerCase());
                    continue;
                }
                if (string == null || "".equals(string3)) continue;
                beanPropertyInformation.setTableName(string.toLowerCase());
            }
            if (beanPropertyInformation.getCaseSensitivePropertyName() == null) continue;
            return beanPropertyInformation;
        }
        return null;
    }

    private void getColumnAnnotationOnMethod(IMethodBinding iMethodBinding, String string, Map<String, String> map) {
        IAnnotationBinding[] iAnnotationBindingArray;
        for (IAnnotationBinding iAnnotationBinding : iAnnotationBindingArray = iMethodBinding.getAnnotations()) {
            IMemberValuePairBinding[] iMemberValuePairBindingArray;
            String string2 = iAnnotationBinding.getAnnotationType().getQualifiedName();
            if (!"com.ibm.db2.cmx.annotation.Column".equals(string2)) continue;
            for (IMemberValuePairBinding iMemberValuePairBinding : iMemberValuePairBindingArray = iAnnotationBinding.getAllMemberValuePairs()) {
                String string3 = iMemberValuePairBinding.getName();
                if (!"name".equals(string3)) continue;
                String string4 = (String)iMemberValuePairBinding.getValue();
                if (iMemberValuePairBinding.isDefault() && "".equals(string4)) continue;
                map.put(string, string4.toLowerCase());
            }
        }
    }

    void setBaseType(TypeInfo typeInfo, MethodInfo methodInfo) {
        if ((typeInfo.isParameterizedType() || typeInfo.isArrayType()) && typeInfo.getJavaType() != JavaType.MAP) {
            List<TypeInfo> list = typeInfo.getParameterizedType();
            if (list != null && list.size() == 1) {
                typeInfo.setBaseType(list.get(0));
            } else {
                typeInfo.setBaseType(typeInfo);
            }
        } else {
            typeInfo.setBaseType(typeInfo);
        }
    }

    void processType(Type type, TypeInfo typeInfo, MethodInfo methodInfo, int n2, boolean bl2) {
        if (type.isPrimitiveType()) {
            this.setTypeInfoForPrimitive(type, typeInfo);
        } else if (type.isSimpleType()) {
            this.processSimpleType((SimpleType)type, typeInfo, methodInfo, n2, bl2);
        } else if (type.isParameterizedType()) {
            Type type2 = ((ParameterizedType)type).getType();
            typeInfo.setParameterizedType(true);
            if (!type2.isSimpleType()) {
                throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_TYPE_NOTSUP", type2.getClass()), null, 10260, (ASTNode)type2, methodInfo);
            }
            this.processSimpleType((SimpleType)type2, typeInfo, methodInfo, n2, bl2);
            List list = ((ParameterizedType)type).typeArguments();
            ArrayList<TypeInfo> arrayList = new ArrayList<TypeInfo>();
            for (Type type3 : list) {
                TypeInfo typeInfo2 = new TypeInfo();
                arrayList.add(typeInfo2);
                this.processType(type3, typeInfo2, methodInfo, n2, bl2);
            }
            typeInfo.setParameterizedType(arrayList);
        } else if (type.isArrayType()) {
            ArrayType arrayType = (ArrayType)type;
            typeInfo.setArrayType(true);
            typeInfo.setJavaType(JavaType.ARRAY);
            ITypeBinding iTypeBinding = arrayType.resolveBinding();
            typeInfo.setTypeName(iTypeBinding.getName());
            typeInfo.setQualifiedName(iTypeBinding.getQualifiedName());
            ArrayList<TypeInfo> arrayList = new ArrayList<TypeInfo>();
            TypeInfo typeInfo3 = new TypeInfo();
            arrayList.add(typeInfo3);
            this.processType(arrayType.getComponentType(), typeInfo3, methodInfo, n2, bl2);
            typeInfo.setParameterizedType(arrayList);
        }
    }

    private void getInherited(SimpleType simpleType, ITypeBinding iTypeBinding, LinkedList<String> linkedList, LinkedList<String> linkedList2, Map<String, IVariableBinding> map, Map<String, IMethodBinding> map2, Map<String, IMethodBinding> map3, Map<String, BeanPropertyInformation> map4, MethodInfo methodInfo) {
        String string;
        String string2;
        String string3;
        String string4;
        this.addTableAnnotaionToList(iTypeBinding, linkedList2, simpleType, methodInfo);
        this.addColumnOverrideToMap(iTypeBinding, map4, simpleType, methodInfo);
        linkedList.add(iTypeBinding.getQualifiedName());
        IVariableBinding[] iVariableBindingArray = iTypeBinding.getDeclaredFields();
        for (int i10 = 0; i10 < iVariableBindingArray.length; ++i10) {
            IVariableBinding iVariableBinding = iVariableBindingArray[i10];
            string4 = iVariableBinding.getName();
            if (map.containsKey(string4) || !Modifier.isPublic((int)iVariableBinding.getModifiers()) || Modifier.isStatic((int)iVariableBinding.getModifiers())) continue;
            map.put(string4, iVariableBinding);
            string3 = iVariableBinding.getType();
            string2 = string3 != null ? string3.getName() : null;
            string = string3 != null ? string3.getQualifiedName() : null;
            ITypeBinding iTypeBinding2 = string3 != null ? string3.getErasure() : null;
            String string5 = iTypeBinding2 != null ? iTypeBinding2.getQualifiedName() : null;
            ITypeBinding[] iTypeBindingArray = string3.getTypeArguments();
            IVariableBinding iVariableBinding2 = iVariableBinding.getVariableDeclaration();
            String string6 = null;
            if (iTypeBindingArray != null && iTypeBindingArray.length > 0) {
                string6 = iTypeBindingArray[0].getQualifiedName();
            }
            boolean bl2 = iVariableBinding == iVariableBinding2;
            IMethodBinding iMethodBinding = iVariableBinding.getDeclaringMethod();
            String string7 = iMethodBinding != null ? iMethodBinding.getName() : null;
            ToolsLogger.getLogger().log(Level.FINEST, "Field name: " + string4 + ", DeclaringClass name: " + iVariableBinding.getDeclaringClass().getName() + ", DeclaringMethod name: " + string7 + ", Variable Declaration same: " + bl2 + ", Variable Declaration: " + iVariableBinding2 + ", field Type name: " + string2 + ", field Type Qual name: " + string + ", field Type Erasure Qual Name: " + string5 + ", field Type Arg[0]: " + string6);
        }
        IMethodBinding[] iMethodBindingArray = iTypeBinding.getDeclaredMethods();
        for (int i11 = 0; i11 < iMethodBindingArray.length; ++i11) {
            string4 = iMethodBindingArray[i11];
            string3 = string4.getName();
            if (string4.isSynthetic() || string4.isConstructor() || !Modifier.isPublic((int)string4.getModifiers()) || Modifier.isStatic((int)string4.getModifiers())) continue;
            string2 = NodeProcessor.getSignature((IBinding)string4);
            if (string3.startsWith("get") && !map2.containsKey(string2) && this.applyParameterRule((IMethodBinding)string4, 0)) {
                map2.put(string2, (IMethodBinding)string4);
                continue;
            }
            if (string3.startsWith("is") && !map2.containsKey(string2) && this.applyParameterRule((IMethodBinding)string4, 0)) {
                string = string4.getReturnType();
                if (!simpleType.getAST().resolveWellKnownType("boolean").equals(string) && !simpleType.getAST().resolveWellKnownType("java.lang.Boolean").equals(string)) continue;
                map2.put(string2, (IMethodBinding)string4);
                continue;
            }
            if (!string3.startsWith("set") || map2.containsKey(string2) || !this.applyParameterRule((IMethodBinding)string4, 1)) continue;
            map3.put(string2, (IMethodBinding)string4);
        }
        ITypeBinding iTypeBinding3 = iTypeBinding.getSuperclass();
        if (!(iTypeBinding3 == null || simpleType.getAST().resolveWellKnownType("java.lang.Object").equals(iTypeBinding3) || (string4 = iTypeBinding3.getPackage().getName()) == null || string4.startsWith("java.") || string4.startsWith("javax."))) {
            this.getInherited(simpleType, iTypeBinding3, linkedList, linkedList2, map, map2, map3, map4, methodInfo);
        }
    }

    private void addTableAnnotaionToList(ITypeBinding iTypeBinding, LinkedList<String> linkedList, SimpleType simpleType, MethodInfo methodInfo) {
        IAnnotationBinding[] iAnnotationBindingArray;
        for (IAnnotationBinding iAnnotationBinding : iAnnotationBindingArray = iTypeBinding.getAnnotations()) {
            ITypeBinding iTypeBinding2 = iAnnotationBinding.getAnnotationType();
            String string = iTypeBinding2.getQualifiedName();
            if (!"com.ibm.db2.cmx.annotation.Table".equals(string)) continue;
            this.getTableAnnotation(linkedList, iAnnotationBinding);
        }
        iTypeBinding = iTypeBinding.getSuperclass();
    }

    private void getTableAnnotation(LinkedList<String> linkedList, IAnnotationBinding iAnnotationBinding) {
        IMemberValuePairBinding[] iMemberValuePairBindingArray;
        String string = null;
        for (IMemberValuePairBinding iMemberValuePairBinding : iMemberValuePairBindingArray = iAnnotationBinding.getAllMemberValuePairs()) {
            String string2 = iMemberValuePairBinding.getName();
            if (!"name".equals(string2)) continue;
            string = (String)iMemberValuePairBinding.getValue();
        }
        if (string != null && string.length() > 0) {
            linkedList.addFirst(string.toLowerCase());
        }
    }

    private boolean applyParameterRule(IMethodBinding iMethodBinding, int n2) {
        return iMethodBinding.getParameterTypes().length == n2;
    }

    private static String getSignature(IBinding iBinding) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = iBinding.getName();
        stringBuilder.append(string);
        if ("set".equals(string) || "get".equals(string)) {
            return stringBuilder.toString();
        }
        if (string.startsWith("set")) {
            stringBuilder.append("(");
            ITypeBinding[] iTypeBindingArray = ((IMethodBinding)iBinding).getParameterTypes();
            for (int i10 = 0; i10 < iTypeBindingArray.length; ++i10) {
                if (i10 > 0) {
                    stringBuilder.append(',');
                }
                ITypeBinding iTypeBinding = iTypeBindingArray[i10].getErasure();
                stringBuilder.append(iTypeBinding.getQualifiedName());
            }
            stringBuilder.append(')');
        } else if (string.startsWith("get") || string.startsWith("is")) {
            stringBuilder.append("(");
            ITypeBinding iTypeBinding = ((IMethodBinding)iBinding).getReturnType();
            ITypeBinding iTypeBinding2 = iTypeBinding.getErasure();
            stringBuilder.append(iTypeBinding2.getQualifiedName());
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    void setTypeInfoForPrimitive(Type type, TypeInfo typeInfo) {
        typeInfo.setPrimitiveOrWrapper(true);
        typeInfo.setPrimitive(true);
        ITypeBinding iTypeBinding = type.resolveBinding();
        typeInfo.setTypeName(iTypeBinding.getName());
        String string = iTypeBinding.getQualifiedName();
        typeInfo.setQualifiedName(string);
        typeInfo.setJavaType(TypeHelper.getJavaType(string, null, null, this.bindingsMap_));
    }

    void addImportStatement(String string, String string2) {
        if (!"".equals(string) && string2 != null && !string2.startsWith("java.lang")) {
            this.classInfo_.addImportDeclaration(string2);
        }
    }

    private void processCursorAnnotation(IMemberValuePairBinding[] iMemberValuePairBindingArray, MethodInfo methodInfo) {
        for (IMemberValuePairBinding iMemberValuePairBinding : iMemberValuePairBindingArray) {
            int n2;
            String string = iMemberValuePairBinding.getName();
            if ("holdability".equals(string)) {
                n2 = (Integer)iMemberValuePairBinding.getValue();
                methodInfo.setCursorHoldability(n2);
                continue;
            }
            if ("concurrency".equals(string)) {
                n2 = (Integer)iMemberValuePairBinding.getValue();
                methodInfo.setCursorConcurrency(n2);
                continue;
            }
            if ("type".equals(string)) {
                n2 = (Integer)iMemberValuePairBinding.getValue();
                methodInfo.setCursorType(n2);
                continue;
            }
            if ("cursorName".equals(string)) {
                String string2 = (String)iMemberValuePairBinding.getValue();
                if (string2 == null || string2.length() <= 0) continue;
                methodInfo.setCursorName(string2);
                continue;
            }
            if (!"allowStaticRowsetCursors".equals(string)) continue;
            boolean bl2 = (Boolean)iMemberValuePairBinding.getValue();
            methodInfo.setAllowStaticRowsetCursors(bl2);
        }
    }

    private List<JoinColumnValues> getJoinColumnAnnotations(IBinding iBinding) {
        ArrayList<JoinColumnValues> arrayList = new ArrayList<JoinColumnValues>();
        String string = "";
        IAnnotationBinding[] iAnnotationBindingArray = iBinding.getAnnotations();
        for (IAnnotationBinding iAnnotationBinding : iAnnotationBindingArray) {
            JoinColumnValues joinColumnValues = null;
            String string2 = iAnnotationBinding.getAnnotationType().getQualifiedName();
            if (!"com.ibm.db2.cmx.annotation.JoinPoint".equals(string2)) continue;
            IMemberValuePairBinding[] iMemberValuePairBindingArray = iAnnotationBinding.getDeclaredMemberValuePairs();
            if (iMemberValuePairBindingArray.length == 0) {
                arrayList.add(new JoinColumnValues("*", "*", null, "", false));
                continue;
            }
            for (IMemberValuePairBinding iMemberValuePairBinding : iMemberValuePairBindingArray) {
                Object[] objectArray;
                Object object = iMemberValuePairBinding.getValue();
                if (object instanceof IAnnotationBinding) {
                    joinColumnValues = this.getJoinColumnAnnotation((IAnnotationBinding)object, string);
                    if (joinColumnValues == null) continue;
                    arrayList.add(joinColumnValues);
                    continue;
                }
                String string3 = iMemberValuePairBinding.getName();
                if ("columnPrefix".equals(string3)) {
                    string = (String)object;
                    if (iMemberValuePairBindingArray.length != 1) continue;
                    arrayList.add(new JoinColumnValues("*", "*", null, string, true));
                    continue;
                }
                for (Object object2 : objectArray = (Object[])object) {
                    joinColumnValues = this.getJoinColumnAnnotation((IAnnotationBinding)object2, string);
                    if (joinColumnValues == null) continue;
                    arrayList.add(joinColumnValues);
                }
            }
        }
        if (!string.equals("")) {
            for (JoinColumnValues joinColumnValues : arrayList) {
                joinColumnValues.joinColumnColumnPrefix = string;
            }
        }
        return arrayList;
    }

    private JoinColumnValues getJoinColumnAnnotation(IAnnotationBinding iAnnotationBinding, String string) {
        IMemberValuePairBinding[] iMemberValuePairBindingArray;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        boolean bl2 = true;
        for (IMemberValuePairBinding iMemberValuePairBinding : iMemberValuePairBindingArray = iAnnotationBinding.getAllMemberValuePairs()) {
            String string5 = iMemberValuePairBinding.getName();
            if ("name".equals(string5)) {
                string3 = string2 = (String)iMemberValuePairBinding.getValue();
                continue;
            }
            if ("propertyName".equals(string5)) {
                string3 = (String)iMemberValuePairBinding.getValue();
                if (iMemberValuePairBinding.isDefault() || "*".equals(string3)) {
                    string3 = string2;
                    continue;
                }
                bl2 = false;
                continue;
            }
            if (!"table".equals(string5)) continue;
            string4 = (String)iMemberValuePairBinding.getValue();
            if (!iMemberValuePairBinding.isDefault() && !"*".equals(string3)) continue;
            string4 = null;
        }
        if (string2 != null) {
            return new JoinColumnValues(string2, string3, string4, string, bl2);
        }
        return null;
    }

    private String generateUniqueId() {
        return "*" + this.uniqueId_++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processNestedBeanForJoinPointInfo(MethodInfo methodInfo) {
        try {
            Set<Map.Entry<String, String>> set = this.listOfPropertiesToBeUpdatedFromNestedBeanIds_.entrySet();
            for (Map.Entry<String, String> entry : set) {
                String string = entry.getValue();
                String string2 = entry.getKey();
                BeanInformation beanInformation = methodInfo.getNestedBeansInfoMap().get(string);
                if (beanInformation == null && (beanInformation = methodInfo.getOutputBeanInfoMap().get(string)) == null) {
                    throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_RESULTHANDLER_LOGIC_ERR", new Object[0]), null, 11190, null, methodInfo);
                }
                BeanPropertyInformation beanPropertyInformation = beanInformation.getBasePropertyUsingCaseInSensitiveName(string2);
                if (beanPropertyInformation == null) {
                    throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_RESULTHANDLER_LOGIC_ERR", new Object[0]), null, 11191, null, methodInfo);
                }
                BeanPropertyInformation beanPropertyInformation2 = beanPropertyInformation.getNextJoinPointPropInfo();
                String string3 = beanPropertyInformation2.getJoinPointPropertyName();
                beanInformation.getBeanPropertyMap().remove(string2);
                TypeInfo typeInfo = beanPropertyInformation.getPropertyTypeInfo();
                if (typeInfo.getJavaType() == JavaType.LIST) {
                    typeInfo = typeInfo.getBaseType();
                }
                String string4 = typeInfo.getQualifiedName();
                BeanInformation beanInformation2 = methodInfo.getNestedBeansInfoMap().get(string4);
                if (beanInformation2 == null) {
                    beanInformation2 = methodInfo.getOutputBeanInfoMap().get(string4);
                }
                List<String> list = beanInformation2.getIdKeys();
                List<String> list2 = beanInformation2.getIdKeysTable();
                int n2 = list.size();
                if (n2 == 0) {
                    WarningFactory.createPureQueryWarningForGeneratorOnly(Messages.getText("WARN_JOINCOL_DEFAULT_ERR", beanInformation.getFullyQualifiedName(), string3, beanInformation2.getFullyQualifiedName(), Messages.getText("WARN_BEAN_PROP_IGN", new Object[0])), 11192, this.classInfo_.getGeneratorImpl(), null, methodInfo, this.getClass(), "generateResultHandler (MethodInfo, TypeInfo)");
                    beanInformation.getBeanPropertyMap().remove(string3);
                    continue;
                }
                BeanPropertyInformation beanPropertyInformation3 = null;
                BeanPropertyInformation beanPropertyInformation4 = null;
                for (int i10 = 0; i10 < n2; ++i10) {
                    String string5 = list.get(i10);
                    String string6 = string5 != null ? string5.toLowerCase() : null;
                    String string7 = list2.get(i10);
                    if (string7 != null) {
                        string7 = string7.toLowerCase();
                    }
                    BeanPropertyInformation beanPropertyInformation5 = new BeanPropertyInformation(string5);
                    beanPropertyInformation5.setDerivedProperty(true);
                    beanPropertyInformation5.setField(beanPropertyInformation2.getField());
                    beanPropertyInformation5.setJoinPointProperty(true);
                    beanPropertyInformation5.setJoinPointPropertyName(string6, true);
                    beanPropertyInformation5.setMapKey(string6);
                    beanPropertyInformation5.setNextBeanPropInfo(null);
                    beanPropertyInformation5.setNextJoinPointPropInfo(beanPropertyInformation2);
                    beanPropertyInformation5.setOverriddenProperty(false);
                    beanPropertyInformation5.setPropertyTypeInfo(beanPropertyInformation2.getPropertyTypeInfo());
                    beanPropertyInformation5.setReadMethod(beanPropertyInformation2.getReadMethod());
                    beanPropertyInformation5.setTableName(string7);
                    beanPropertyInformation5.setWriteMethod(beanPropertyInformation2.getWriteMethod());
                    beanInformation.addBeanPropertyMap(string6, beanPropertyInformation5);
                    if (beanPropertyInformation3 == null) {
                        beanPropertyInformation3 = beanPropertyInformation5;
                        beanPropertyInformation4 = beanPropertyInformation5;
                        beanPropertyInformation5.setNextJoinPointPropInfo(beanPropertyInformation5);
                        continue;
                    }
                    beanPropertyInformation5.setNextJoinPointPropInfo(beanPropertyInformation4.getNextJoinPointPropInfo());
                    beanPropertyInformation4.setNextJoinPointPropInfo(beanPropertyInformation5);
                    beanPropertyInformation4 = beanPropertyInformation5;
                }
                beanPropertyInformation2.setNextJoinPointPropInfo(beanPropertyInformation3);
                beanPropertyInformation4.setNextJoinPointPropInfo(beanPropertyInformation2);
            }
        }
        finally {
            this.listOfPropertiesToBeUpdatedFromNestedBeanIds_.clear();
        }
    }

    private String printArray(boolean bl2, Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (objectArray == null || objectArray.length == 0) {
            stringBuilder.append("null");
        } else if (bl2) {
            for (int i10 = 0; i10 < objectArray.length; ++i10) {
                stringBuilder.append(objectArray[i10]);
            }
        } else {
            stringBuilder.append('{');
            boolean bl3 = false;
            for (int i11 = 0; i11 < objectArray.length; ++i11) {
                if (bl3) {
                    stringBuilder.append(", ");
                } else {
                    bl3 = true;
                }
                stringBuilder.append(objectArray[i11]);
            }
            stringBuilder.append('}');
        }
        return stringBuilder.toString();
    }

    protected void processPattern(MethodInfo methodInfo) {
        String string = methodInfo.getPatternString();
        if (string != null) {
            PatternProcessor patternProcessor = new PatternProcessor();
            PatternContainer patternContainer = patternProcessor.processPattern(string, methodInfo);
            methodInfo.setPatternContainer(patternContainer);
        }
    }
}

