/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.internal.controller;

import com.ibm.db2.cmx.ClientInfo;
import com.ibm.db2.cmx.MonitorInterface;
import com.ibm.db2.cmx.PushDownError;
import com.ibm.db2.cmx.TransportPoolStatistics;
import com.ibm.db2.cmx.internal.controller.ControlDataSourceImpl;
import com.ibm.db2.cmx.internal.controller.ControlDriver;
import com.ibm.db2.cmx.internal.controller.ControllerAgent;
import com.ibm.db2.cmx.internal.controller.ControllerMessageHelper;
import com.ibm.db2.cmx.internal.core.JSONHelper;
import com.ibm.db2.cmx.internal.json4j.JSONArray;
import com.ibm.db2.cmx.internal.json4j.JSONObject;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import com.ibm.db2.jcc.am.CallableStatement;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NPXControllerAgentImpl
implements ControllerAgent {
    Map<Integer, Connection> monconnectionMap = null;
    private static Logger logger__ = Log.getCMXClientLogger();
    private static NPXControllerAgentImpl instance_;

    public void writePayloadToNewton(int n2, JSONArray jSONArray, JSONArray jSONArray2) throws SQLException, IOException {
        Connection connection = this.monconnectionMap.get(n2);
        int n3 = ((Number)jSONArray.get(2)).intValue();
        String string = "writePayloadToNewton";
        if (connection == null) {
            if (logger__.isLoggable(Level.FINE)) {
                DataLogger.logConnectedComponents(logger__, this, string, "No connection found to for sending monitored data to Newton for dsid=" + n2 + " payloadType=" + n3 + " : " + jSONArray2);
            }
            return;
        }
        if (logger__.isLoggable(Level.FINE)) {
            DataLogger.logConnectedComponents(logger__, this, string, "Sending monitored data to Newton for dsid=" + n2 + " payloadType=" + n3 + " : " + jSONArray2);
        }
        CallableStatement callableStatement = (CallableStatement)connection.prepareCall("call NEWTON.CIDB(?,?,?)");
        String string2 = jSONArray2.serialize();
        StringReader stringReader = new StringReader(string2);
        callableStatement.setString(1, jSONArray.serialize());
        callableStatement.setClob(2, (Reader)stringReader, (long)string2.length());
        callableStatement.registerOutParameter(3, 12);
        callableStatement.execute();
        String string3 = callableStatement.getString(3);
        System.err.print("CALL NEWTON.CIDB returns: " + string3);
        if (logger__.isLoggable(Level.FINE)) {
            DataLogger.logConnectedComponents(logger__, this, string, "Result from " + string + " : " + string3);
        }
    }

    public String runNewtonRegistryCommand(int n2, JSONArray jSONArray, String string) throws SQLException, IOException {
        String string2 = null;
        String string3 = null;
        String string4 = "runNewtonRegistryCommand";
        Connection connection = this.monconnectionMap.get(n2);
        if (connection == null) {
            if (logger__.isLoggable(Level.FINE)) {
                DataLogger.logConnectedComponents(logger__, this, string4, "No connection found to for calling " + string4 + " for dsid=" + n2 + " data= " + string);
            }
            return null;
        }
        if (logger__.isLoggable(Level.FINE)) {
            DataLogger.logConnectedComponents(logger__, this, string4, "Calling stored procedure NEWTON.DB2C_REGISTRY for dsid: " + n2 + " data: " + string + "registryParameter=" + jSONArray.serialize());
        }
        CallableStatement callableStatement = (CallableStatement)connection.prepareCall("CALL NEWTON.DB2C_REGISTRY(?,?,?,?)");
        StringReader stringReader = new StringReader(string);
        callableStatement.setString(1, jSONArray.serialize());
        callableStatement.setCharacterStream(2, (Reader)stringReader, string.length());
        callableStatement.registerOutParameter(3, 12);
        callableStatement.registerOutParameter(4, 12);
        callableStatement.execute();
        string2 = callableStatement.getString(3);
        string3 = callableStatement.getString(4);
        if (logger__.isLoggable(Level.FINE)) {
            DataLogger.logConnectedComponents(logger__, this, string4, "registryCommandStatus=" + string3);
            DataLogger.logConnectedComponents(logger__, this, string4, "registryCommandReply=" + string2);
        }
        return string2;
    }

    @Override
    public void lookupOverNetwork(ControlDataSourceImpl controlDataSourceImpl) throws Exception {
    }

    @Override
    public void registerDriverOverNetwork(Map<String, Object> map, String string, String string2, long l2) throws Exception {
    }

    @Override
    public void getControllerInfo(StringBuilder stringBuilder) {
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public void registerMonitorDataSource(String string, String string2, String[] stringArray, int n2, String string3, String[] stringArray2, int n3, int n4, int n5, int n6, boolean bl2, int[] nArray, String[] stringArray3, String string4, int n7, int n8) throws Exception {
    }

    @Override
    public void deregisterMonitorDataSource(String string, String string2, int n2, String string3, String string4, int n3) throws Exception {
    }

    @Override
    public void sendDeregisterDriver(String string) throws Exception {
    }

    @Override
    public void sendDeregisterDataSource(String string) throws Exception {
    }

    @Override
    public void sendAndReceiveChainedMessages(ArrayList<ControlDriver.RequestInfo> arrayList) throws Exception {
        Object object;
        HashMap hashMap = new HashMap();
        ControllerMessageHelper controllerMessageHelper = null;
        controllerMessageHelper = ControllerMessageHelper.getInstance();
        if (logger__.isLoggable(Level.FINE)) {
            DataLogger.logConnectedComponents(logger__, this, "sendAndReceiveChainedMessages", "Sending chained registration requests to Newton Leibniz Server");
        }
        HashMap hashMap2 = new HashMap();
        for (ControlDriver.RequestInfo object2 : arrayList) {
            if (object2.getCDS() == null) continue;
            hashMap2.put(object2.getCDS().datasourceId_, new ArrayList());
        }
        for (ControlDriver.RequestInfo requestInfo : arrayList) {
            if (requestInfo.getCDS() != null) {
                object = requestInfo.getCDS().datasourceId_;
                ((ArrayList)hashMap2.get(object)).add(requestInfo);
                continue;
            }
            object = hashMap2.keySet().iterator();
            while (object.hasNext()) {
                ((ArrayList)hashMap2.get(object.next())).add(requestInfo);
            }
        }
        for (String string : hashMap2.keySet()) {
            Object object2;
            Object object3;
            object = (ArrayList)hashMap2.get(string);
            JSONArray jSONArray = this.buildRegistryParameters();
            JSONArray jSONArray2 = new JSONArray();
            Object object4 = ((ArrayList)object).iterator();
            while (object4.hasNext()) {
                object3 = (ControlDriver.RequestInfo)object4.next();
                object2 = JSONHelper.decodeJSONMessage(((ControlDriver.RequestInfo)object3).getMessage().getPayload()).toString();
                if (((String)object2).equals("")) continue;
                jSONArray2.add(object2);
            }
            object4 = this.runNewtonRegistryCommand(Integer.parseInt(string), jSONArray, jSONArray2.toString());
            if (object4 == null) continue;
            object3 = JSONObject.parse((String)object4);
            object2 = ((ArrayList)object).iterator();
            while (object2.hasNext()) {
                ControlDataSourceImpl controlDataSourceImpl;
                ControlDriver.RequestInfo requestInfo = (ControlDriver.RequestInfo)object2.next();
                if (requestInfo.getMessageType().equals("4")) {
                    controllerMessageHelper.parseRegisterDriverReply(null, 12, ((HashMap)object3).get("4").toString());
                    continue;
                }
                if (requestInfo.getMessageType().equals("5")) {
                    controllerMessageHelper.parseLookupDatabaseReply(requestInfo.getLogicalDatabaseName(), null, 12);
                    continue;
                }
                if (requestInfo.getMessageType().equals("6")) {
                    controlDataSourceImpl = requestInfo.getCDS();
                    controllerMessageHelper.parseRegisterDataSourceReply(null, controlDataSourceImpl, 12, ((HashMap)object3).get("6").toString());
                    controllerMessageHelper.processCMXProperties(controlDataSourceImpl);
                    continue;
                }
                if (!requestInfo.getMessageType().equals("1")) continue;
                controlDataSourceImpl = requestInfo.getCDS();
                controllerMessageHelper.parseLookupReply(null, controlDataSourceImpl, ((HashMap)object3).get("1").toString());
                controlDataSourceImpl.initialLookupOccurred();
            }
        }
    }

    private JSONArray buildRegistryParameters() {
        JSONArray jSONArray = new JSONArray(1);
        if (logger__.isLoggable(Level.FINER)) {
            jSONArray.add(0, (Object)1);
        } else {
            jSONArray.add(0, (Object)0);
        }
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "buildRegistryParameters", "buildRegistryParameters built :  " + jSONArray.toString());
        }
        return jSONArray;
    }

    @Override
    public void logLookup(String string, String string2, String string3, String string4, String string5, String string6, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5) throws Exception {
    }

    @Override
    public void logStatistics(String string, String string2, String string3, String string4, String[] stringArray, String[] stringArray2, String[] stringArray3, Set<ClientInfo>[] setArray, HashMap<String, TransportPoolStatistics> hashMap, long[][] lArray, Long[] longArray, Object[][] objectArray, String[] stringArray4, String[] stringArray5, String[] stringArray6, String[] stringArray7, long[][] lArray2) throws Exception {
    }

    @Override
    public void logPushDownErrors(String string, String string2, String string3, MonitorInterface.ClientRuntime clientRuntime, ArrayList<PushDownError> arrayList) throws Exception {
    }

    @Override
    public void logApplicationException(String string, String string2, String string3, MonitorInterface.ClientRuntime clientRuntime, SQLException sQLException) throws Exception {
    }

    @Override
    public void logPushDownApplication(String string, String string2, Map<String, Object> map, String string3, String string4, String string5, String string6, String[] stringArray, Map<String, Object>[] mapArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, HashMap<String, String>[] hashMapArray) throws Exception {
    }

    @Override
    public int getNegotiatedVersion() {
        return 12;
    }

    public static NPXControllerAgentImpl getInstance() {
        if (instance_ == null) {
            instance_ = new NPXControllerAgentImpl();
        }
        return instance_;
    }

    public void setConnectionMap(Map<Integer, Connection> map) {
        this.monconnectionMap = map;
    }
}

