/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class OracleConversionReader
extends Reader {
    static final int CHUNK_SIZE = 32768;
    DBConversion dbConversion;
    int conversion;
    InputStream istream;
    char[] buf;
    byte[] byteBuf;
    int pos;
    int count;
    int numUnconvertedBytes;
    boolean isClosed;
    boolean endOfStream;
    private short csform;
    int[] nbytes;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;

    public OracleConversionReader(DBConversion conv_object, InputStream istream, int conversion) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$8, null, conv_object, istream, conversion);
            }
            if (conv_object == null || istream == null || conversion != 8 && conversion != 9) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$8, null, sQLException);
                }
                throw sQLException;
            }
            this.dbConversion = conv_object;
            this.conversion = conversion;
            this.istream = istream;
            this.count = 0;
            this.pos = 0;
            this.numUnconvertedBytes = 0;
            this.isClosed = false;
            this.nbytes = new int[1];
            if (conversion == 8) {
                this.byteBuf = new byte[16384];
                this.buf = new char[32768];
            } else if (conversion == 9) {
                this.byteBuf = new byte[32768];
                this.buf = new char[32768];
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$8, null);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$8, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$8, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setFormOfUse(short s2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void csform;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$0, this, s2);
            }
            this.csform = csform;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read(char[] cArray, int n2, int n3) throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void cbuf;
            void len;
            void off;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$1, this, cArray, n2, n3);
            }
            this.ensureOpen();
            if (!this.needChars()) {
                int n4 = -1;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$1, this, n4);
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$1, this, null);
                }
                return -1;
            }
            void start = off;
            void end = start + Math.min((int)len, ((void)cbuf).length - off);
            start += this.writeChars((char[])cbuf, (int)start, (int)(end - start));
            while (start < end && this.needChars()) {
                start += this.writeChars((char[])cbuf, (int)start, (int)(end - start));
            }
            void var7_6 = start - off;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$1, this, (int)var7_6);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$1, this, null);
            }
            return (int)var7_6;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    protected boolean needChars() throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$2, this, new Object[0]);
            }
            this.ensureOpen();
            if (this.pos >= this.count) {
                block20: {
                    if (!this.endOfStream) {
                        boolean bl2;
                        block21: {
                            boolean bl3;
                            try {
                                int bytes_read = this.istream.read(this.byteBuf, this.numUnconvertedBytes, this.byteBuf.length - this.numUnconvertedBytes);
                                if (bytes_read == -1) {
                                    this.endOfStream = true;
                                    if (this.numUnconvertedBytes != 0) {
                                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 55).fillInStackTrace();
                                        if (bl) {
                                            ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$2, this, sQLException);
                                        }
                                        throw sQLException;
                                    }
                                }
                                if ((bytes_read += this.numUnconvertedBytes) <= 0) break block20;
                                switch (this.conversion) {
                                    case 8: {
                                        this.count = DBConversion.RAWBytesToHexChars(this.byteBuf, bytes_read, this.buf);
                                        break;
                                    }
                                    case 9: {
                                        this.nbytes[0] = bytes_read;
                                        this.count = this.csform == 2 ? this.dbConversion.NCHARBytesToJavaChars(this.byteBuf, 0, this.buf, 0, this.nbytes, this.buf.length) : this.dbConversion.CHARBytesToJavaChars(this.byteBuf, 0, this.buf, 0, this.nbytes, this.buf.length);
                                        this.numUnconvertedBytes = this.nbytes[0];
                                        for (int i2 = 0; i2 < this.numUnconvertedBytes; ++i2) {
                                            this.byteBuf[i2] = this.byteBuf[bytes_read - this.numUnconvertedBytes + i2];
                                        }
                                        break;
                                    }
                                    default: {
                                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23).fillInStackTrace();
                                        if (bl) {
                                            ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$2, this, sQLException);
                                        }
                                        throw sQLException;
                                    }
                                }
                                if (this.count <= 0) break block20;
                                this.pos = 0;
                                bl2 = bl3 = true;
                                if (!bl) break block21;
                            }
                            catch (SQLException e2) {
                                IOException iOException = (IOException)DatabaseError.createIOException(e2).fillInStackTrace();
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$2, this, iOException);
                                }
                                throw iOException;
                            }
                            ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$2, this, bl3);
                            ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$2, this, null);
                        }
                        return bl2;
                    }
                }
                boolean bl4 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$2, this, bl4);
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$2, this, null);
                }
                return false;
            }
            boolean bl5 = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$2, this, bl5);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$2, this, null);
            }
            return true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected int writeChars(char[] cArray, int n2, int n3) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void offset;
            void destbuf;
            void length;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$3, this, cArray, n2, n3);
            }
            int availableLength = Math.min((int)length, this.count - this.pos);
            System.arraycopy(this.buf, this.pos, destbuf, (int)offset, availableLength);
            this.pos += availableLength;
            int n4 = availableLength;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$3, this, n4);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$3, this, null);
            }
            return n4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean ready() throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$4, this, new Object[0]);
            }
            this.ensureOpen();
            boolean bl3 = bl2 = this.pos < this.count;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$4, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$4, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void close() throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$5, this, new Object[0]);
            }
            if (!this.isClosed) {
                this.isClosed = true;
                this.istream.close();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    void ensureOpen() throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$6, this, new Object[0]);
            }
            try {
                if (this.isClosed) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 57, null).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$6, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            catch (SQLException e2) {
                IOException iOException = (IOException)DatabaseError.createIOException(e2).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$6, this, iOException);
                }
                throw iOException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$7, this, new Object[0]);
            }
            OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$7, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$7, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleConversionReader.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$8 = OracleConversionReader.class.getDeclaredConstructor(DBConversion.class, InputStream.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleConversionReader.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleConversionReader.class.getDeclaredMethod("ensureOpen", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleConversionReader.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleConversionReader.class.getDeclaredMethod("ready", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleConversionReader.class.getDeclaredMethod("writeChars", char[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleConversionReader.class.getDeclaredMethod("needChars", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleConversionReader.class.getDeclaredMethod("read", char[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleConversionReader.class.getDeclaredMethod("setFormOfUse", Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

