/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.SchemaInfoLevel;
import schemacrawler.schemacrawler.SchemaInfoLevelBuilder;
import us.fatehi.utility.string.StringFormat;

public enum InfoLevel {
    unknown(() -> SchemaInfoLevelBuilder.standard()),
    minimum(() -> SchemaInfoLevelBuilder.minimum()),
    standard(() -> SchemaInfoLevelBuilder.standard()),
    detailed(() -> SchemaInfoLevelBuilder.detailed()),
    maximum(() -> SchemaInfoLevelBuilder.maximum());

    private static final Logger LOGGER;
    private final Supplier<SchemaInfoLevel> toSchemaInfoLevelFunction;

    public static InfoLevel valueOfFromString(String infoLevelValue) {
        try {
            return InfoLevel.valueOf(infoLevelValue);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Unknown infolevel <%s>", new Object[]{infoLevelValue}));
            return unknown;
        }
    }

    private InfoLevel(Supplier<SchemaInfoLevel> toSchemaInfoLevelFunction) {
        this.toSchemaInfoLevelFunction = toSchemaInfoLevelFunction;
    }

    public final SchemaInfoLevel toSchemaInfoLevel() {
        return this.toSchemaInfoLevelFunction.get();
    }

    static {
        LOGGER = Logger.getLogger(InfoLevel.class.getName());
    }
}

