/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Objects;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.encodings.IEncodingFactory;
import org.firebirdsql.gds.impl.GDSServerVersion;
import org.firebirdsql.gds.impl.GDSServerVersionException;
import org.firebirdsql.gds.ng.AbstractConnection;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.gds.ng.FbAttachment;
import org.firebirdsql.gds.ng.IAttachProperties;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.ServerVersionInformation;
import org.firebirdsql.gds.ng.listeners.ExceptionListener;
import org.firebirdsql.gds.ng.listeners.ExceptionListenerDispatcher;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public abstract class AbstractFbAttachment<T extends AbstractConnection<? extends IAttachProperties<?>, ? extends FbAttachment>>
implements FbAttachment {
    private static final Logger log = LoggerFactory.getLogger(AbstractFbAttachment.class);
    private volatile boolean attached;
    protected final ExceptionListenerDispatcher exceptionListenerDispatcher = new ExceptionListenerDispatcher(this);
    protected final T connection;
    private final DatatypeCoder datatypeCoder;
    private GDSServerVersion serverVersion;
    private ServerVersionInformation serverVersionInformation;

    protected AbstractFbAttachment(T connection, DatatypeCoder datatypeCoder) {
        this.connection = (AbstractConnection)Objects.requireNonNull(connection, "parameter connection should be non-null");
        this.datatypeCoder = Objects.requireNonNull(datatypeCoder, "parameter datatypeCoder should be non-null");
    }

    @Override
    public final LockCloseable withLock() {
        return ((AbstractConnection)this.connection).withLock();
    }

    @Override
    public final boolean isLockedByCurrentThread() {
        return ((AbstractConnection)this.connection).isLockedByCurrentThread();
    }

    @Override
    public void forceClose() throws SQLException {
        this.close();
    }

    @Override
    public GDSServerVersion getServerVersion() {
        return this.serverVersion;
    }

    protected final void setServerVersion(String ... versionStrings) {
        try {
            this.serverVersion = GDSServerVersion.parseRawVersion(versionStrings);
        }
        catch (GDSServerVersionException e) {
            log.errorfe("Received unsupported server version \"%s\", replacing with dummy invalid version", Arrays.toString(versionStrings), e);
            this.serverVersion = GDSServerVersion.INVALID_VERSION;
        }
        this.serverVersionInformation = ServerVersionInformation.getForVersion(this.serverVersion);
    }

    protected ServerVersionInformation getServerVersionInformation() {
        return this.serverVersionInformation;
    }

    protected final void setAttached() {
        this.attached = true;
    }

    @Override
    public boolean isAttached() {
        return this.attached;
    }

    protected final void setDetached() {
        this.attached = false;
    }

    @Override
    public final IEncodingFactory getEncodingFactory() {
        return ((AbstractConnection)this.connection).getEncodingFactory();
    }

    @Override
    public final Encoding getEncoding() {
        return ((AbstractConnection)this.connection).getEncoding();
    }

    @Override
    public final DatatypeCoder getDatatypeCoder() {
        return this.datatypeCoder;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.checkConnected();
        int soTimeout = ((AbstractConnection)this.connection).getAttachProperties().getSoTimeout();
        return soTimeout != -1 ? soTimeout : 0;
    }

    @Override
    public final void addExceptionListener(ExceptionListener listener) {
        this.exceptionListenerDispatcher.addListener(listener);
    }

    @Override
    public final void removeExceptionListener(ExceptionListener listener) {
        this.exceptionListenerDispatcher.removeListener(listener);
    }

    protected abstract void checkConnected() throws SQLException;

    protected final void safelyDetach() {
        try {
            this.close();
        }
        catch (Exception ex) {
            log.debug("Exception on safely detach", ex);
        }
    }
}

