/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.argument;

import java.io.IOException;
import java.io.OutputStream;
import org.firebirdsql.gds.VaxEncoding;

public enum ArgumentType {
    TraditionalDpb{

        @Override
        public int getLengthSize() {
            return 1;
        }

        @Override
        public int getMaxLength() {
            return 255;
        }

        @Override
        public void writeLength(int length, OutputStream outputStream) throws IOException {
            outputStream.write(length);
        }
    }
    ,
    SingleTpb{

        @Override
        public int getLengthSize() {
            return 0;
        }

        @Override
        public int getMaxLength() {
            return 0;
        }

        @Override
        public void writeLength(int length, OutputStream outputStream) {
        }
    }
    ,
    StringSpb{

        @Override
        public int getLengthSize() {
            return 2;
        }

        @Override
        public int getMaxLength() {
            return 65536;
        }

        @Override
        public void writeLength(int length, OutputStream outputStream) throws IOException {
            VaxEncoding.encodeVaxInteger2WithoutLength(outputStream, length);
        }
    }
    ,
    BigIntSpb{

        @Override
        public int getLengthSize() {
            return 0;
        }

        @Override
        public int getMaxLength() {
            return 8;
        }

        @Override
        public void writeLength(int length, OutputStream outputStream) {
        }
    }
    ,
    IntSpb{

        @Override
        public int getLengthSize() {
            return 0;
        }

        @Override
        public int getMaxLength() {
            return 4;
        }

        @Override
        public void writeLength(int length, OutputStream outputStream) {
        }
    }
    ,
    ByteSpb{

        @Override
        public int getLengthSize() {
            return 0;
        }

        @Override
        public int getMaxLength() {
            return 1;
        }

        @Override
        public void writeLength(int length, OutputStream outputStream) {
        }
    }
    ,
    Wide{

        @Override
        public int getLengthSize() {
            return 4;
        }

        @Override
        public int getMaxLength() {
            return Integer.MAX_VALUE;
        }

        @Override
        public void writeLength(int length, OutputStream outputStream) throws IOException {
            VaxEncoding.encodeVaxIntegerWithoutLength(outputStream, length);
        }
    };


    public abstract int getLengthSize();

    public abstract int getMaxLength();

    public abstract void writeLength(int var1, OutputStream var2) throws IOException;
}

