/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler;

import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import picocli.CommandLine;
import schemacrawler.Version;
import schemacrawler.tools.commandline.ConnectionTest;
import schemacrawler.tools.commandline.ConnectionTestOptions;
import schemacrawler.tools.commandline.InteractiveShellOptions;
import schemacrawler.tools.commandline.SchemaCrawlerCommandLine;
import schemacrawler.tools.commandline.SchemaCrawlerShell;
import schemacrawler.tools.commandline.command.CommandLineHelpCommand;
import schemacrawler.tools.commandline.command.LogCommand;
import schemacrawler.tools.commandline.shell.SystemCommand;
import schemacrawler.tools.commandline.state.ShellState;
import schemacrawler.tools.registry.JDBCDriverRegistry;
import us.fatehi.utility.SystemExitException;
import us.fatehi.utility.UtilityLogger;
import us.fatehi.utility.property.JvmArchitectureInfo;
import us.fatehi.utility.property.JvmSystemInfo;
import us.fatehi.utility.property.OperatingSystemInfo;
import us.fatehi.utility.readconfig.SystemPropertiesConfig;

public final class Main {
    private static final Logger LOGGER = Logger.getLogger(Main.class.getName());
    private static final String SC_EXIT_WITH_EXCEPTION = "SC_EXIT_WITH_EXCEPTION";

    public static void main(String ... args) throws Exception {
        Objects.requireNonNull(args, "No command-line arguments provided");
        CommandLine commandLine = new CommandLine((Object)new LogCommand());
        commandLine.setUnmatchedArgumentsAllowed(true);
        commandLine.execute(args);
        LOGGER.log(Level.INFO, String.valueOf(Version.version()));
        LOGGER.log(Level.INFO, String.valueOf(OperatingSystemInfo.operatingSystemInfo()));
        LOGGER.log(Level.INFO, String.valueOf(JvmSystemInfo.jvmSystemInfo()));
        LOGGER.log(Level.INFO, String.valueOf(JvmArchitectureInfo.jvmArchitectureInfo()));
        UtilityLogger logger = new UtilityLogger(LOGGER);
        logger.logSafeArguments(args);
        logger.logSystemClasspath();
        logger.logSystemProperties();
        JDBCDriverRegistry.getJDBCDriverRegistry();
        ConnectionTestOptions connectionTestOptions = new ConnectionTestOptions();
        CommandLine.populateCommand((Object)connectionTestOptions, (String[])args);
        boolean isConnectionTest = connectionTestOptions.isConnectionTest();
        InteractiveShellOptions interactiveShellOptions = new InteractiveShellOptions();
        CommandLine.populateCommand((Object)interactiveShellOptions, (String[])args);
        boolean isInteractive = interactiveShellOptions.isInteractive();
        int exitCode = 0;
        if (isConnectionTest) {
            exitCode = ConnectionTest.execute(args);
        } else if (isInteractive) {
            exitCode = SchemaCrawlerShell.execute(args);
        } else {
            if (Main.showHelpIfRequested(args) || Main.showVersionIfRequested(args)) {
                return;
            }
            exitCode = SchemaCrawlerCommandLine.execute(args);
        }
        if (exitCode == 0) {
            return;
        }
        Main.exit(exitCode);
    }

    private static void exit(int exitCode) {
        boolean exitWithException = new SystemPropertiesConfig().getBooleanValue(SC_EXIT_WITH_EXCEPTION);
        if (exitWithException) {
            throw new SystemExitException(exitCode, "SchemaCrawler has exited with an error");
        }
        System.exit(exitCode);
    }

    private static boolean showHelpIfRequested(String[] args) {
        CommandLineHelpCommand commandLineHelpCommand = new CommandLineHelpCommand();
        CommandLine commandLine = new CommandLine((Object)commandLineHelpCommand);
        commandLine.setUnmatchedArgumentsAllowed(true);
        commandLine.parseArgs(args);
        if (commandLineHelpCommand.isHelpRequested()) {
            commandLineHelpCommand.run();
            return true;
        }
        return false;
    }

    private static boolean showVersionIfRequested(String[] args) {
        ShellState state = new ShellState();
        SystemCommand systemCommand = new SystemCommand(state);
        CommandLine commandLine = new CommandLine((Object)systemCommand);
        commandLine.setUnmatchedArgumentsAllowed(true);
        commandLine.parseArgs(args);
        if (systemCommand.isVersionRequested() || systemCommand.isShowEnvironment()) {
            systemCommand.run();
            return true;
        }
        return false;
    }

    private Main() {
    }
}

