/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser.impl;

import tools.jackson.core.JacksonException;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.PropertyMetadata;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.introspect.AnnotatedMember;

public class ValueInjector
extends BeanProperty.Std {
    private static final long serialVersionUID = 1L;
    protected final Object _valueId;
    protected final Boolean _optional;
    protected final Boolean _useInput;

    public ValueInjector(PropertyName propName, JavaType type, AnnotatedMember mutator, Object valueId, Boolean optional, Boolean useInput) {
        super(propName, type, null, mutator, PropertyMetadata.STD_OPTIONAL);
        this._valueId = valueId;
        this._optional = optional;
        this._useInput = useInput;
    }

    public Object findValue(DeserializationContext context, Object beanInstance) throws JacksonException {
        return context.findInjectableValue(this._valueId, this, beanInstance, this._optional, this._useInput);
    }

    public void inject(DeserializationContext context, Object beanInstance) throws JacksonException {
        Object value = this.findValue(context, beanInstance);
        if (value == null) {
            if (Boolean.FALSE.equals(this._optional)) {
                throw context.missingInjectableValueException(String.format("No injectable value with id '%s' found (for property '%s')", this._valueId, this.getName()), this._valueId, null, beanInstance);
            }
        } else if (!Boolean.TRUE.equals(this._useInput)) {
            this._member.setValue(beanInstance, value);
        }
    }
}

