/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.templateresolver;

import java.util.Map;
import java.util.Set;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.cache.ICacheEntryValidity;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.TemplateResolution;
import org.thymeleaf.templateresource.ITemplateResource;
import org.thymeleaf.util.PatternSpec;
import org.thymeleaf.util.Validate;

public abstract class AbstractTemplateResolver
implements ITemplateResolver {
    public static final boolean DEFAULT_EXISTENCE_CHECK = false;
    public static final boolean DEFAULT_USE_DECOUPLED_LOGIC = false;
    private String name = this.getClass().getName();
    private Integer order = null;
    private boolean checkExistence = false;
    private boolean useDecoupledLogic = false;
    private final PatternSpec resolvablePatternSpec = new PatternSpec();

    protected AbstractTemplateResolver() {
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public final Integer getOrder() {
        return this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public final PatternSpec getResolvablePatternSpec() {
        return this.resolvablePatternSpec;
    }

    public final Set<String> getResolvablePatterns() {
        return this.resolvablePatternSpec.getPatterns();
    }

    public void setResolvablePatterns(Set<String> resolvablePatterns) {
        this.resolvablePatternSpec.setPatterns(resolvablePatterns);
    }

    public final boolean getCheckExistence() {
        return this.checkExistence;
    }

    public void setCheckExistence(boolean checkExistence) {
        this.checkExistence = checkExistence;
    }

    public final boolean getUseDecoupledLogic() {
        return this.useDecoupledLogic;
    }

    public void setUseDecoupledLogic(boolean useDecoupledLogic) {
        this.useDecoupledLogic = useDecoupledLogic;
    }

    @Override
    public final TemplateResolution resolveTemplate(IEngineConfiguration configuration, String ownerTemplate, String template, Map<String, Object> templateResolutionAttributes) {
        Validate.notNull(configuration, "Engine Configuration cannot be null");
        Validate.notNull(template, "Template Name cannot be null");
        if (!this.computeResolvable(configuration, ownerTemplate, template, templateResolutionAttributes)) {
            return null;
        }
        ITemplateResource templateResource = this.computeTemplateResource(configuration, ownerTemplate, template, templateResolutionAttributes);
        if (templateResource == null) {
            return null;
        }
        if (this.checkExistence && !templateResource.exists()) {
            return null;
        }
        return new TemplateResolution(templateResource, this.checkExistence, this.computeTemplateMode(configuration, ownerTemplate, template, templateResolutionAttributes), this.useDecoupledLogic, this.computeValidity(configuration, ownerTemplate, template, templateResolutionAttributes));
    }

    protected boolean computeResolvable(IEngineConfiguration configuration, String ownerTemplate, String template, Map<String, Object> templateResolutionAttributes) {
        if (this.resolvablePatternSpec.isEmpty()) {
            return true;
        }
        return this.resolvablePatternSpec.matches(template);
    }

    protected abstract ITemplateResource computeTemplateResource(IEngineConfiguration var1, String var2, String var3, Map<String, Object> var4);

    protected abstract TemplateMode computeTemplateMode(IEngineConfiguration var1, String var2, String var3, Map<String, Object> var4);

    protected abstract ICacheEntryValidity computeValidity(IEngineConfiguration var1, String var2, String var3, Map<String, Object> var4);
}

