/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.call.special;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.method.PMethod;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRootNode;
import com.oracle.graal.python.nodes.builtins.FunctionNodes;
import com.oracle.graal.python.nodes.function.BuiltinFunctionRootNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.api.nodes.RootNode;

@ImportStatic(value={PythonOptions.class, PGuards.class})
@NodeField(name="maxSizeExceeded", type=boolean.class)
abstract class AbstractCallMethodNode
extends PNodeWithContext {
    AbstractCallMethodNode() {
    }

    protected abstract boolean isMaxSizeExceeded();

    protected abstract void setMaxSizeExceeded(boolean var1);

    protected PythonBuiltinBaseNode getBuiltin(VirtualFrame frame, PBuiltinFunction func, int nargs) {
        PythonBuiltinBaseNode builtinNode;
        CompilerAsserts.neverPartOfCompilation();
        NodeFactory<? extends PythonBuiltinBaseNode> builtinNodeFactory = func.getBuiltinNodeFactory();
        if (builtinNodeFactory == null) {
            return null;
        }
        if (TpSlot.TpSlotBuiltin.isSlotFactory(builtinNodeFactory)) {
            return null;
        }
        Class nodeClass = builtinNodeFactory.getNodeClass();
        int builtinNodeArity = AbstractCallMethodNode.getBuiltinNodeArity(nodeClass);
        if (builtinNodeArity == -1 || builtinNodeArity < nargs) {
            return null;
        }
        Slot.SlotSignature slotSignature = nodeClass.getAnnotation(Slot.SlotSignature.class);
        if (slotSignature != null) {
            if (slotSignature.needsFrame() || nargs < slotSignature.minNumOfPositionalArgs()) {
                return null;
            }
            int maxArgs = Math.max(Math.max(slotSignature.maxNumOfPositionalArgs(), slotSignature.minNumOfPositionalArgs()), slotSignature.parameterNames().length);
            if (nargs > maxArgs) {
                return null;
            }
        } else {
            Builtin[] builtinAnnotations = (Builtin[])nodeClass.getAnnotationsByType(Builtin.class);
            if (builtinAnnotations.length > 0) {
                Builtin builtinAnnotation = builtinAnnotations[0];
                if (builtinAnnotation.needsFrame() && frame == null) {
                    return null;
                }
                int maxArgs = Math.max(Math.max(builtinAnnotation.maxNumOfPositionalArgs(), builtinAnnotation.minNumOfPositionalArgs()), builtinAnnotation.parameterNames().length);
                if (nargs < builtinAnnotation.minNumOfPositionalArgs() || nargs > maxArgs) {
                    return null;
                }
            }
        }
        if (!this.callerExceedsMaxSize(builtinNode = (PythonBuiltinBaseNode)((Object)builtinNodeFactory.createNode(new Object[0])))) {
            return builtinNode;
        }
        return null;
    }

    private static int getBuiltinNodeArity(Class<? extends PythonBuiltinBaseNode> nodeClass) {
        if (PythonQuaternaryBuiltinNode.class.isAssignableFrom(nodeClass)) {
            return 4;
        }
        if (PythonTernaryBuiltinNode.class.isAssignableFrom(nodeClass)) {
            return 3;
        }
        if (PythonBinaryBuiltinNode.class.isAssignableFrom(nodeClass)) {
            return 2;
        }
        if (PythonUnaryBuiltinNode.class.isAssignableFrom(nodeClass)) {
            return 1;
        }
        return -1;
    }

    private <T extends PythonBuiltinBaseNode> boolean callerExceedsMaxSize(T builtinNode) {
        CompilerAsserts.neverPartOfCompilation();
        if (this.isAdoptable() && !this.isMaxSizeExceeded()) {
            Class<?> builtinClass = ((Object)builtinNode).getClass();
            int recursiveCalls = 0;
            PythonLanguage language = PythonLanguage.get(this);
            for (Node parent = this.getParent(); parent != null && !(parent instanceof RootNode); parent = parent.getParent()) {
                if (parent.getClass() != builtinClass) continue;
                int recursionLimit = language.getEngineOption(PythonOptions.NodeRecursionLimit);
                if (recursiveCalls == recursionLimit) {
                    return true;
                }
                ++recursiveCalls;
            }
            RootNode root = this.getRootNode();
            int maxSize = language.getEngineOption(PythonOptions.BuiltinsInliningMaxCallerSize);
            if (root instanceof PRootNode) {
                PRootNode pRoot = (PRootNode)root;
                int rootNodeCount = pRoot.getNodeCountForInlining();
                if (rootNodeCount < maxSize) {
                    PythonUtils.NodeCounterWithLimit counter = new PythonUtils.NodeCounterWithLimit(rootNodeCount, maxSize);
                    builtinNode.accept(counter);
                    if (counter.isOverLimit()) {
                        this.setMaxSizeExceeded(true);
                        return true;
                    }
                    pRoot.setNodeCountForInlining(counter.getCount());
                }
            } else {
                PythonUtils.NodeCounterWithLimit counter = new PythonUtils.NodeCounterWithLimit(maxSize);
                root.accept((NodeVisitor)counter);
                if (!counter.isOverLimit()) {
                    builtinNode.accept(counter);
                }
                if (counter.isOverLimit()) {
                    this.setMaxSizeExceeded(true);
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    protected static boolean takesSelfArg(Object func) {
        if (func instanceof PBuiltinFunction) {
            RootNode functionRootNode = ((PBuiltinFunction)func).getFunctionRootNode();
            if (functionRootNode instanceof BuiltinFunctionRootNode) {
                return ((BuiltinFunctionRootNode)functionRootNode).declaresExplicitSelf();
            }
        } else if (func instanceof PBuiltinMethod) {
            return AbstractCallMethodNode.takesSelfArg(((PBuiltinMethod)func).getFunction());
        }
        return true;
    }

    protected static RootCallTarget getCallTarget(PMethod meth, FunctionNodes.GetCallTargetNode getCtNode) {
        return getCtNode.execute(meth.getFunction());
    }

    protected static RootCallTarget getCallTarget(PBuiltinMethod meth, FunctionNodes.GetCallTargetNode getCtNode) {
        return getCtNode.execute(meth.getFunction());
    }

    protected static Object callUnaryBuiltin(VirtualFrame frame, PythonBuiltinBaseNode builtin, Object arg1) {
        CompilerAsserts.partialEvaluationConstant((Object)((Object)builtin));
        if (builtin instanceof PythonUnaryBuiltinNode) {
            return ((PythonUnaryBuiltinNode)builtin).execute(frame, arg1);
        }
        if (builtin instanceof PythonBinaryBuiltinNode) {
            return ((PythonBinaryBuiltinNode)builtin).execute(frame, arg1, PNone.NO_VALUE);
        }
        if (builtin instanceof PythonTernaryBuiltinNode) {
            return ((PythonTernaryBuiltinNode)builtin).execute(frame, arg1, PNone.NO_VALUE, PNone.NO_VALUE);
        }
        if (builtin instanceof PythonQuaternaryBuiltinNode) {
            return ((PythonQuaternaryBuiltinNode)builtin).execute(frame, arg1, PNone.NO_VALUE, PNone.NO_VALUE, PNone.NO_VALUE);
        }
        throw CompilerDirectives.shouldNotReachHere((String)"Unexpected builtin node type");
    }

    protected static Object callBinaryBuiltin(VirtualFrame frame, PythonBuiltinBaseNode builtin, Object arg1, Object arg2) {
        CompilerAsserts.partialEvaluationConstant((Object)((Object)builtin));
        if (builtin instanceof PythonBinaryBuiltinNode) {
            return ((PythonBinaryBuiltinNode)builtin).execute(frame, arg1, arg2);
        }
        if (builtin instanceof PythonTernaryBuiltinNode) {
            return ((PythonTernaryBuiltinNode)builtin).execute(frame, arg1, arg2, PNone.NO_VALUE);
        }
        if (builtin instanceof PythonQuaternaryBuiltinNode) {
            return ((PythonQuaternaryBuiltinNode)builtin).execute(frame, arg1, arg2, PNone.NO_VALUE, PNone.NO_VALUE);
        }
        throw CompilerDirectives.shouldNotReachHere((String)"Unexpected builtin node type");
    }

    protected static Object callTernaryBuiltin(VirtualFrame frame, PythonBuiltinBaseNode builtin, Object arg1, Object arg2, Object arg3) {
        CompilerAsserts.partialEvaluationConstant((Object)((Object)builtin));
        if (builtin instanceof PythonTernaryBuiltinNode) {
            return ((PythonTernaryBuiltinNode)builtin).execute(frame, arg1, arg2, arg3);
        }
        if (builtin instanceof PythonQuaternaryBuiltinNode) {
            return ((PythonQuaternaryBuiltinNode)builtin).execute(frame, arg1, arg2, arg3, PNone.NO_VALUE);
        }
        throw CompilerDirectives.shouldNotReachHere((String)"Unexpected builtin node type");
    }

    protected static Object callQuaternaryBuiltin(VirtualFrame frame, PythonBuiltinBaseNode builtin, Object arg1, Object arg2, Object arg3, Object arg4) {
        CompilerAsserts.partialEvaluationConstant((Object)((Object)builtin));
        if (builtin instanceof PythonQuaternaryBuiltinNode) {
            return ((PythonQuaternaryBuiltinNode)builtin).execute(frame, arg1, arg2, arg3, arg4);
        }
        throw CompilerDirectives.shouldNotReachHere((String)"Unexpected builtin node type");
    }
}

