/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib.fastpath;

import com.oracle.graal.python.nodes.expression.BinaryOpNode;
import com.oracle.graal.python.nodes.truffle.PythonIntegerTypes;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;

@GenerateCached(value=false)
@TypeSystemReference(value=PythonIntegerTypes.class)
public abstract class PyNumberFloorDivideFastPathsBase
extends BinaryOpNode {
    @Specialization(guards={"!specialCase(left, right)"})
    public static int doII(int left, int right) {
        return Math.floorDiv(left, right);
    }

    @Specialization(guards={"!specialCase(left, right)"})
    public static long doLL(long left, long right) {
        return Math.floorDiv(left, right);
    }

    @Specialization(guards={"!isZero(right)"})
    public static double doLD(long left, double right) {
        return PyNumberFloorDivideFastPathsBase.doDD(left, right);
    }

    @Specialization(guards={"right != 0"})
    public static double doDL(double left, long right) {
        return PyNumberFloorDivideFastPathsBase.doDD(left, right);
    }

    @Specialization(guards={"!isZero(right)"})
    public static double doDD(double left, double right) {
        return Math.floor(left / right);
    }

    public static boolean specialCase(int left, int right) {
        return right == 0 || left == Integer.MIN_VALUE && right == -1;
    }

    public static boolean specialCase(long left, long right) {
        return right == 0L || left == Long.MIN_VALUE && right == -1L;
    }

    public static boolean isZero(double right) {
        return right == 0.0;
    }
}

