/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.ssl;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.ssl.SSLCipher;
import com.oracle.graal.python.builtins.objects.ssl.SSLCipherStringMapping;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class SSLCipherSelector {
    private static final SSLCipher[] TLS3_CIPHER_SUITES = new SSLCipher[]{SSLCipher.TLS_AES_256_GCM_SHA384, SSLCipher.TLS_CHACHA20_POLY1305_SHA256, SSLCipher.TLS_AES_128_GCM_SHA256};

    @CompilerDirectives.TruffleBoundary
    public static SSLCipher[] selectCiphers(Node node, String cipherList) {
        LinkedList<SSLCipher> selected = new LinkedList<SSLCipher>();
        HashSet<SSLCipher> deleted = new HashSet<SSLCipher>();
        SSLCipherSelector.selectCiphersFromList(node, cipherList, selected, deleted);
        if (selected.size() == 0) {
            throw PConstructAndRaiseNode.raiseUncachedSSLError(ErrorMessages.NO_CIPHER_CAN_BE_SELECTED);
        }
        SSLCipher[] result = new SSLCipher[TLS3_CIPHER_SUITES.length + selected.size()];
        System.arraycopy(TLS3_CIPHER_SUITES, 0, result, 0, TLS3_CIPHER_SUITES.length);
        for (int i = 0; i < selected.size(); ++i) {
            result[SSLCipherSelector.TLS3_CIPHER_SUITES.length + i] = (SSLCipher)((Object)selected.get(i));
        }
        return result;
    }

    private static void selectCiphersFromList(Node node, String cipherList, List<SSLCipher> selected, Set<SSLCipher> deleted) {
        for (String cipherString : cipherList.split("[:, ]")) {
            SSLCipherSelector.selectSingle(node, cipherString, selected, deleted);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void selectSingle(Node node, String cipherString, List<SSLCipher> selected, Set<SSLCipher> deleted) {
        if (cipherString.startsWith("!")) {
            List<SSLCipher> ciphers = SSLCipherSelector.getCiphersForCipherString(node, cipherString.substring(1));
            selected.removeAll(ciphers);
            deleted.addAll(ciphers);
            return;
        }
        if (cipherString.startsWith("-")) {
            selected.removeAll(SSLCipherSelector.getCiphersForCipherString(node, cipherString.substring(1)));
            return;
        }
        if (cipherString.startsWith("+")) {
            Iterator<SSLCipher> ciphers = SSLCipherSelector.getCiphersForCipherString(node, cipherString.substring(1)).iterator();
            while (ciphers.hasNext()) {
                SSLCipher cipher = ciphers.next();
                if (!selected.remove((Object)cipher)) continue;
                selected.add(cipher);
            }
            return;
        }
        if (cipherString.startsWith("@")) {
            if (cipherString.startsWith("@STRENGTH")) {
                selected.sort(Comparator.comparingInt(SSLCipher::getStrengthBits).reversed());
                return;
            }
            if (!cipherString.startsWith("@SECLEVEL=")) throw PConstructAndRaiseNode.raiseUncachedSSLError(ErrorMessages.NO_CIPHER_CAN_BE_SELECTED);
            throw PRaiseNode.raiseStatic(node, PythonBuiltinClassType.NotImplementedError, PythonUtils.toTruffleStringUncached("@SECLEVEL not implemented"));
        }
        if (cipherString.equals("DEFAULT")) {
            SSLCipherSelector.selectCiphersFromList(node, "ALL:!COMPLEMENTOFDEFAULT:!eNULL", selected, deleted);
            return;
        }
        List<SSLCipher> ciphers = SSLCipherSelector.getCiphersForCipherString(node, cipherString);
        Iterator<SSLCipher> iterator = ciphers.iterator();
        while (iterator.hasNext()) {
            SSLCipher cipher = iterator.next();
            if (deleted.contains((Object)cipher) || selected.contains((Object)cipher)) continue;
            selected.add(cipher);
        }
    }

    private static List<SSLCipher> getCiphersForCipherString(Node node, String cipherString) {
        ArrayList<SSLCipher> result = null;
        for (String component : cipherString.split("\\+")) {
            List<SSLCipher> ciphers = SSLCipherStringMapping.get(component);
            if (ciphers == null) {
                if (component.equals("PROFILE=SYSTEM")) {
                    throw PRaiseNode.raiseStatic(node, PythonBuiltinClassType.NotImplementedError, PythonUtils.toTruffleStringUncached("PROFILE=SYSTEM not implemented"));
                }
                return Collections.emptyList();
            }
            if (result == null) {
                result = new ArrayList<SSLCipher>(ciphers);
                continue;
            }
            result.retainAll(ciphers);
        }
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }
}

