/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.reversed;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.iterator.PBigRangeIterator;
import com.oracle.graal.python.builtins.objects.iterator.PBuiltinIterator;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.range.PBigRange;
import com.oracle.graal.python.builtins.objects.range.PIntRange;
import com.oracle.graal.python.builtins.objects.reversed.PSequenceReverseIterator;
import com.oracle.graal.python.builtins.objects.reversed.PStringReverseIterator;
import com.oracle.graal.python.builtins.objects.reversed.ReversedBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.reversed.ReversedBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.lib.PySequenceCheckNode;
import com.oracle.graal.python.lib.PySequenceGetItemNode;
import com.oracle.graal.python.lib.PySequenceSizeNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.math.BigInteger;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PReverseIterator})
public final class ReversedBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = ReversedBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ReversedBuiltinsFactory.getFactories();
    }

    @Builtin(name="__setstate__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SetStateNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        public static Object setState(VirtualFrame frame, PBuiltinIterator self, Object index, @Bind Node inliningTarget, @Cached PyNumberAsSizeNode asSizeNode) {
            int idx = asSizeNode.executeExact((Frame)frame, inliningTarget, index);
            if (idx < -1) {
                idx = -1;
            }
            self.index = idx;
            return PNone.NONE;
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object reduce(PStringReverseIterator self, @Bind Node inliningTarget, @Cached.Shared(value="getClassNode") @Cached GetClassNode getClassNode, @Bind PythonLanguage language) {
            if (self.isExhausted()) {
                return ReduceNode.reduceInternal(inliningTarget, self, "", null, getClassNode, language);
            }
            return ReduceNode.reduceInternal(inliningTarget, self, self.value, self.index, getClassNode, language);
        }

        @Specialization(guards={"self.isPSequence()"})
        static Object reduce(PSequenceReverseIterator self, @Bind Node inliningTarget, @Cached.Shared(value="getClassNode") @Cached GetClassNode getClassNode, @Bind PythonLanguage language) {
            if (self.isExhausted()) {
                return ReduceNode.reduceInternal(inliningTarget, self, PFactory.createList(language), null, getClassNode, language);
            }
            return ReduceNode.reduceInternal(inliningTarget, self, self.getPSequence(), self.index, getClassNode, language);
        }

        @Specialization(guards={"!self.isPSequence()"})
        static Object reduce(VirtualFrame frame, PSequenceReverseIterator self, @Bind Node inliningTarget, @Cached(value="create(T___REDUCE__)") LookupAndCallUnaryNode callReduce, @Cached.Shared(value="getClassNode") @Cached GetClassNode getClassNode, @Bind PythonLanguage language) {
            Object content = callReduce.executeObject(frame, self.getObject());
            return ReduceNode.reduceInternal(inliningTarget, self, content, self.index, getClassNode, language);
        }

        private static PTuple reduceInternal(Node inliningTarget, Object self, Object arg, Object state, GetClassNode getClassNode, PythonLanguage language) {
            Object revIter = getClassNode.execute(inliningTarget, self);
            PTuple args = PFactory.createTuple(language, new Object[]{arg});
            if (state != null) {
                return PFactory.createTuple(language, new Object[]{revIter, args, state});
            }
            return PFactory.createTuple(language, new Object[]{revIter, args});
        }
    }

    @Builtin(name="__length_hint__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class LengthHintNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"self.isExhausted()"})
        static int exhausted(PBuiltinIterator self) {
            return 0;
        }

        @Specialization(guards={"!self.isExhausted()"})
        static int lengthHint(PStringReverseIterator self) {
            return self.index + 1;
        }

        @Specialization(guards={"!self.isExhausted()", "self.isPSequence()"})
        static int lengthHint(PSequenceReverseIterator self, @Bind Node inliningTarget, @Cached SequenceNodes.LenNode lenNode, @Cached PRaiseNode raiseNode) {
            int len = lenNode.execute(inliningTarget, self.getPSequence());
            if (len == -1) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.OBJ_HAS_NO_LEN, self);
            }
            if (len < self.index) {
                return 0;
            }
            return self.index + 1;
        }

        @Specialization(guards={"!self.isExhausted()", "!self.isPSequence()"})
        static int lengthHint(VirtualFrame frame, PSequenceReverseIterator self, @Bind Node inliningTarget, @Cached PyObjectSizeNode sizeNode) {
            int len = sizeNode.execute((Frame)frame, inliningTarget, self.getObject());
            if (len < self.index) {
                return 0;
            }
            return self.index + 1;
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object doGeneric(Object self) {
            return self;
        }
    }

    @Slot(value=Slot.SlotKind.tp_iternext, isComplex=true)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends TpSlotIterNext.TpIterNextBuiltin {
        @Specialization(guards={"self.isExhausted()"})
        static Object exhausted(PBuiltinIterator self) {
            throw NextNode.iteratorExhausted();
        }

        @Specialization(guards={"!self.isExhausted()"})
        static Object next(VirtualFrame frame, PSequenceReverseIterator self, @Bind Node inliningTarget, @Cached PySequenceGetItemNode getItemNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile profile) {
            if (self.index >= 0) {
                try {
                    return getItemNode.execute((Frame)frame, self.getObject(), self.index--);
                }
                catch (PException e) {
                    e.expectIndexError(inliningTarget, profile);
                }
            }
            self.setExhausted();
            throw NextNode.iteratorExhausted();
        }

        @Specialization(guards={"!self.isExhausted()"})
        static Object next(PStringReverseIterator self, @Cached TruffleString.SubstringNode substringNode) {
            if (self.index >= 0) {
                return substringNode.execute((AbstractTruffleString)self.value, self.index--, 1, PythonUtils.TS_ENCODING, false);
            }
            self.setExhausted();
            throw NextNode.iteratorExhausted();
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="reversed", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class ReversedNode
    extends PythonBuiltinNode {
        @Specialization
        static PythonObject reversed(Object cls, PIntRange range, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached InlinedBranchProfile overflowProfile) {
            int lstart = range.getIntStart();
            int lstep = range.getIntStep();
            int ulen = range.getIntLength();
            try {
                int new_stop = PythonUtils.subtractExact(lstart, lstep);
                int new_start = PythonUtils.addExact(new_stop, PythonUtils.multiplyExact(ulen, lstep));
                return PFactory.createIntRangeIterator(language, new_start, new_stop, PythonUtils.negateExact(lstep), ulen);
            }
            catch (OverflowException e) {
                overflowProfile.enter(inliningTarget);
                return ReversedNode.handleOverflow(language, lstart, lstep, ulen);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static PBigRangeIterator handleOverflow(PythonLanguage language, int lstart, int lstep, int ulen) {
            BigInteger bstart = BigInteger.valueOf(lstart);
            BigInteger bstep = BigInteger.valueOf(lstep);
            BigInteger blen = BigInteger.valueOf(ulen);
            BigInteger new_stop = bstart.subtract(bstep);
            BigInteger new_start = new_stop.add(blen.multiply(bstep));
            return PFactory.createBigRangeIterator(language, new_start, new_stop, bstep.negate(), blen);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static PythonObject reversed(Object cls, PBigRange range) {
            BigInteger lstart = range.getBigIntegerStart();
            BigInteger lstep = range.getBigIntegerStep();
            BigInteger ulen = range.getBigIntegerLength();
            BigInteger new_stop = lstart.subtract(lstep);
            BigInteger new_start = new_stop.add(ulen.multiply(lstep));
            return PFactory.createBigRangeIterator(PythonLanguage.get(null), new_start, new_stop, lstep.negate(), ulen);
        }

        @Specialization
        static PythonObject reversed(Object cls, PString value, @Bind Node inliningTarget, @Cached CastToTruffleStringNode castToStringNode, @Bind PythonLanguage language, @Cached @Cached.Shared TypeNodes.GetInstanceShape getInstanceShape) {
            return PFactory.createStringReverseIterator(language, cls, getInstanceShape.execute(cls), castToStringNode.execute(inliningTarget, value));
        }

        @Specialization
        static PythonObject reversed(Object cls, TruffleString value, @Bind PythonLanguage language, @Cached @Cached.Shared TypeNodes.GetInstanceShape getInstanceShape) {
            return PFactory.createStringReverseIterator(language, cls, getInstanceShape.execute(cls), value);
        }

        @Specialization(guards={"!isString(sequence)", "!isPRange(sequence)"})
        static Object reversed(VirtualFrame frame, Object cls, Object sequence, @Bind Node inliningTarget, @Cached GetClassNode getClassNode, @Cached(value="create(T___REVERSED__)") LookupSpecialMethodNode lookupReversed, @Cached CallUnaryMethodNode callReversed, @Cached PySequenceSizeNode pySequenceSizeNode, @Cached InlinedConditionProfile noReversedProfile, @Cached PySequenceCheckNode pySequenceCheck, @Bind PythonLanguage language, @Cached @Cached.Shared TypeNodes.GetInstanceShape getInstanceShape, @Cached PRaiseNode raiseNode) {
            Object sequenceKlass = getClassNode.execute(inliningTarget, sequence);
            Object reversed = lookupReversed.execute((Frame)frame, sequenceKlass, sequence);
            if (noReversedProfile.profile(inliningTarget, reversed == PNone.NO_VALUE)) {
                if (!pySequenceCheck.execute(inliningTarget, sequence)) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.OBJ_ISNT_REVERSIBLE, sequence);
                }
                int lengthHint = pySequenceSizeNode.execute((Frame)frame, inliningTarget, sequence);
                return PFactory.createSequenceReverseIterator(language, cls, getInstanceShape.execute(cls), sequence, lengthHint);
            }
            return callReversed.executeObject((Frame)frame, reversed, sequence);
        }
    }
}

