/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.queue;

import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.Shape;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public final class PSimpleQueue
extends PythonBuiltinObject {
    private final LinkedBlockingQueue<Object> data = PSimpleQueue.createQueue();

    public PSimpleQueue(Object cls, Shape instanceShape) {
        super(cls, instanceShape);
    }

    @CompilerDirectives.TruffleBoundary
    private static LinkedBlockingQueue<Object> createQueue() {
        return new LinkedBlockingQueue<Object>();
    }

    @CompilerDirectives.TruffleBoundary
    int getQueueSize() {
        return this.data.size();
    }

    @CompilerDirectives.TruffleBoundary
    Object get() throws InterruptedException {
        return this.data.take();
    }

    @CompilerDirectives.TruffleBoundary
    Object get(long microSeconds) throws InterruptedException {
        return this.data.poll(microSeconds, TimeUnit.MICROSECONDS);
    }

    @CompilerDirectives.TruffleBoundary
    Object poll() {
        return this.data.poll();
    }

    @CompilerDirectives.TruffleBoundary
    boolean put(Object value) {
        return this.data.offer(value);
    }
}

