/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.modules.ItertoolsModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.itertools.PTeeDataObject;
import com.oracle.graal.python.builtins.objects.itertools.TeeDataObjectBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.itertools.TeeDataObjectBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.itertools.TeeDataObjectBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PTeeDataObject})
public final class TeeDataObjectBuiltins
extends PythonBuiltins {
    static final int LINKCELLS = 128;
    public static final TpSlots SLOTS = TeeDataObjectBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return TeeDataObjectBuiltinsFactory.getFactories();
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        abstract Object execute(VirtualFrame var1, PythonObject var2);

        @Specialization
        static Object reduce(PTeeDataObject self, @Bind Node inliningTarget, @Cached GetClassNode getClass, @Bind PythonLanguage language) {
            ItertoolsModuleBuiltins.warnPickleDeprecated();
            int numread = self.getNumread();
            Object[] values = new Object[numread];
            PythonUtils.arraycopy(self.getValues(), 0, values, 0, numread);
            Object type = getClass.execute(inliningTarget, self);
            PTeeDataObject nextlink = self.getNextlink();
            PTuple tuple = PFactory.createTuple(language, new Object[]{self.getIt(), PFactory.createList(language, values), nextlink == null ? PNone.NONE : nextlink});
            return PFactory.createTuple(language, new Object[]{type, tuple});
        }
    }

    @Slot(value=Slot.SlotKind.tp_init, isComplex=true)
    @Slot.SlotSignature(name="TeeDataObject", minNumOfPositionalArgs=1, parameterNames={"$self", "it", "values", "nxt"})
    @ArgumentsClinic(value={@ArgumentClinic(name="values", defaultValue="PNone.NONE", useDefaultForNone=true), @ArgumentClinic(name="nxt", defaultValue="PNone.NONE", useDefaultForNone=true)})
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonQuaternaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return TeeDataObjectBuiltinsClinicProviders.InitNodeClinicProviderGen.INSTANCE;
        }

        abstract Object execute(VirtualFrame var1, PTeeDataObject var2, Object var3, Object var4, Object var5);

        @Specialization(guards={"isNone(values)"})
        static Object init(PTeeDataObject self, Object it, Object values, PNone nxt) {
            InitNode.init(self, it, null);
            return PNone.NONE;
        }

        @Specialization(guards={"isNone(values)"})
        static Object init(PTeeDataObject self, Object it, Object values, PTeeDataObject nxt) {
            InitNode.init(self, it, nxt);
            return PNone.NONE;
        }

        private static void init(PTeeDataObject self, Object it, PTeeDataObject nxt) {
            self.setIt(it);
            self.setValues(new Object[128]);
            self.setNumread(0);
            self.setRunning(false);
            self.setNextlink(nxt);
        }

        @Specialization
        static Object init(VirtualFrame frame, PTeeDataObject self, Object it, PList values, Object nxt, @Bind Node inliningTarget, @Cached BuiltinFunctions.LenNode lenNode, @Cached SequenceStorageNodes.GetInternalObjectArrayNode getInternalObjectArrayNode, @Cached InlinedBranchProfile numreadLCProfile, @Cached PRaiseNode raiseNode) {
            int numread = (Integer)lenNode.execute(frame, values);
            if (numread == 128) {
                numreadLCProfile.enter(inliningTarget);
                if (!(nxt instanceof PTeeDataObject)) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.S_MUST_BE_S, "_tee_dataobject next link", "_tee_dataobject");
                }
            } else {
                if (numread > 128) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.TDATAOBJECT_SHOULD_NOT_HAVE_MORE_LINKS, 128);
                }
                if (!(nxt instanceof PNone)) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.TDATAOBJECT_SHOULDNT_HAVE_NEXT);
                }
            }
            self.setIt(it);
            Object[] valuesArray = getInternalObjectArrayNode.execute(inliningTarget, values.getSequenceStorage());
            Object[] obj = new Object[128];
            PythonUtils.arraycopy(valuesArray, 0, obj, 0, numread);
            self.setValues(obj);
            self.setNumread(numread);
            self.setRunning(false);
            self.setNextlink(nxt == PNone.NONE ? null : (PTeeDataObject)nxt);
            return PNone.NONE;
        }

        @Specialization(guards={"!isList(values)", "!isNone(values)"})
        static Object init(VirtualFrame frame, PTeeDataObject self, Object it, Object values, Object nxt, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.ARG_D_MUST_BE_S_NOT_P, "teedataobject()", 2, "list", values);
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="_tee_dataobject", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class TeeDataObjectNode
    extends PythonVarargsBuiltinNode {
        @Specialization
        PTeeDataObject construct(Object cls, Object[] arguments, PKeyword[] keywords, @Bind Node inliningTarget, @Cached TypeNodes.IsTypeNode isTypeNode, @Cached InlinedBranchProfile errorProfile, @Bind PythonLanguage language) {
            if (!isTypeNode.execute(inliningTarget, cls)) {
                errorProfile.enter(inliningTarget);
                throw PRaiseNode.raiseStatic(this, PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_TYPE_OBJ, "'cls'", cls);
            }
            return PFactory.createTeeDataObject(language);
        }
    }
}

