/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cjkcodecs;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteCodecObject;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteCodecUtil;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteEncodeBuffer;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteIncrementalEncoderBuiltins;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteStreamWriterBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteStreamWriterBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteStreamWriterObject;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.MultibyteStreamWriter})
public final class MultibyteStreamWriterBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = MultibyteStreamWriterBuiltinsSlotsGen.SLOTS;
    private static final TruffleString WRITE = PythonUtils.tsLiteral("write");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return MultibyteStreamWriterBuiltinsFactory.getFactories();
    }

    @Builtin(name="stream", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class StreamMemberNode
    extends PythonUnaryBuiltinNode {
        StreamMemberNode() {
        }

        @Specialization
        static Object stream(MultibyteStreamWriterObject self) {
            return self.stream;
        }
    }

    @Builtin(name="reset", minNumOfPositionalArgs=1, doc="reset($self, /)\n--\n\n")
    @GenerateNodeFactory
    static abstract class ResetNode
    extends PythonUnaryBuiltinNode {
        ResetNode() {
        }

        @Specialization
        static Object reset(VirtualFrame frame, MultibyteStreamWriterObject self, @Bind Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached MultibyteCodecUtil.EncodeNode encodeNode) {
            if (self.pending == null) {
                return PNone.NONE;
            }
            int datalen = codePointLengthNode.execute((AbstractTruffleString)self.pending, PythonUtils.TS_ENCODING);
            PBytes pwrt = MultibyteCodecUtil.encodeEmptyInput(inliningTarget, datalen, 3);
            if (pwrt == null) {
                MultibyteEncodeBuffer buf = new MultibyteEncodeBuffer(self.pending);
                pwrt = encodeNode.execute(frame, inliningTarget, self.codec, self.state, buf, self.errors, 3);
            }
            self.pending = null;
            if (pwrt.getSequenceStorage().length() > 0) {
                callMethod.execute((Frame)frame, inliningTarget, self.stream, WRITE, pwrt);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="writelines", minNumOfPositionalArgs=2, doc="writelines($self, lines, /)\n--\n\n")
    @GenerateNodeFactory
    static abstract class WritelinesNode
    extends PythonBinaryBuiltinNode {
        WritelinesNode() {
        }

        @Specialization
        static Object writelines(VirtualFrame frame, MultibyteStreamWriterObject self, PSequence lines, @Bind Node inliningTarget, @Cached MultibyteIncrementalEncoderBuiltins.EncodeStatefulNode encodeStatefulNode, @Cached SequenceNodes.GetSequenceStorageNode getStorage, @Cached SequenceStorageNodes.GetItemNode getItem, @Cached PyObjectCallMethodObjArgs callMethod) {
            SequenceStorage sq = getStorage.execute(inliningTarget, lines);
            for (int i = 0; i < sq.length(); ++i) {
                Object strobj = getItem.execute(sq, i);
                Object str = encodeStatefulNode.execute(frame, self, strobj, 0);
                callMethod.execute((Frame)frame, inliningTarget, self.stream, WRITE, str);
            }
            return PNone.NONE;
        }

        @Fallback
        static Object writelines(Object self, Object lines, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.ARG_MUST_BE_A_SEQUENCE_OBJECT);
        }
    }

    @Builtin(name="write", minNumOfPositionalArgs=2, doc="write($self, strobj, /)\n--\n\n")
    @GenerateNodeFactory
    static abstract class WriteNode
    extends PythonBinaryBuiltinNode {
        WriteNode() {
        }

        @Specialization
        static Object write(VirtualFrame frame, MultibyteStreamWriterObject self, Object strobj, @Bind Node inliningTarget, @Cached MultibyteIncrementalEncoderBuiltins.EncodeStatefulNode encodeStatefulNode, @Cached PyObjectCallMethodObjArgs callMethod) {
            Object str = encodeStatefulNode.execute(frame, self, strobj, 0);
            callMethod.execute((Frame)frame, inliningTarget, self.stream, WRITE, str);
            return PNone.NONE;
        }
    }

    @Slot(value=Slot.SlotKind.tp_init, isComplex=true)
    @Slot.SlotSignature(name="MultibyteStreamWriter", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PNone init(MultibyteStreamWriterObject self) {
            return PNone.NONE;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    protected static abstract class NewNode
    extends PythonBuiltinNode {
        protected NewNode() {
        }

        @Specialization
        static Object mbstreamwriterNew(VirtualFrame frame, Object type, Object stream, Object err, @Bind Node inliningTarget, @Cached CastToTruffleStringNode castToStringNode, @Cached PyObjectGetAttr getAttr, @Cached TruffleString.EqualNode isEqual, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape, @Cached PRaiseNode raiseNode) {
            TruffleString errors = null;
            if (err != PNone.NO_VALUE) {
                errors = castToStringNode.execute(inliningTarget, err);
            }
            MultibyteStreamWriterObject self = PFactory.createMultibyteStreamWriterObject(language, type, getInstanceShape.execute(type));
            Object codec = getAttr.execute((Frame)frame, inliningTarget, type, StringLiterals.T_CODEC);
            if (!(codec instanceof MultibyteCodecObject)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CODEC_IS_UNEXPECTED_TYPE);
            }
            self.codec = ((MultibyteCodecObject)codec).codec;
            self.stream = stream;
            self.pending = null;
            self.errors = MultibyteCodecUtil.internalErrorCallback(errors, isEqual);
            self.codec.encinit(self.errors);
            return self;
        }
    }
}

