/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ast;

import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ast.AstState;
import com.oracle.graal.python.builtins.modules.ast.AstTypeFactory;
import com.oracle.graal.python.builtins.modules.ast.Obj2Sst;
import com.oracle.graal.python.builtins.modules.ast.Obj2SstBase;
import com.oracle.graal.python.builtins.modules.ast.Sst2ObjVisitor;
import com.oracle.graal.python.builtins.modules.ast.Validator;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.pegparser.InputType;
import com.oracle.graal.python.pegparser.sst.ModTy;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Collections;
import java.util.List;

@CoreFunctions(defineModule="_ast", isEager=true)
public final class AstModuleBuiltins
extends PythonBuiltins {
    static final String J__AST = "_ast";
    static final TruffleString T__AST = PythonUtils.tsLiteral("_ast");
    static final TruffleString T_AST = PythonUtils.tsLiteral("ast");
    static final TruffleString T__FIELDS = PythonUtils.tsLiteral("_fields");
    static final TruffleString T__ATTRIBUTES = PythonUtils.tsLiteral("_attributes");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return Collections.emptyList();
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        this.addBuiltinConstant("PyCF_ONLY_AST", (Object)1024);
        this.addBuiltinConstant("PyCF_TYPE_COMMENTS", (Object)4096);
        this.addBuiltinConstant("PyCF_ALLOW_TOP_LEVEL_AWAIT", (Object)8192);
        PythonBuiltinClass clsAst = core.lookupType(PythonBuiltinClassType.AST);
        PTuple emptyTuple = PFactory.createEmptyTuple(core.getLanguage());
        clsAst.setAttribute(T__FIELDS, emptyTuple);
        clsAst.setAttribute(T__ATTRIBUTES, emptyTuple);
        clsAst.setAttribute(SpecialAttributeNames.T___MATCH_ARGS__, emptyTuple);
    }

    @Override
    public void postInitialize(Python3Core core) {
        super.postInitialize(core);
        PythonModule astModule = core.lookupBuiltinModule(T__AST);
        AstTypeFactory astTypeFactory = new AstTypeFactory(core.getLanguage(), astModule);
        AstState state = new AstState(astTypeFactory, core.lookupType(PythonBuiltinClassType.AST));
        astModule.setModuleState(state);
    }

    private static AstState getAstState(PythonContext context) {
        return context.lookupBuiltinModule(T__AST).getModuleState(AstState.class);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object sst2Obj(PythonContext context, ModTy mod) {
        return mod.accept(new Sst2ObjVisitor(AstModuleBuiltins.getAstState(context)));
    }

    @CompilerDirectives.TruffleBoundary
    public static ModTy obj2sst(Node node, PythonContext context, Object obj, InputType type) {
        AstState state = AstModuleBuiltins.getAstState(context);
        PythonClass expectedClass = switch (type) {
            case InputType.FILE -> state.clsModule;
            case InputType.EVAL -> state.clsExpression;
            case InputType.SINGLE -> state.clsInteractive;
            default -> throw CompilerDirectives.shouldNotReachHere();
        };
        if (!Obj2SstBase.isInstanceOf(obj, expectedClass)) {
            Object[] arguments = new Object[]{expectedClass.getName(), obj};
            throw PRaiseNode.raiseStatic(node, PythonBuiltinClassType.TypeError, ErrorMessages.EXPECTED_S_NODE_GOT_P, arguments);
        }
        ModTy mod = new Obj2Sst(node, state).obj2ModTy(obj);
        Validator.validateMod(node, mod);
        return mod;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isAst(PythonContext context, Object obj) {
        return Obj2SstBase.isInstanceOf(obj, context.lookupType(PythonBuiltinClassType.AST));
    }
}

