/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.util;

import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaLongLossyNodeGen;
import com.oracle.graal.python.nodes.util.CastToJavaLongNode;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
public abstract class CastToJavaLongLossyNode
extends CastToJavaLongNode {
    public static long executeUncached(Object x) throws CannotCastException {
        return CastToJavaLongLossyNodeGen.getUncached().execute(null, x);
    }

    @Specialization(rewriteOn={OverflowException.class})
    protected static long toLong(PInt x) throws OverflowException {
        return x.longValueExact();
    }

    @Specialization(replaces={"toLong"})
    protected static long toLongOverflow(PInt x) {
        if (x.compareTo(PInt.MAX_LONG) > 0) {
            return Long.MAX_VALUE;
        }
        if (x.compareTo(PInt.MIN_LONG) < 0) {
            return Long.MIN_VALUE;
        }
        return x.longValue();
    }
}

