/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.interop;

import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.interop.PForeignToPTypeNodeGen;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

@ImportStatic(value={PGuards.class})
@GenerateUncached
@GenerateInline(value=false)
public abstract class PForeignToPTypeNode
extends Node {
    public abstract Object executeConvert(Object var1);

    @Idempotent
    protected static boolean isOtherClass(Class<?> clazz) {
        return clazz != Byte.class && clazz != Short.class && clazz != Float.class && clazz != String.class && clazz != TruffleString.class && clazz != PException.class;
    }

    @Specialization(guards={"isOtherClass(cachedClass)", "value.getClass() == cachedClass"}, limit="1")
    protected static Object fromObjectCached(Object value, @Cached(value="value.getClass()") Class<?> cachedClass) {
        return value;
    }

    @Specialization(replaces={"fromObjectCached"}, guards={"isOtherClass(value.getClass())"})
    protected static Object fromObjectGeneric(Object value) {
        return value;
    }

    @Specialization
    protected static int fromByte(byte value) {
        return value;
    }

    @Specialization
    protected static int fromShort(short value) {
        return value;
    }

    @Specialization
    protected static double fromFloat(float value) {
        return value;
    }

    @Specialization
    protected static TruffleString fromString(String value, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
        return fromJavaStringNode.execute(value, PythonUtils.TS_ENCODING);
    }

    @Specialization
    protected static TruffleString fromTruffleString(TruffleString value, @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
        return switchEncodingNode.execute((AbstractTruffleString)value, PythonUtils.TS_ENCODING);
    }

    @Specialization
    protected static Object fromPException(PException pe) {
        return pe.getUnreifiedException();
    }

    @NeverDefault
    public static PForeignToPTypeNode create() {
        return PForeignToPTypeNodeGen.create();
    }

    public static PForeignToPTypeNode getUncached() {
        return PForeignToPTypeNodeGen.getUncached();
    }
}

