/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.itertools.BatchedBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.itertools.BatchedBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.itertools.BatchedBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.itertools.PBatched;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.lib.IteratorExhausted;
import com.oracle.graal.python.lib.PyIterNextNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PBatched})
public final class BatchedBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = BatchedBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return BatchedBuiltinsFactory.getFactories();
    }

    @Slot(value=Slot.SlotKind.tp_iternext, isComplex=true)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object next(VirtualFrame frame, PBatched bo, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached PyIterNextNode nextNode, @Cached PRaiseNode raiseNode) {
            if (bo.it == null) {
                throw raiseNode.raiseStopIteration(inliningTarget, null);
            }
            int n = bo.batchSize;
            Object it = bo.it;
            Object[] items = new Object[n];
            for (int i = 0; i < n; ++i) {
                try {
                    try {
                        items[i] = nextNode.execute((Frame)frame, inliningTarget, it);
                        continue;
                    }
                    catch (IteratorExhausted e) {
                        if (i == 0) {
                            bo.it = null;
                            return TpSlotIterNext.TpIterNextBuiltin.iteratorExhausted();
                        }
                        items = PythonUtils.arrayCopyOf(items, i);
                        break;
                    }
                }
                catch (PException e) {
                    bo.it = null;
                    throw e;
                }
            }
            return PFactory.createTuple(language, items);
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object iter(PBatched self) {
            return self;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="batched", minNumOfPositionalArgs=2, parameterNames={"cls", "iterable", "n"})
    @ArgumentClinic(name="n", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    public static abstract class BatchedNode
    extends PythonTernaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BatchedBuiltinsClinicProviders.BatchedNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PBatched batched(VirtualFrame frame, Object cls, Object iterable, int n, @Bind Node inliningTarget, @Cached PyObjectGetIter getIter, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape, @Cached PRaiseNode raiseNode) {
            if (n < 1) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.N_MUST_BE_AT_LEAST_ONE);
            }
            Object it = getIter.execute((Frame)frame, inliningTarget, iterable);
            PBatched bo = PFactory.createBatched(language, cls, getInstanceShape.execute(cls));
            bo.setBatchSize(n);
            bo.setIter(it);
            return bo;
        }
    }
}

