/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.ds.common;

import com.amazon.redshift.ds.RedshiftConnectionPoolDataSource;
import com.amazon.redshift.ds.RedshiftPoolingDataSource;
import com.amazon.redshift.ds.RedshiftSimpleDataSource;
import com.amazon.redshift.ds.common.BaseDataSource;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class RedshiftObjectFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference ref = (Reference)obj;
        String className = ref.getClassName();
        if (className.equals("com.amazon.redshift.ds.RedddddddshiftSimpleDataSource") || className.equals("com.amazon.redshift.jdbc2.optional.SimpleDataSource") || className.equals("com.amazon.redshift.jdbc3.Jdbc3SimpleDataSource")) {
            return this.loadSimpleDataSource(ref);
        }
        if (className.equals("com.amazon.redshift.ds.RedshiftConnectionPoolDataSource") || className.equals("com.amazon.redshift.jdbc2.optional.ConnectionPool") || className.equals("com.amazon.redshift.jdbc3.Jdbc3ConnectionPool")) {
            return this.loadConnectionPool(ref);
        }
        if (className.equals("com.amazon.redshift.ds.RedshiftPoolingDataSource") || className.equals("com.amazon.redshift.jdbc2.optional.PoolingDataSource") || className.equals("com.amazon.redshift.jdbc3.Jdbc3PoolingDataSource")) {
            return this.loadPoolingDataSource(ref);
        }
        return null;
    }

    private Object loadPoolingDataSource(Reference ref) {
        String max;
        String name = this.getProperty(ref, "dataSourceName");
        RedshiftPoolingDataSource pds = RedshiftPoolingDataSource.getDataSource(name);
        if (pds != null) {
            return pds;
        }
        pds = new RedshiftPoolingDataSource();
        pds.setDataSourceName(name);
        this.loadBaseDataSource(pds, ref);
        String min = this.getProperty(ref, "initialConnections");
        if (min != null) {
            pds.setInitialConnections(Integer.parseInt(min));
        }
        if ((max = this.getProperty(ref, "maxConnections")) != null) {
            pds.setMaxConnections(Integer.parseInt(max));
        }
        return pds;
    }

    private Object loadSimpleDataSource(Reference ref) {
        RedshiftSimpleDataSource ds = new RedshiftSimpleDataSource();
        return this.loadBaseDataSource(ds, ref);
    }

    private Object loadConnectionPool(Reference ref) {
        RedshiftConnectionPoolDataSource cp = new RedshiftConnectionPoolDataSource();
        return this.loadBaseDataSource(cp, ref);
    }

    protected Object loadBaseDataSource(BaseDataSource ds, Reference ref) {
        ds.setFromReference(ref);
        return ds;
    }

    protected String getProperty(Reference ref, String s) {
        RefAddr addr = ref.get(s);
        if (addr == null) {
            return null;
        }
        return (String)addr.getContent();
    }
}

