/**
 * Copyright (c) 2011-2013 by Andrew Mustun. All rights reserved.
 * 
 * This file is part of the QCAD project.
 *
 * QCAD is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QCAD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QCAD.
 */
// Auto generated by Testing Dashboard
// File        : scripts/Draw/Line/LineAngle/Tests/LineAngle02.js
// Timestamp   : 2011-02-09 15:41:24
// Description : same length, same angle, different reference points, input mouse clicks

include('scripts/Developer/TestingDashboard/TdbTest.js');

function LineAngle02() {
    TdbTest.call(this, 'scripts/Draw/Line/LineAngle/Tests/LineAngle02.js');
}

LineAngle02.prototype = new TdbTest();

LineAngle02.prototype.test00 = function() {
    qDebug('running LineAngle02.test00()...');
    this.setUp();
    this.clickOnWidget('MainWindow::MainToolsPanel::LineToolsPanelButton');
    this.clickOnWidget('MainWindow::LineToolsPanel::LineAngleButton');
    this.setToolOption('LineAngle/Angle',  [ 33, 0 ] );
    this.setToolOption('LineAngle/Length',  [ 15, 0 ] );
    this.setToolOption('LineAngle/ReferencePoint', '0');
    this.updateToolOptions();
    this.zoomTo(-28.95, -21.449999999999996, 28.950000000000003, 21.450000000000006);
    var p = new RVector(0, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.setToolOption('LineAngle/Angle',  [ 33, 0 ] );
    this.setToolOption('LineAngle/Length',  [ 15, 0 ] );
    this.setToolOption('LineAngle/ReferencePoint', '1');
    this.updateToolOptions();
    this.zoomTo(-28.95, -21.449999999999996, 28.950000000000003, 21.450000000000006);
    var p = new RVector(0, 2);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.setToolOption('LineAngle/Angle',  [ 33, 0 ] );
    this.setToolOption('LineAngle/Length',  [ 15, 0 ] );
    this.setToolOption('LineAngle/ReferencePoint', '2');
    this.updateToolOptions();
    this.zoomTo(-28.95, -21.449999999999996, 28.950000000000003, 21.450000000000006);
    var p = new RVector(0, 4);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.sendMouseEventToGv(QEvent.MouseButtonPress, new QPoint(367, 245), Qt.RightButton, 2, 0);
    this.sendMouseEventToGv(QEvent.MouseButtonRelease, new QPoint(367, 245), Qt.RightButton, 0, 0);
    this.verifyDrawing('LineAngle02_000.dxf');
    this.tearDown();
    qDebug('finished LineAngle02.test00()');
};

