Wikimedia API Parameter Validator
=================================

This library implements a system for processing and validating parameters to an
API from data like that in PHP's `$_GET`, `$_POST`, and `$_FILES` arrays, based
on a declarative definition of available parameters.

Usage
-----

<pre lang="php">
use Wikimedia\ParamValidator\ParamValidator;
use Wikimedia\ParamValidator\TypeDef\IntegerDef;
use Wikimedia\ParamValidator\SimpleCallbacks as ParamValidatorCallbacks;
use Wikimedia\ParamValidator\ValidationException;

// We assume these are available from your environment in some manner.
/** @var Wikimedia\ObjectFactory\ObjectFactory $objectFactory */
$objectFactory = ...;
/** @var Wikimedia\Message\MessageFormatterFactory $messageFormatterFactory */
$messageFormatterFactory = ...;

$validator = new ParamValidator(
	new ParamValidatorCallbacks( $_POST + $_GET, $_FILES ),
	$objectFactory
);

try {
	$intValue = $validator->getValue( 'intParam', [
			ParamValidator::PARAM_TYPE => 'integer',
			ParamValidator::PARAM_DEFAULT => 0,
			IntegerDef::PARAM_MIN => 0,
			IntegerDef::PARAM_MAX => 5,
	] );
} catch ( ValidationException $ex ) {
	$error = $messageFormatterFactory->getTextFormatter( 'en' )->format( $ex->getFailureMessage() );
	echo "Validation error: $error\n";
}
</pre>

Failure reporting
-----------------

This library uses Wikimedia\Message\DataMessageValue objects to report errors
in both human-readable and machine-readable formats. Basic i18n for all errors
generated by the library is included.

For possible failure codes and their parameters, see the documentation of the
relevant `PARAM_*` constants and TypeDef classes.

Running tests
-------------

    composer install --prefer-dist
    composer test
