/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import mediathek.tool.ApplicationConfiguration;

public class DaysSpinner
extends JSpinner {
    private static final String ALLE = " Alle ";

    public DaysSpinner() {
        SpinnerListModel daySpinnerModel = new SpinnerListModel(new Object[]{ALLE, "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "12", "14", "16", "18", "20", "25", "30", "60", "90", "180", "365"});
        this.setModel(daySpinnerModel);
        ((JSpinner.DefaultEditor)this.getEditor()).getTextField().setEditable(false);
        this.addChangeListener(l -> {
            int num_days;
            String s = this.getModel().getValue().toString();
            if (s.equals(ALLE)) {
                s = "0";
            }
            try {
                num_days = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                num_days = 0;
            }
            ApplicationConfiguration.getConfiguration().setProperty("filmlist.load.days", (Object)num_days);
        });
        this.loadConfigValues();
    }

    private void loadConfigValues() {
        int num_days = ApplicationConfiguration.getConfiguration().getInt("filmlist.load.days", 0);
        String s = num_days == 0 ? ALLE : Integer.toString(num_days);
        this.setValue(s);
    }
}

