/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.Objects;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmDurationUnit;
import org.hibernate.query.sqm.tree.expression.SqmExpression;

public class SqmByUnit
extends AbstractSqmExpression<Long> {
    private final SqmDurationUnit<?> unit;
    private final SqmExpression<?> duration;

    public SqmByUnit(SqmDurationUnit<?> unit, SqmExpression<?> duration, SqmBindableType<Long> longType, NodeBuilder nodeBuilder) {
        super(longType, nodeBuilder);
        this.unit = unit;
        this.duration = duration;
    }

    @Override
    public SqmByUnit copy(SqmCopyContext context) {
        SqmByUnit existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmByUnit expression = context.registerCopy(this, new SqmByUnit((SqmDurationUnit<?>)this.unit.copy(context), (SqmExpression<?>)this.duration.copy(context), this.getNodeType(), this.nodeBuilder()));
        this.copyTo(expression, context);
        return expression;
    }

    public SqmDurationUnit<?> getUnit() {
        return this.unit;
    }

    public SqmExpression<?> getDuration() {
        return this.duration;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitByUnit(this);
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        this.duration.appendHqlString(hql, context);
        hql.append(" by ");
        hql.append((Object)this.unit.getUnit());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof SqmByUnit)) return false;
        SqmByUnit that = (SqmByUnit)object;
        if (!Objects.equals(this.unit, that.unit)) return false;
        if (!Objects.equals(this.duration, that.duration)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.unit, this.duration);
    }
}

