/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import java.util.function.Supplier;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.metamodel.internal.EmbeddableCompositeUserTypeInstantiator;
import org.hibernate.metamodel.internal.EmbeddableInstantiatorPojoIndirecting;
import org.hibernate.metamodel.internal.EmbeddableInstantiatorRecordIndirecting;
import org.hibernate.metamodel.internal.EmbeddableInstantiatorRecordStandard;
import org.hibernate.metamodel.internal.EmbeddableRepresentationStrategyMap;
import org.hibernate.metamodel.internal.EmbeddableRepresentationStrategyPojo;
import org.hibernate.metamodel.internal.EntityRepresentationStrategyMap;
import org.hibernate.metamodel.internal.EntityRepresentationStrategyPojoStandard;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.spi.EmbeddableInstantiator;
import org.hibernate.metamodel.spi.EmbeddableRepresentationStrategy;
import org.hibernate.metamodel.spi.EntityRepresentationStrategy;
import org.hibernate.metamodel.spi.ManagedTypeRepresentationResolver;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.resource.beans.internal.FallbackBeanInstanceProducer;
import org.hibernate.usertype.CompositeUserType;

public class ManagedTypeRepresentationResolverStandard
implements ManagedTypeRepresentationResolver {
    public static final ManagedTypeRepresentationResolverStandard INSTANCE = new ManagedTypeRepresentationResolverStandard();

    @Override
    public EntityRepresentationStrategy resolveStrategy(PersistentClass bootDescriptor, EntityPersister runtimeDescriptor, RuntimeModelCreationContext creationContext) {
        if (bootDescriptor.getMappedClass() == null) {
            return new EntityRepresentationStrategyMap(bootDescriptor, creationContext);
        }
        return new EntityRepresentationStrategyPojoStandard(bootDescriptor, runtimeDescriptor, creationContext);
    }

    @Override
    public EmbeddableRepresentationStrategy resolveStrategy(Component bootDescriptor, Supplier<EmbeddableMappingType> runtimeDescriptorAccess, RuntimeModelCreationContext creationContext) {
        CompositeUserType<Object> compositeUserType = ManagedTypeRepresentationResolverStandard.getCompositeUserType(bootDescriptor, creationContext);
        EmbeddableInstantiator customInstantiator = ManagedTypeRepresentationResolverStandard.getCustomInstantiator(bootDescriptor, creationContext, compositeUserType);
        if (bootDescriptor.getComponentClassName() == null) {
            return new EmbeddableRepresentationStrategyMap(bootDescriptor, runtimeDescriptorAccess, customInstantiator, creationContext);
        }
        return new EmbeddableRepresentationStrategyPojo(bootDescriptor, runtimeDescriptorAccess, customInstantiator, compositeUserType, creationContext);
    }

    private static CompositeUserType<?> getCompositeUserType(Component bootDescriptor, RuntimeModelCreationContext creationContext) {
        if (bootDescriptor.getTypeName() != null) {
            return (CompositeUserType)ManagedTypeRepresentationResolverStandard.beanInstance(creationContext, creationContext.getBootstrapContext().getClassLoaderAccess().classForName(bootDescriptor.getTypeName()));
        }
        return null;
    }

    private static EmbeddableInstantiator getCustomInstantiator(Component bootDescriptor, RuntimeModelCreationContext creationContext, CompositeUserType<?> compositeUserType) {
        if (bootDescriptor.getCustomInstantiator() != null) {
            return ManagedTypeRepresentationResolverStandard.beanInstance(creationContext, bootDescriptor.getCustomInstantiator());
        }
        if (compositeUserType != null) {
            return new EmbeddableCompositeUserTypeInstantiator(compositeUserType);
        }
        if (bootDescriptor.getComponentClassName() != null && ReflectHelper.isRecord(bootDescriptor.getComponentClass())) {
            if (bootDescriptor.sortProperties() == null) {
                return new EmbeddableInstantiatorRecordStandard(bootDescriptor.getComponentClass());
            }
            return EmbeddableInstantiatorRecordIndirecting.of(bootDescriptor.getComponentClass(), bootDescriptor.getPropertyNames());
        }
        if (bootDescriptor.getInstantiator() != null) {
            bootDescriptor.sortProperties();
            return EmbeddableInstantiatorPojoIndirecting.of(bootDescriptor.getPropertyNames(), bootDescriptor.getInstantiator(), bootDescriptor.getInstantiatorPropertyNames());
        }
        return null;
    }

    private static <T> T beanInstance(RuntimeModelCreationContext creationContext, Class<T> userTypeClass) {
        return creationContext.getBootModel().getMetadataBuildingOptions().isAllowExtensionsInCdi() ? ManagedTypeRepresentationResolverStandard.getBeanInstance(creationContext, userTypeClass) : FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(userTypeClass);
    }

    private static <T> T getBeanInstance(RuntimeModelCreationContext creationContext, Class<T> userTypeClass) {
        return creationContext.getBootstrapContext().getManagedBeanRegistry().getBean(userTypeClass).getBeanInstance();
    }
}

