/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.FindOption;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.LockOption;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.PessimisticLockScope;
import jakarta.persistence.RefreshOption;
import jakarta.persistence.Timeout;
import jakarta.persistence.TransactionRequiredException;
import jakarta.persistence.criteria.CriteriaSelect;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.Metamodel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.UnaryOperator;
import org.hibernate.BatchSize;
import org.hibernate.CacheMode;
import org.hibernate.ConnectionAcquisitionMode;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.EnabledFetchProfile;
import org.hibernate.EntityFilterException;
import org.hibernate.FetchNotFoundException;
import org.hibernate.FlushMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.IdentifierLoadAccess;
import org.hibernate.Interceptor;
import org.hibernate.JDBCException;
import org.hibernate.LobHelper;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Locking;
import org.hibernate.MappingException;
import org.hibernate.MultiIdentifierLoadAccess;
import org.hibernate.NaturalIdLoadAccess;
import org.hibernate.NaturalIdMultiLoadAccess;
import org.hibernate.ObjectDeletedException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.ReadOnlyMode;
import org.hibernate.ReplicationMode;
import org.hibernate.SessionBuilder;
import org.hibernate.SessionEventListener;
import org.hibernate.SessionException;
import org.hibernate.SharedSessionBuilder;
import org.hibernate.SimpleNaturalIdLoadAccess;
import org.hibernate.Timeouts;
import org.hibernate.Transaction;
import org.hibernate.TypeMismatchException;
import org.hibernate.UnknownEntityTypeException;
import org.hibernate.UnknownProfileException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.action.spi.AfterTransactionCompletionProcess;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.internal.PersistenceContexts;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.spi.ActionQueue;
import org.hibernate.engine.spi.EffectiveEntityGraph;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.monitor.spi.DiagnosticEvent;
import org.hibernate.event.monitor.spi.EventMonitor;
import org.hibernate.event.service.spi.EventListenerGroups;
import org.hibernate.event.spi.AutoFlushEvent;
import org.hibernate.event.spi.AutoFlushEventListener;
import org.hibernate.event.spi.ClearEvent;
import org.hibernate.event.spi.ClearEventListener;
import org.hibernate.event.spi.DeleteContext;
import org.hibernate.event.spi.DeleteEvent;
import org.hibernate.event.spi.DeleteEventListener;
import org.hibernate.event.spi.DirtyCheckEvent;
import org.hibernate.event.spi.DirtyCheckEventListener;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.EvictEvent;
import org.hibernate.event.spi.EvictEventListener;
import org.hibernate.event.spi.FlushEvent;
import org.hibernate.event.spi.FlushEventListener;
import org.hibernate.event.spi.InitializeCollectionEvent;
import org.hibernate.event.spi.InitializeCollectionEventListener;
import org.hibernate.event.spi.LoadEvent;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.event.spi.LockEvent;
import org.hibernate.event.spi.LockEventListener;
import org.hibernate.event.spi.MergeContext;
import org.hibernate.event.spi.MergeEvent;
import org.hibernate.event.spi.MergeEventListener;
import org.hibernate.event.spi.PersistContext;
import org.hibernate.event.spi.PersistEvent;
import org.hibernate.event.spi.PersistEventListener;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.event.spi.RefreshContext;
import org.hibernate.event.spi.RefreshEvent;
import org.hibernate.event.spi.RefreshEventListener;
import org.hibernate.event.spi.ReplicateEvent;
import org.hibernate.event.spi.ReplicateEventListener;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.internal.AbstractSharedSessionContract;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.ExceptionMapperStandardImpl;
import org.hibernate.internal.FilterImpl;
import org.hibernate.internal.LockOptionsHelper;
import org.hibernate.internal.MultiIdentifierLoadAccessImpl;
import org.hibernate.internal.NaturalIdMultiLoadAccessStandard;
import org.hibernate.internal.SessionCreationOptions;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.internal.SharedSessionCreationOptions;
import org.hibernate.internal.util.ExceptionHelper;
import org.hibernate.jpa.internal.LegacySpecHelper;
import org.hibernate.jpa.internal.util.CacheModeHelper;
import org.hibernate.jpa.internal.util.ConfigurationHelper;
import org.hibernate.jpa.internal.util.FlushModeTypeHelper;
import org.hibernate.jpa.internal.util.LockModeTypeHelper;
import org.hibernate.loader.internal.CacheLoadHelper;
import org.hibernate.loader.internal.IdentifierLoadAccessImpl;
import org.hibernate.loader.internal.LoadAccessContext;
import org.hibernate.loader.internal.NaturalIdLoadAccessImpl;
import org.hibernate.loader.internal.SimpleNaturalIdLoadAccessImpl;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.procedure.ProcedureCall;
import org.hibernate.procedure.spi.NamedCallableQueryMemento;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.query.Query;
import org.hibernate.query.SelectionQuery;
import org.hibernate.query.UnknownSqlResultSetMappingException;
import org.hibernate.query.criteria.CriteriaDefinition;
import org.hibernate.query.criteria.JpaQueryStructure;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.query.sqm.tree.select.SqmQueryGroup;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.resource.jdbc.spi.JdbcSessionOwner;
import org.hibernate.resource.jdbc.spi.PhysicalConnectionHandlingMode;
import org.hibernate.resource.jdbc.spi.StatementInspector;
import org.hibernate.resource.transaction.spi.TransactionCoordinator;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;
import org.hibernate.resource.transaction.spi.TransactionObserver;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.hibernate.stat.SessionStatistics;
import org.hibernate.stat.internal.SessionStatisticsImpl;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.descriptor.WrapperOptions;

public class SessionImpl
extends AbstractSharedSessionContract
implements Serializable,
SharedSessionContractImplementor,
JdbcSessionOwner,
SessionImplementor,
EventSource,
TransactionCoordinatorBuilder.Options,
WrapperOptions,
LoadAccessContext {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(SessionImpl.class);
    private Map<String, Object> properties;
    private transient ActionQueue actionQueue;
    private transient EventListenerGroups eventListenerGroups;
    private transient PersistenceContext persistenceContext;
    private transient LoadQueryInfluencers loadQueryInfluencers;
    private LockOptions lockOptions;
    private FlushMode flushMode;
    private final boolean autoClear;
    private final boolean autoClose;
    private final boolean identifierRollbackEnabled;
    private transient LoadEvent loadEvent;
    private transient PostLoadEvent postLoadEvent;
    private transient TransactionObserver transactionObserver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionImpl(SessionFactoryImpl factory, SessionCreationOptions options) {
        super(factory, options);
        DiagnosticEvent sessionOpenEvent = this.getEventMonitor().beginSessionOpenEvent();
        try {
            this.persistenceContext = this.createPersistenceContext();
            this.actionQueue = this.createActionQueue();
            this.eventListenerGroups = factory.getEventListenerGroups();
            this.flushMode = options.getInitialSessionFlushMode();
            this.autoClear = options.shouldAutoClear();
            this.autoClose = options.shouldAutoClose();
            this.identifierRollbackEnabled = options.isIdentifierRollbackEnabled();
            this.setUpTransactionCompletionProcesses(options);
            this.loadQueryInfluencers = new LoadQueryInfluencers(factory, options);
            if (this.properties != null) {
                LockOptionsHelper.applyPropertiesToLockOptions(this.properties, this::getLockOptionsForWrite);
            }
            this.getTransactionCoordinator().pulse();
            if (this.getHibernateFlushMode() == null) {
                this.setHibernateFlushMode(this.getInitialFlushMode());
            }
            this.setUpMultitenancy(factory, this.loadQueryInfluencers);
            StatisticsImplementor statistics = factory.getStatistics();
            if (statistics.isStatisticsEnabled()) {
                statistics.openSession();
            }
            if (log.isTraceEnabled()) {
                log.tracef("Opened Session [%s] at timestamp: %s", this.getSessionIdentifier(), System.currentTimeMillis());
            }
        }
        finally {
            this.getEventMonitor().completeSessionOpenEvent(sessionOpenEvent, this);
        }
    }

    private void setUpTransactionCompletionProcesses(SessionCreationOptions options) {
        ActionQueue.TransactionCompletionProcesses processes;
        SharedSessionCreationOptions sharedOptions;
        if (options instanceof SharedSessionCreationOptions && (sharedOptions = (SharedSessionCreationOptions)options).isTransactionCoordinatorShared() && (processes = sharedOptions.getTransactionCompletionProcesses()) != null) {
            this.actionQueue.setTransactionCompletionProcesses(processes, true);
        }
    }

    private FlushMode getInitialFlushMode() {
        return this.properties == null ? this.getSessionFactoryOptions().getInitialSessionFlushMode() : ConfigurationHelper.getFlushMode(this.getSessionProperty("org.hibernate.flushMode"), FlushMode.AUTO);
    }

    protected PersistenceContext createPersistenceContext() {
        return PersistenceContexts.createPersistenceContext(this);
    }

    protected ActionQueue createActionQueue() {
        return new ActionQueue(this);
    }

    private LockOptions getLockOptionsForRead() {
        return this.lockOptions == null ? this.getSessionFactoryOptions().getDefaultLockOptions() : this.lockOptions;
    }

    private LockOptions getLockOptionsForWrite() {
        if (this.lockOptions == null) {
            this.lockOptions = new LockOptions();
        }
        return this.lockOptions;
    }

    @Override
    protected void applyQuerySettingsAndHints(SelectionQuery<?> query) {
        this.applyLockOptionsHint(query);
    }

    protected void applyLockOptionsHint(SelectionQuery<?> query) {
        Object specQueryTimeout;
        LockOptions lockOptionsForRead = this.getLockOptionsForRead();
        if (lockOptionsForRead.getLockMode() != LockMode.NONE) {
            query.setLockMode(this.getLockMode((Object)lockOptionsForRead.getLockMode()));
        }
        if ((specQueryTimeout = this.getHintedQueryTimeout()) != null) {
            query.setHint("jakarta.persistence.query.timeout", specQueryTimeout);
        }
    }

    private Object getHintedQueryTimeout() {
        return LegacySpecHelper.getInteger("jakarta.persistence.query.timeout", "javax.persistence.query.timeout", this::getSessionProperty);
    }

    @Override
    protected void applyQuerySettingsAndHints(Query<?> query) {
        this.applyQuerySettingsAndHints((SelectionQuery<?>)query);
        this.applyLockTimeoutHint(query);
    }

    private void applyLockTimeoutHint(Query<?> query) {
        Integer specLockTimeout = this.getHintedLockTimeout();
        if (specLockTimeout != null) {
            query.setHint("jakarta.persistence.lock.timeout", specLockTimeout);
        }
    }

    private Integer getHintedLockTimeout() {
        return LegacySpecHelper.getInteger("jakarta.persistence.lock.timeout", "javax.persistence.lock.timeout", this::getSessionProperty, value -> !Integer.valueOf(-1).equals(value));
    }

    private Object getSessionProperty(String propertyName) {
        return this.properties == null ? this.getDefaultProperties().get(propertyName) : this.properties.get(propertyName);
    }

    private Map<String, Object> getDefaultProperties() {
        return this.getSessionFactoryOptions().getDefaultSessionProperties();
    }

    @Override
    public SharedSessionBuilder sessionWithOptions() {
        return new SharedSessionBuilderImpl(this);
    }

    @Override
    public void clear() {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        try {
            this.internalClear();
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    private void internalClear() {
        this.persistenceContext.clear();
        this.actionQueue.clear();
        this.eventListenerGroups.eventListenerGroup_CLEAR.fireLazyEventOnEachListener(this::createClearEvent, ClearEventListener::onClear);
    }

    private ClearEvent createClearEvent() {
        return new ClearEvent(this);
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            if (this.getSessionFactoryOptions().getJpaCompliance().isJpaClosedComplianceEnabled()) {
                throw new IllegalStateException("EntityManager was already closed");
            }
            log.trace("Already closed");
        } else {
            this.closeWithoutOpenChecks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeWithoutOpenChecks() {
        if (log.isTraceEnabled()) {
            log.tracef("Closing session [%s]", this.getSessionIdentifier());
        }
        EventMonitor eventMonitor = this.getEventMonitor();
        DiagnosticEvent sessionClosedEvent = eventMonitor.beginSessionClosedEvent();
        try {
            if (this.isJpaBootstrap()) {
                this.checkSessionFactoryOpen();
                this.checkOpenOrWaitingForAutoClose();
                if (this.getSessionFactoryOptions().isReleaseResourcesOnCloseEnabled() || !this.isTransactionInProgressAndNotMarkedForRollback()) {
                    super.close();
                } else {
                    this.prepareForAutoClose();
                }
            } else {
                super.close();
            }
        }
        finally {
            StatisticsImplementor statistics = this.getSessionFactory().getStatistics();
            if (statistics.isStatisticsEnabled()) {
                statistics.closeSession();
            }
            eventMonitor.completeSessionClosedEvent(sessionClosedEvent, this);
        }
    }

    private boolean isJpaBootstrap() {
        return this.getSessionFactoryOptions().isJpaBootstrap();
    }

    private boolean isTransactionInProgressAndNotMarkedForRollback() {
        return this.isOpenOrWaitingForAutoClose() && this.isTransactionActiveAndNotMarkedForRollback();
    }

    private boolean isTransactionActiveAndNotMarkedForRollback() {
        TransactionCoordinator transactionCoordinator = this.getTransactionCoordinator();
        return transactionCoordinator.isJoined() && transactionCoordinator.getTransactionDriverControl().isActiveAndNoMarkedForRollback();
    }

    @Override
    protected boolean shouldCloseJdbcCoordinatorOnClose(boolean isTransactionCoordinatorShared) {
        ActionQueue actionQueue;
        if (isTransactionCoordinatorShared && ((actionQueue = this.getActionQueue()).hasBeforeTransactionActions() || actionQueue.hasAfterTransactionActions())) {
            log.warn("Closing shared session with unprocessed transaction completion actions");
        }
        return !isTransactionCoordinatorShared;
    }

    public boolean isAutoCloseSessionEnabled() {
        return this.autoClose;
    }

    @Override
    public boolean isIdentifierRollbackEnabled() {
        return this.identifierRollbackEnabled;
    }

    @Override
    public boolean isOpen() {
        this.checkSessionFactoryOpen();
        this.checkTransactionSynchStatus();
        try {
            return !this.isClosed();
        }
        catch (HibernateException he) {
            throw this.getExceptionConverter().convert(he);
        }
    }

    protected void checkSessionFactoryOpen() {
        if (!this.getFactory().isOpen()) {
            log.trace("Forcing-closing session since factory is already closed");
            this.setClosed();
        }
    }

    private void managedFlush() {
        if (!this.isOpenOrWaitingForAutoClose()) {
            log.trace("Skipping auto-flush since the session is closed");
        } else {
            log.trace("Automatically flushing session");
            this.doFlush();
        }
    }

    public boolean shouldAutoClose() {
        if (this.waitingForAutoClose) {
            return true;
        }
        if (this.isClosed()) {
            return false;
        }
        return this.isAutoCloseSessionEnabled();
    }

    private void managedClose() {
        log.trace("Automatically closing session");
        this.closeWithoutOpenChecks();
    }

    @Override
    public void afterOperation(boolean success) {
        if (!this.isTransactionInProgress()) {
            this.getJdbcCoordinator().afterTransaction();
        }
    }

    @Override
    public void addEventListeners(SessionEventListener ... listeners) {
        this.getEventListenerManager().addListener(listeners);
    }

    @Override
    protected void cleanupOnClose() {
        this.persistenceContext.clear();
    }

    @Override
    public LockMode getCurrentLockMode(Object object) {
        this.checkOpen();
        this.checkTransactionSynchStatus();
        if (object == null) {
            throw new NullPointerException("null object passed to getCurrentLockMode()");
        }
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(object);
        if (lazyInitializer != null && (object = lazyInitializer.getImplementation(this)) == null) {
            return LockMode.NONE;
        }
        EntityEntry entry = this.getEntityEntry(object);
        if (entry.getStatus().isDeletedOrGone()) {
            throw new ObjectDeletedException("Given entity was removed", entry.getId(), entry.getPersister().getEntityName());
        }
        return entry.getLockMode();
    }

    @Override
    public Object getEntityUsingInterceptor(EntityKey key) {
        this.checkOpenOrWaitingForAutoClose();
        Object result = this.persistenceContext.getEntity(key);
        if (result == null) {
            Object newObject = this.getInterceptor().getEntity(key.getEntityName(), key.getIdentifier());
            if (newObject != null) {
                this.lock(newObject, LockMode.NONE);
            }
            return newObject;
        }
        return result;
    }

    protected void checkNoUnresolvedActionsBeforeOperation() {
        if (this.persistenceContext.getCascadeLevel() == 0 && this.actionQueue.hasUnresolvedEntityInsertActions()) {
            throw new IllegalStateException("There are delayed insert actions before operation as cascade level 0.");
        }
    }

    protected void checkNoUnresolvedActionsAfterOperation() {
        if (this.persistenceContext.getCascadeLevel() == 0) {
            this.actionQueue.checkNoUnresolvedActionsAfterOperation();
        }
        this.delayedAfterCompletion();
    }

    @Override
    public void delayedAfterCompletion() {
        super.delayedAfterCompletion();
    }

    @Override
    public void pulseTransactionCoordinator() {
        super.pulseTransactionCoordinator();
    }

    @Override
    public void checkOpenOrWaitingForAutoClose() {
        if (!this.waitingForAutoClose) {
            this.checkOpen();
        }
    }

    @Override
    public void lock(Object object, LockOptions lockOptions) {
        this.fireLock(new LockEvent(object, lockOptions, (EventSource)this));
    }

    @Override
    public void lock(String entityName, Object object, LockOptions lockOptions) {
        this.fireLock(new LockEvent(entityName, object, lockOptions, (EventSource)this));
    }

    @Override
    public void lock(Object object, LockMode lockMode) {
        LockOptions lockOptions = this.copySessionLockOptions();
        lockOptions.setLockMode(lockMode);
        this.fireLock(new LockEvent(object, lockOptions, (EventSource)this));
    }

    @Override
    public void lock(Object object, LockMode lockMode, LockOption ... lockOptions) {
        this.lock(object, this.buildLockOptions(lockMode, lockOptions));
    }

    private void fireLock(LockEvent event) {
        this.checkOpen();
        this.checkEntityManaged(event.getEntityName(), event.getObject());
        try {
            this.pulseTransactionCoordinator();
            this.checkTransactionNeededForLock(event.getLockMode());
            this.eventListenerGroups.eventListenerGroup_LOCK.fireEventOnEachListener(event, LockEventListener::onLock);
        }
        catch (RuntimeException e) {
            this.convertIfJpaBootstrap(e, event.getLockOptions());
        }
        finally {
            this.delayedAfterCompletion();
        }
    }

    private void convertIfJpaBootstrap(RuntimeException exception, LockOptions lockOptions) {
        if (!this.isJpaBootstrap() && exception instanceof HibernateException) {
            throw exception;
        }
        if (exception instanceof MappingException) {
            throw this.getExceptionConverter().convert(new IllegalArgumentException(exception.getMessage(), exception));
        }
        throw this.getExceptionConverter().convert(exception, lockOptions);
    }

    @Override
    public void persist(String entityName, Object object) {
        this.checkOpen();
        this.firePersist(new PersistEvent(entityName, object, this));
    }

    @Override
    public void persist(Object object) {
        this.checkOpen();
        this.firePersist(new PersistEvent(null, object, this));
    }

    @Override
    public void persist(String entityName, Object object, PersistContext copiedAlready) {
        this.checkOpenOrWaitingForAutoClose();
        this.firePersist(copiedAlready, new PersistEvent(entityName, object, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePersist(PersistEvent event) {
        Throwable originalException = null;
        try {
            this.checkTransactionSynchStatus();
            this.checkNoUnresolvedActionsBeforeOperation();
            this.eventListenerGroups.eventListenerGroup_PERSIST.fireEventOnEachListener(event, PersistEventListener::onPersist);
        }
        catch (MappingException e) {
            originalException = this.getExceptionConverter().convert(new IllegalArgumentException(e.getMessage(), (Throwable)((Object)e)));
        }
        catch (RuntimeException e) {
            originalException = this.getExceptionConverter().convert(e);
        }
        catch (Throwable t1) {
            originalException = t1;
        }
        finally {
            Throwable suppressed = null;
            try {
                this.checkNoUnresolvedActionsAfterOperation();
            }
            catch (RuntimeException e) {
                suppressed = this.getExceptionConverter().convert(e);
            }
            catch (Throwable t2) {
                suppressed = t2;
            }
            if (suppressed != null) {
                if (originalException == null) {
                    originalException = suppressed;
                } else {
                    originalException.addSuppressed(suppressed);
                }
            }
        }
        if (originalException != null) {
            ExceptionHelper.rethrow(originalException);
        }
    }

    private void firePersist(PersistContext copiedAlready, PersistEvent event) {
        try {
            this.pulseTransactionCoordinator();
            this.eventListenerGroups.eventListenerGroup_PERSIST.fireEventOnEachListener(event, copiedAlready, PersistEventListener::onPersist);
        }
        catch (MappingException e) {
            throw this.getExceptionConverter().convert(new IllegalArgumentException(e.getMessage()));
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
        finally {
            this.delayedAfterCompletion();
        }
    }

    @Override
    public void persistOnFlush(String entityName, Object object, PersistContext copiedAlready) {
        this.checkOpenOrWaitingForAutoClose();
        this.pulseTransactionCoordinator();
        PersistEvent event = new PersistEvent(entityName, object, this);
        this.eventListenerGroups.eventListenerGroup_PERSIST_ONFLUSH.fireEventOnEachListener(event, copiedAlready, PersistEventListener::onPersist);
        this.delayedAfterCompletion();
    }

    @Override
    public <T> T merge(String entityName, T object) {
        this.checkOpen();
        return (T)this.fireMerge(new MergeEvent(entityName, object, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T merge(T object, EntityGraph<?> loadGraph) {
        EffectiveEntityGraph effectiveEntityGraph = this.loadQueryInfluencers.getEffectiveEntityGraph();
        try {
            effectiveEntityGraph.applyGraph((RootGraphImplementor)loadGraph, GraphSemantic.LOAD);
            T t = this.merge(object);
            return t;
        }
        finally {
            effectiveEntityGraph.clear();
        }
    }

    @Override
    public <T> T merge(T object) {
        this.checkOpen();
        return (T)this.fireMerge(new MergeEvent(null, object, this));
    }

    @Override
    public void merge(String entityName, Object object, MergeContext copiedAlready) {
        this.checkOpenOrWaitingForAutoClose();
        this.fireMerge(copiedAlready, new MergeEvent(entityName, object, this));
    }

    private Object fireMerge(MergeEvent event) {
        try {
            this.checkTransactionSynchStatus();
            this.checkNoUnresolvedActionsBeforeOperation();
            this.eventListenerGroups.eventListenerGroup_MERGE.fireEventOnEachListener(event, MergeEventListener::onMerge);
            this.checkNoUnresolvedActionsAfterOperation();
        }
        catch (ObjectDeletedException sse) {
            throw this.getExceptionConverter().convert(new IllegalArgumentException((Throwable)((Object)sse)));
        }
        catch (MappingException e) {
            throw this.getExceptionConverter().convert(new IllegalArgumentException(e.getMessage(), (Throwable)((Object)e)));
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
        return event.getResult();
    }

    private void fireMerge(MergeContext mergeContext, MergeEvent event) {
        try {
            this.pulseTransactionCoordinator();
            this.eventListenerGroups.eventListenerGroup_MERGE.fireEventOnEachListener(event, mergeContext, MergeEventListener::onMerge);
        }
        catch (ObjectDeletedException sse) {
            throw this.getExceptionConverter().convert(new IllegalArgumentException((Throwable)((Object)sse)));
        }
        catch (MappingException e) {
            throw this.getExceptionConverter().convert(new IllegalArgumentException(e.getMessage(), (Throwable)((Object)e)));
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
        finally {
            this.delayedAfterCompletion();
        }
    }

    @Override
    public void delete(String entityName, Object object, boolean isCascadeDeleteEnabled, DeleteContext transientEntities) {
        this.checkOpenOrWaitingForAutoClose();
        boolean removingOrphanBeforeUpdates = this.persistenceContext.isRemovingOrphanBeforeUpdates();
        boolean traceEnabled = log.isTraceEnabled();
        if (traceEnabled && removingOrphanBeforeUpdates) {
            this.logRemoveOrphanBeforeUpdates("before continuing", entityName, object);
        }
        this.fireDelete(new DeleteEvent(entityName, object, isCascadeDeleteEnabled, removingOrphanBeforeUpdates, this), transientEntities);
        if (traceEnabled && removingOrphanBeforeUpdates) {
            this.logRemoveOrphanBeforeUpdates("after continuing", entityName, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOrphanBeforeUpdates(String entityName, Object child) {
        boolean traceEnabled = log.isTraceEnabled();
        if (traceEnabled) {
            this.logRemoveOrphanBeforeUpdates("begin", entityName, child);
        }
        this.persistenceContext.beginRemoveOrphanBeforeUpdates();
        try {
            this.checkOpenOrWaitingForAutoClose();
            this.fireDelete(new DeleteEvent(entityName, child, false, true, this));
        }
        finally {
            this.persistenceContext.endRemoveOrphanBeforeUpdates();
            if (traceEnabled) {
                this.logRemoveOrphanBeforeUpdates("end", entityName, child);
            }
        }
    }

    private void logRemoveOrphanBeforeUpdates(String timing, String entityName, Object entity) {
        if (log.isTraceEnabled()) {
            EntityEntry entityEntry = this.persistenceContext.getEntry(entity);
            log.tracef("%s remove orphan before updates: [%s]", timing, entityEntry == null ? entityName : MessageHelper.infoString(entityName, entityEntry.getId()));
        }
    }

    private void fireDelete(DeleteEvent event) {
        try {
            this.pulseTransactionCoordinator();
            this.eventListenerGroups.eventListenerGroup_DELETE.fireEventOnEachListener(event, DeleteEventListener::onDelete);
        }
        catch (ObjectDeletedException sse) {
            throw this.getExceptionConverter().convert(new IllegalArgumentException((Throwable)((Object)sse)));
        }
        catch (MappingException e) {
            throw this.getExceptionConverter().convert(new IllegalArgumentException(e.getMessage(), (Throwable)((Object)e)));
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
        finally {
            this.delayedAfterCompletion();
        }
    }

    private void fireDelete(DeleteEvent event, DeleteContext transientEntities) {
        try {
            this.pulseTransactionCoordinator();
            this.eventListenerGroups.eventListenerGroup_DELETE.fireEventOnEachListener(event, transientEntities, DeleteEventListener::onDelete);
        }
        catch (ObjectDeletedException sse) {
            throw this.getExceptionConverter().convert(new IllegalArgumentException((Throwable)((Object)sse)));
        }
        catch (MappingException e) {
            throw this.getExceptionConverter().convert(new IllegalArgumentException(e.getMessage(), (Throwable)((Object)e)));
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
        finally {
            this.delayedAfterCompletion();
        }
    }

    @Override
    public void load(Object object, Object id) {
        this.fireLoad(new LoadEvent(id, object, this, this.getReadOnlyFromLoadQueryInfluencers()), LoadEventListener.RELOAD);
    }

    private <T> void setMultiIdentifierLoadAccessOptions(FindOption[] options, MultiIdentifierLoadAccess<T> loadAccess) {
        CacheStoreMode storeMode = this.getCacheStoreMode();
        CacheRetrieveMode retrieveMode = this.getCacheRetrieveMode();
        LockOptions lockOptions = this.copySessionLockOptions();
        int batchSize = -1;
        for (FindOption option : options) {
            if (option instanceof CacheStoreMode) {
                CacheStoreMode cacheStoreMode;
                storeMode = cacheStoreMode = (CacheStoreMode)option;
                continue;
            }
            if (option instanceof CacheRetrieveMode) {
                CacheRetrieveMode cacheRetrieveMode;
                retrieveMode = cacheRetrieveMode = (CacheRetrieveMode)option;
                continue;
            }
            if (option instanceof CacheMode) {
                CacheMode cacheMode = (CacheMode)option;
                storeMode = cacheMode.getJpaStoreMode();
                retrieveMode = cacheMode.getJpaRetrieveMode();
                continue;
            }
            if (option instanceof LockModeType) {
                LockModeType lockModeType = (LockModeType)option;
                lockOptions.setLockMode(LockModeTypeHelper.getLockMode(lockModeType));
                continue;
            }
            if (option instanceof LockMode) {
                LockMode lockMode = (LockMode)option;
                lockOptions.setLockMode(lockMode);
                continue;
            }
            if (option instanceof LockOptions) {
                LockOptions lockOpts;
                lockOptions = lockOpts = (LockOptions)option;
                continue;
            }
            if (option instanceof PessimisticLockScope) {
                PessimisticLockScope pessimisticLockScope = (PessimisticLockScope)option;
                lockOptions.setLockScope(pessimisticLockScope);
                continue;
            }
            if (option instanceof Timeout) {
                Timeout timeout = (Timeout)option;
                lockOptions.setTimeOut(timeout.milliseconds());
                continue;
            }
            if (option instanceof EnabledFetchProfile) {
                EnabledFetchProfile enabledFetchProfile = (EnabledFetchProfile)option;
                loadAccess.enableFetchProfile(enabledFetchProfile.profileName());
                continue;
            }
            if (option instanceof ReadOnlyMode) {
                loadAccess.withReadOnly(option == ReadOnlyMode.READ_ONLY);
                continue;
            }
            if (!(option instanceof BatchSize)) continue;
            BatchSize batchSizeOption = (BatchSize)option;
            batchSize = batchSizeOption.batchSize();
        }
        loadAccess.with(lockOptions).with(CacheModeHelper.interpretCacheMode(storeMode, retrieveMode)).withBatchSize(batchSize);
    }

    @Override
    public <E> List<E> findMultiple(Class<E> entityType, List<?> ids, FindOption ... options) {
        MultiIdentifierLoadAccess<E> loadAccess = this.byMultipleIds(entityType);
        this.setMultiIdentifierLoadAccessOptions(options, loadAccess);
        return loadAccess.multiLoad(ids);
    }

    @Override
    public <E> List<E> findMultiple(EntityGraph<E> entityGraph, List<?> ids, FindOption ... options) {
        RootGraph rootGraph = (RootGraph)entityGraph;
        ManagedDomainType type = rootGraph.getGraphedType();
        MultiIdentifierLoadAccess<Object> loadAccess = switch (type.getRepresentationMode()) {
            default -> throw new IncompatibleClassChangeError();
            case RepresentationMode.MAP -> this.byMultipleIds(type.getTypeName());
            case RepresentationMode.POJO -> this.byMultipleIds(type.getJavaType());
        };
        loadAccess.withLoadGraph(rootGraph);
        this.setMultiIdentifierLoadAccessOptions(options, loadAccess);
        return loadAccess.multiLoad(ids);
    }

    @Override
    public <T> T get(Class<T> entityClass, Object id) {
        return ((IdentifierLoadAccessImpl)this.byId((Class)entityClass)).load(id);
    }

    @Override
    public Object get(String entityName, Object id) {
        return ((IdentifierLoadAccessImpl)this.byId(entityName)).load(id);
    }

    @Override
    public Object immediateLoad(String entityName, Object id) {
        if (log.isDebugEnabled()) {
            EntityPersister persister = this.requireEntityPersister(entityName);
            log.tracef("Initializing proxy: %s", MessageHelper.infoString(persister, id, this.getFactory()));
        }
        LoadEvent event = this.makeLoadEvent(entityName, id, this.getReadOnlyFromLoadQueryInfluencers(), true);
        this.fireLoadNoChecks(event, LoadEventListener.IMMEDIATE_LOAD);
        Object result = event.getResult();
        this.releaseLoadEvent(event);
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(result);
        return lazyInitializer != null ? lazyInitializer.getImplementation() : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object internalLoad(String entityName, Object id, boolean eager, boolean nullable) {
        boolean clearedEffectiveGraph;
        LoadEventListener.LoadType type = SessionImpl.internalLoadType(eager, nullable);
        EffectiveEntityGraph effectiveEntityGraph = this.loadQueryInfluencers.getEffectiveEntityGraph();
        GraphSemantic semantic = effectiveEntityGraph.getSemantic();
        RootGraphImplementor<?> graph = effectiveEntityGraph.getGraph();
        if (semantic == null || graph.appliesTo((EntityDomainType<?>)this.getFactory().getJpaMetamodel().entity(entityName))) {
            clearedEffectiveGraph = false;
        } else {
            log.trace("Clearing effective entity graph for subsequent select");
            clearedEffectiveGraph = true;
            effectiveEntityGraph.clear();
        }
        try {
            LoadEvent event = this.makeLoadEvent(entityName, id, this.getReadOnlyFromLoadQueryInfluencers(), true);
            this.fireLoadNoChecks(event, type);
            Object result = event.getResult();
            if (!nullable) {
                UnresolvableObjectException.throwIfNull(result, id, entityName);
            }
            this.releaseLoadEvent(event);
            Object object = result;
            return object;
        }
        finally {
            if (clearedEffectiveGraph) {
                effectiveEntityGraph.applyGraph(graph, semantic);
            }
        }
    }

    protected static LoadEventListener.LoadType internalLoadType(boolean eager, boolean nullable) {
        if (nullable) {
            return LoadEventListener.INTERNAL_LOAD_NULLABLE;
        }
        return eager ? LoadEventListener.INTERNAL_LOAD_EAGER : LoadEventListener.INTERNAL_LOAD_LAZY;
    }

    @Override
    public Object loadFromSecondLevelCache(EntityPersister persister, EntityKey entityKey, Object instanceToLoad, LockMode lockMode) {
        Object entity = CacheLoadHelper.loadFromSecondLevelCache(this, instanceToLoad, lockMode, persister, entityKey);
        if (entity != null) {
            Object id = entityKey.getIdentifierValue();
            PostLoadEvent event = this.makePostLoadEvent(persister, id, entity);
            this.eventListenerGroups.eventListenerGroup_POST_LOAD.fireEventOnEachListener(event, PostLoadEventListener::onPostLoad);
            this.releasePostLoadEvent(event);
        }
        return entity;
    }

    protected PostLoadEvent makePostLoadEvent(EntityPersister persister, Object id, Object entity) {
        PostLoadEvent event = this.postLoadEvent;
        if (event == null) {
            return new PostLoadEvent(id, persister, entity, this);
        }
        this.postLoadEvent = null;
        event.setId(id);
        event.setPersister(persister);
        event.setEntity(entity);
        return event;
    }

    protected LoadEvent makeLoadEvent(String entityName, Object id, Boolean readOnly, LockOptions lockOptions) {
        LoadEvent event = this.loadEvent;
        if (event == null) {
            return new LoadEvent(id, entityName, lockOptions, (EventSource)this, readOnly);
        }
        this.loadEvent = null;
        event.setEntityClassName(entityName);
        event.setEntityId(id);
        event.setInstanceToLoad(null);
        event.setReadOnly(readOnly);
        event.setLockOptions(lockOptions);
        event.setAssociationFetch(false);
        return event;
    }

    protected LoadEvent makeLoadEvent(String entityName, Object id, Boolean readOnly, boolean isAssociationFetch) {
        LoadEvent event = this.loadEvent;
        if (event == null) {
            return new LoadEvent(id, entityName, isAssociationFetch, (EventSource)this, readOnly);
        }
        this.loadEvent = null;
        event.setEntityClassName(entityName);
        event.setEntityId(id);
        event.setInstanceToLoad(null);
        event.setReadOnly(readOnly);
        event.setLockOptions(LockMode.NONE.toLockOptions());
        event.setAssociationFetch(isAssociationFetch);
        return event;
    }

    protected void releasePostLoadEvent(PostLoadEvent event) {
        if (this.postLoadEvent == null) {
            event.setEntity(null);
            event.setId(null);
            event.setPersister(null);
            this.postLoadEvent = event;
        }
    }

    protected void releaseLoadEvent(LoadEvent event) {
        if (this.loadEvent == null) {
            event.setEntityClassName(null);
            event.setEntityId(null);
            event.setInstanceToLoad(null);
            event.setResult(null);
            event.setLockOptions(null);
            event.setReadOnly(null);
            this.loadEvent = event;
        }
    }

    @Override
    @Deprecated
    public <T> T get(Class<T> entityClass, Object id, LockMode lockMode) {
        return ((IdentifierLoadAccessImpl)((IdentifierLoadAccessImpl)this.byId((Class)entityClass)).with(new LockOptions(lockMode))).load(id);
    }

    @Override
    @Deprecated
    public Object get(String entityName, Object id, LockMode lockMode) {
        return ((IdentifierLoadAccessImpl)((IdentifierLoadAccessImpl)this.byId(entityName)).with(new LockOptions(lockMode))).load(id);
    }

    @Override
    @Deprecated
    public <T> T get(Class<T> entityClass, Object id, LockOptions lockOptions) {
        return ((IdentifierLoadAccessImpl)((IdentifierLoadAccessImpl)this.byId((Class)entityClass)).with(lockOptions)).load(id);
    }

    @Override
    @Deprecated
    public Object get(String entityName, Object id, LockOptions lockOptions) {
        return ((IdentifierLoadAccessImpl)((IdentifierLoadAccessImpl)this.byId(entityName)).with(lockOptions)).load(id);
    }

    public <T> IdentifierLoadAccessImpl<T> byId(String entityName) {
        return new IdentifierLoadAccessImpl(this, this.requireEntityPersister(entityName));
    }

    public <T> IdentifierLoadAccessImpl<T> byId(Class<T> entityClass) {
        return new IdentifierLoadAccessImpl(this, this.requireEntityPersister(entityClass));
    }

    @Override
    public <T> MultiIdentifierLoadAccess<T> byMultipleIds(Class<T> entityClass) {
        return new MultiIdentifierLoadAccessImpl(this, this.requireEntityPersister(entityClass));
    }

    @Override
    public <T> MultiIdentifierLoadAccess<T> byMultipleIds(String entityName) {
        return new MultiIdentifierLoadAccessImpl(this, this.requireEntityPersister(entityName));
    }

    @Override
    public <T> NaturalIdLoadAccess<T> byNaturalId(String entityName) {
        return new NaturalIdLoadAccessImpl(this, this.requireEntityPersister(entityName));
    }

    @Override
    public <T> NaturalIdLoadAccess<T> byNaturalId(Class<T> entityClass) {
        return new NaturalIdLoadAccessImpl(this, this.requireEntityPersister(entityClass));
    }

    @Override
    public <T> SimpleNaturalIdLoadAccess<T> bySimpleNaturalId(String entityName) {
        return new SimpleNaturalIdLoadAccessImpl(this, this.requireEntityPersister(entityName));
    }

    @Override
    public <T> SimpleNaturalIdLoadAccess<T> bySimpleNaturalId(Class<T> entityClass) {
        return new SimpleNaturalIdLoadAccessImpl(this, this.requireEntityPersister(entityClass));
    }

    @Override
    public <T> NaturalIdMultiLoadAccess<T> byMultipleNaturalId(Class<T> entityClass) {
        return new NaturalIdMultiLoadAccessStandard(this.requireEntityPersister(entityClass), this);
    }

    @Override
    public <T> NaturalIdMultiLoadAccess<T> byMultipleNaturalId(String entityName) {
        return new NaturalIdMultiLoadAccessStandard(this.requireEntityPersister(entityName), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object load(LoadEventListener.LoadType loadType, Object id, String entityName, LockOptions lockOptions, Boolean readOnly) {
        if (lockOptions != null) {
            LoadEvent event = this.makeLoadEvent(entityName, id, readOnly, lockOptions);
            this.fireLoad(event, loadType);
            Object result = event.getResult();
            this.releaseLoadEvent(event);
            return result;
        }
        boolean success = false;
        try {
            LoadEvent event = this.makeLoadEvent(entityName, id, readOnly, false);
            this.fireLoad(event, loadType);
            Object result = event.getResult();
            this.releaseLoadEvent(event);
            if (!loadType.isAllowNulls() && result == null) {
                this.getSession().getFactory().getEntityNotFoundDelegate().handleEntityNotFound(entityName, id);
            }
            success = true;
            Object object = result;
            return object;
        }
        finally {
            this.afterOperation(success);
        }
    }

    private void fireLoad(LoadEvent event, LoadEventListener.LoadType loadType) {
        this.checkOpenOrWaitingForAutoClose();
        this.fireLoadNoChecks(event, loadType);
        this.delayedAfterCompletion();
    }

    private void fireLoadNoChecks(LoadEvent event, LoadEventListener.LoadType loadType) {
        this.pulseTransactionCoordinator();
        this.eventListenerGroups.eventListenerGroup_LOAD.fireEventOnEachListener(event, loadType, LoadEventListener::onLoad);
    }

    @Override
    public void refresh(Object object) {
        this.fireRefresh(new RefreshEvent(object, this));
    }

    @Override
    public void refresh(Object object, LockOptions lockOptions) {
        this.fireRefresh(new RefreshEvent(object, lockOptions, (EventSource)this));
    }

    @Override
    public void refresh(String entityName, Object object, RefreshContext refreshedAlready) {
        this.fireRefresh(refreshedAlready, new RefreshEvent(entityName, object, (EventSource)this));
    }

    private void fireRefresh(RefreshEvent event) {
        this.checkOpen();
        this.checkEntityManaged(event.getEntityName(), event.getObject());
        try {
            this.pulseTransactionCoordinator();
            this.checkTransactionNeededForLock(event.getLockMode());
            this.eventListenerGroups.eventListenerGroup_REFRESH.fireEventOnEachListener(event, RefreshEventListener::onRefresh);
        }
        catch (RuntimeException e) {
            this.convertIfJpaBootstrap(e, event.getLockOptions());
        }
        finally {
            this.delayedAfterCompletion();
        }
    }

    private void fireRefresh(RefreshContext refreshedAlready, RefreshEvent event) {
        this.checkOpenOrWaitingForAutoClose();
        this.checkEntityManaged(event.getEntityName(), event.getObject());
        try {
            this.pulseTransactionCoordinator();
            this.eventListenerGroups.eventListenerGroup_REFRESH.fireEventOnEachListener(event, refreshedAlready, RefreshEventListener::onRefresh);
        }
        finally {
            this.delayedAfterCompletion();
        }
    }

    private void checkEntityManaged(String entityName, Object entity) {
        if (!this.managed(entityName, entity)) {
            throw new IllegalArgumentException("Given entity is not associated with the persistence context");
        }
    }

    private boolean managed(String entityName, Object entity) {
        return entityName == null ? this.contains(entity) : this.contains(entityName, entity);
    }

    @Override
    public void replicate(Object obj, ReplicationMode replicationMode) {
        this.fireReplicate(new ReplicateEvent(obj, replicationMode, this));
    }

    @Override
    public void replicate(String entityName, Object obj, ReplicationMode replicationMode) {
        this.fireReplicate(new ReplicateEvent(entityName, obj, replicationMode, this));
    }

    private void fireReplicate(ReplicateEvent event) {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        this.eventListenerGroups.eventListenerGroup_REPLICATE.fireEventOnEachListener(event, ReplicateEventListener::onReplicate);
        this.delayedAfterCompletion();
    }

    @Override
    public void evict(Object object) {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        EvictEvent event = new EvictEvent(object, this);
        this.eventListenerGroups.eventListenerGroup_EVICT.fireEventOnEachListener(event, EvictEventListener::onEvict);
        this.delayedAfterCompletion();
    }

    @Override
    public boolean autoFlushIfRequired(Set<String> querySpaces) {
        return this.autoFlushIfRequired(querySpaces, false);
    }

    @Override
    public boolean autoFlushIfRequired(Set<String> querySpaces, boolean skipPreFlush) {
        this.checkOpen();
        if (!this.isTransactionInProgress()) {
            return false;
        }
        AutoFlushEvent event = new AutoFlushEvent(querySpaces, skipPreFlush, this);
        this.eventListenerGroups.eventListenerGroup_AUTO_FLUSH.fireEventOnEachListener(event, AutoFlushEventListener::onAutoFlush);
        return event.isFlushRequired();
    }

    @Override
    public void autoPreFlush() {
        this.checkOpen();
        if (!this.isTransactionInProgress()) {
            return;
        }
        this.eventListenerGroups.eventListenerGroup_AUTO_FLUSH.fireEventOnEachListener(this, AutoFlushEventListener::onAutoPreFlush);
    }

    @Override
    public boolean isDirty() {
        this.checkOpen();
        if (this.actionQueue.areInsertionsOrDeletionsQueued()) {
            return true;
        }
        DirtyCheckEvent event = new DirtyCheckEvent(this);
        this.eventListenerGroups.eventListenerGroup_DIRTY_CHECK.fireEventOnEachListener(event, DirtyCheckEventListener::onDirtyCheck);
        return event.isDirty();
    }

    @Override
    public void flush() {
        this.checkOpen();
        this.doFlush();
    }

    private void doFlush() {
        try {
            this.pulseTransactionCoordinator();
            this.checkTransactionNeededForUpdateOperation();
            if (this.persistenceContext.getCascadeLevel() > 0) {
                throw new HibernateException("Flush during cascade is dangerous");
            }
            this.eventListenerGroups.eventListenerGroup_FLUSH.fireEventOnEachListener(new FlushEvent(this), FlushEventListener::onFlush);
            this.delayedAfterCompletion();
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public void setHibernateFlushMode(FlushMode flushMode) {
        this.flushMode = flushMode;
    }

    @Override
    public FlushMode getHibernateFlushMode() {
        return this.flushMode;
    }

    @Override
    public FlushModeType getFlushMode() {
        this.checkOpen();
        return FlushModeTypeHelper.getFlushModeType(this.getHibernateFlushMode());
    }

    @Override
    public void setFlushMode(FlushModeType flushModeType) {
        this.checkOpen();
        this.setHibernateFlushMode(FlushModeTypeHelper.getFlushMode(flushModeType));
    }

    @Override
    public void forceFlush(EntityEntry entityEntry) {
        this.forceFlush(entityEntry.getEntityKey());
    }

    @Override
    public void forceFlush(EntityKey key) {
        if (log.isTraceEnabled()) {
            log.tracef("Flushing to force deletion of re-saved object: " + MessageHelper.infoString(key.getPersister(), key.getIdentifier(), this.getFactory()), new Object[0]);
        }
        if (this.persistenceContext.getCascadeLevel() > 0) {
            throw new ObjectDeletedException("deleted object would be re-saved by cascade (remove deleted object from associations)", key.getIdentifier(), key.getPersister().getEntityName());
        }
        this.checkOpenOrWaitingForAutoClose();
        this.doFlush();
    }

    @Override
    @Deprecated
    public Object instantiate(String entityName, Object id) {
        return this.instantiate(this.requireEntityPersister(entityName), id);
    }

    @Override
    public Object instantiate(EntityPersister persister, Object id) {
        this.checkOpenOrWaitingForAutoClose();
        this.pulseTransactionCoordinator();
        Object result = this.getInterceptor().instantiate(persister.getEntityName(), persister.getRepresentationStrategy(), id);
        if (result == null) {
            result = persister.instantiate(id, this);
        }
        this.delayedAfterCompletion();
        return result;
    }

    @Override
    public EntityPersister getEntityPersister(String entityName, Object object) {
        this.checkOpenOrWaitingForAutoClose();
        if (entityName == null) {
            return this.requireEntityPersister(this.guessEntityName(object));
        }
        try {
            return this.requireEntityPersister(entityName).getSubclassEntityPersister(object, this.getFactory());
        }
        catch (UnknownEntityTypeException uee) {
            try {
                return this.getEntityPersister(null, object);
            }
            catch (HibernateException e) {
                Class<?> objectClass = object.getClass();
                String problem = objectClass.isAnnotationPresent(Entity.class) ? "does not belong to this persistence unit" : "is not annotated '@Entity'";
                throw new UnknownEntityTypeException(uee.getMessage() + " ('" + objectClass.getSimpleName() + "' " + problem + ")", (Throwable)((Object)e));
            }
        }
    }

    @Override
    public Object getIdentifier(Object object) {
        this.checkOpen();
        this.checkTransactionSynchStatus();
        if (object == null) {
            throw new IllegalArgumentException("Entity may not be null");
        }
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(object);
        if (lazyInitializer != null) {
            this.checkOwnsProxy(lazyInitializer);
            return lazyInitializer.getInternalIdentifier();
        }
        return this.getEntityEntry(object).getId();
    }

    @Override
    public Object getContextEntityIdentifier(Object object) {
        PersistentAttributeInterceptor interceptor;
        this.checkOpenOrWaitingForAutoClose();
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(object);
        if (lazyInitializer != null) {
            return lazyInitializer.getInternalIdentifier();
        }
        if (ManagedTypeHelper.isPersistentAttributeInterceptable(object) && (interceptor = ManagedTypeHelper.asPersistentAttributeInterceptable(object).$$_hibernate_getInterceptor()) instanceof EnhancementAsProxyLazinessInterceptor) {
            return ((EnhancementAsProxyLazinessInterceptor)interceptor).getIdentifier();
        }
        EntityEntry entry = this.persistenceContext.getEntry(object);
        return entry != null ? entry.getId() : null;
    }

    public boolean contains(Object object) {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        if (object == null) {
            return false;
        }
        try {
            LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(object);
            if (lazyInitializer != null) {
                if (lazyInitializer.isUninitialized()) {
                    return lazyInitializer.getSession() == this;
                }
                object = lazyInitializer.getImplementation();
            }
            EntityEntry entry = this.persistenceContext.getEntry(object);
            this.delayedAfterCompletion();
            if (entry == null) {
                if (lazyInitializer == null && this.persistenceContext.getEntry(object) == null) {
                    try {
                        String entityName = this.getEntityNameResolver().resolveEntityName(object);
                        if (entityName == null) {
                            throw new IllegalArgumentException("Could not resolve entity name for class '" + String.valueOf(object.getClass()) + "'");
                        }
                        this.requireEntityPersister(entityName);
                    }
                    catch (HibernateException e) {
                        throw new IllegalArgumentException("Class '" + String.valueOf(object.getClass()) + "' is not an entity class", (Throwable)((Object)e));
                    }
                }
                return false;
            }
            return !entry.getStatus().isDeletedOrGone();
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public boolean contains(String entityName, Object object) {
        this.checkOpenOrWaitingForAutoClose();
        this.pulseTransactionCoordinator();
        if (object == null) {
            return false;
        }
        try {
            LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(object);
            if (lazyInitializer == null && this.persistenceContext.getEntry(object) == null) {
                try {
                    this.requireEntityPersister(entityName);
                }
                catch (HibernateException e) {
                    throw new IllegalArgumentException("Not an entity [" + entityName + "] : " + String.valueOf(object));
                }
            }
            if (lazyInitializer != null) {
                if (lazyInitializer.isUninitialized()) {
                    return lazyInitializer.getSession() == this;
                }
                object = lazyInitializer.getImplementation();
            }
            EntityEntry entry = this.persistenceContext.getEntry(object);
            this.delayedAfterCompletion();
            return entry != null && !entry.getStatus().isDeletedOrGone();
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public ProcedureCall createStoredProcedureCall(String procedureName) {
        this.checkOpen();
        return super.createStoredProcedureCall(procedureName);
    }

    @Override
    public ProcedureCall createStoredProcedureCall(String procedureName, String ... resultSetMappings) {
        this.checkOpen();
        return super.createStoredProcedureCall(procedureName, resultSetMappings);
    }

    @Override
    public ProcedureCall createStoredProcedureCall(String procedureName, Class<?> ... resultClasses) {
        this.checkOpen();
        return super.createStoredProcedureCall(procedureName, resultClasses);
    }

    @Override
    public <T> QueryImplementor<T> createQuery(CriteriaSelect<T> selectQuery) {
        this.checkOpen();
        if (selectQuery instanceof CriteriaDefinition) {
            CriteriaDefinition criteriaDefinition = (CriteriaDefinition)selectQuery;
            return (QueryImplementor)criteriaDefinition.createSelectionQuery(this);
        }
        try {
            JpaQueryStructure querySpec;
            SqmSelectStatement selectStatement = (SqmSelectStatement)selectQuery;
            if (!(selectStatement.getQueryPart() instanceof SqmQueryGroup) && ((SqmQuerySpec)(querySpec = selectStatement.getQuerySpec())).getSelectClause().getSelections().isEmpty() && ((SqmQuerySpec)querySpec).getFromClause().getRoots().size() == 1) {
                ((SqmQuerySpec)querySpec).getSelectClause().setSelection((SqmSelectableNode)((SqmQuerySpec)querySpec).getFromClause().getRoots().get(0));
            }
            return this.createCriteriaQuery(selectStatement, selectStatement.getResultType());
        }
        catch (RuntimeException e) {
            if (this.getSessionFactory().getSessionFactoryOptions().getJpaCompliance().isJpaTransactionComplianceEnabled()) {
                this.markForRollbackOnly();
            }
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public void initializeCollection(PersistentCollection<?> collection, boolean writing) {
        this.checkOpenOrWaitingForAutoClose();
        this.pulseTransactionCoordinator();
        this.eventListenerGroups.eventListenerGroup_INIT_COLLECTION.fireEventOnEachListener(new InitializeCollectionEvent(collection, this), InitializeCollectionEventListener::onInitializeCollection);
        this.delayedAfterCompletion();
    }

    @Override
    public String bestGuessEntityName(Object object) {
        EntityEntry entry;
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(object);
        if (lazyInitializer != null) {
            if (lazyInitializer.isUninitialized()) {
                return lazyInitializer.getEntityName();
            }
            object = lazyInitializer.getImplementation();
        }
        return (entry = this.persistenceContext.getEntry(object)) == null ? this.guessEntityName(object) : entry.getPersister().getEntityName();
    }

    @Override
    public String bestGuessEntityName(Object object, EntityEntry entry) {
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(object);
        if (lazyInitializer != null) {
            if (lazyInitializer.isUninitialized()) {
                return lazyInitializer.getEntityName();
            }
            object = lazyInitializer.getImplementation();
        }
        return entry == null ? this.guessEntityName(object) : entry.getPersister().getEntityName();
    }

    @Override
    public String getEntityName(Object object) {
        this.checkOpen();
        if (object == null) {
            throw new IllegalArgumentException("Entity may not be null");
        }
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(object);
        if (lazyInitializer != null) {
            this.checkOwnsProxy(lazyInitializer);
            object = lazyInitializer.getImplementation();
        }
        return this.getEntityEntry(object).getPersister().getEntityName();
    }

    private void checkOwnsProxy(LazyInitializer lazyInitializer) {
        if (lazyInitializer.getSession() != this) {
            throw new IllegalArgumentException("Given proxy is not associated with the persistence context");
        }
    }

    private EntityEntry getEntityEntry(Object object) {
        EntityEntry entry = this.persistenceContext.getEntry(object);
        if (entry == null) {
            throw new IllegalArgumentException("Given entity is not associated with the persistence context");
        }
        return entry;
    }

    @Override
    public <T> T getReference(T object) {
        this.checkOpen();
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(object);
        if (lazyInitializer != null) {
            return (T)this.getReference(lazyInitializer.getPersistentClass(), lazyInitializer.getInternalIdentifier());
        }
        EntityPersister persister = this.getEntityPersister(null, object);
        return (T)this.getReference(persister.getMappedClass(), persister.getIdentifier(object, this));
    }

    @Override
    public String guessEntityName(Object object) {
        this.checkOpenOrWaitingForAutoClose();
        return this.getEntityNameResolver().resolveEntityName(object);
    }

    @Override
    public void cancelQuery() {
        this.checkOpen();
        this.getJdbcCoordinator().cancelLastQuery();
    }

    public String toString() {
        StringBuilder string = new StringBuilder(500).append("SessionImpl(").append(System.identityHashCode(this));
        if (!this.isClosed()) {
            if (log.isTraceEnabled()) {
                string.append(this.persistenceContext).append(";").append(this.actionQueue);
            } else {
                string.append("<open>");
            }
        } else {
            string.append("<closed>");
        }
        return string.append(')').toString();
    }

    @Override
    public ActionQueue getActionQueue() {
        this.checkOpenOrWaitingForAutoClose();
        return this.actionQueue;
    }

    @Override
    public void registerProcess(AfterTransactionCompletionProcess process) {
        this.getActionQueue().registerProcess(process);
    }

    @Override
    public PersistenceContext getPersistenceContext() {
        this.checkOpenOrWaitingForAutoClose();
        return this.persistenceContext;
    }

    @Override
    public PersistenceContext getPersistenceContextInternal() {
        return this.persistenceContext;
    }

    @Override
    public SessionStatistics getStatistics() {
        this.pulseTransactionCoordinator();
        return new SessionStatisticsImpl(this);
    }

    @Override
    public boolean isEventSource() {
        this.pulseTransactionCoordinator();
        return true;
    }

    @Override
    public EventSource asEventSource() {
        return this;
    }

    @Override
    public boolean isDefaultReadOnly() {
        return this.persistenceContext.isDefaultReadOnly();
    }

    @Override
    public void setDefaultReadOnly(boolean defaultReadOnly) {
        this.persistenceContext.setDefaultReadOnly(defaultReadOnly);
    }

    @Override
    public boolean isReadOnly(Object entityOrProxy) {
        this.checkOpen();
        return this.persistenceContext.isReadOnly(entityOrProxy);
    }

    @Override
    public void setReadOnly(Object entity, boolean readOnly) {
        this.checkOpen();
        this.persistenceContext.setReadOnly(entity, readOnly);
    }

    @Override
    public CacheStoreMode getCacheStoreMode() {
        return this.getCacheMode().getJpaStoreMode();
    }

    @Override
    public CacheRetrieveMode getCacheRetrieveMode() {
        return this.getCacheMode().getJpaRetrieveMode();
    }

    @Override
    public void setCacheStoreMode(CacheStoreMode cacheStoreMode) {
        this.setCacheMode(CacheMode.fromJpaModes(this.getCacheMode().getJpaRetrieveMode(), cacheStoreMode));
    }

    @Override
    public void setCacheRetrieveMode(CacheRetrieveMode cacheRetrieveMode) {
        this.setCacheMode(CacheMode.fromJpaModes(cacheRetrieveMode, this.getCacheMode().getJpaStoreMode()));
    }

    @Override
    public void afterScrollOperation() {
    }

    @Override
    public LoadQueryInfluencers getLoadQueryInfluencers() {
        return this.loadQueryInfluencers;
    }

    @Override
    public boolean isFetchProfileEnabled(String name) throws UnknownProfileException {
        return this.loadQueryInfluencers.isFetchProfileEnabled(name);
    }

    @Override
    public void enableFetchProfile(String name) throws UnknownProfileException {
        this.loadQueryInfluencers.enableFetchProfile(name);
    }

    @Override
    public void disableFetchProfile(String name) throws UnknownProfileException {
        this.loadQueryInfluencers.disableFetchProfile(name);
    }

    @Override
    public void setSubselectFetchingEnabled(boolean enabled) {
        this.loadQueryInfluencers.setSubselectFetchEnabled(enabled);
    }

    @Override
    public boolean isSubselectFetchingEnabled() {
        return this.loadQueryInfluencers.getSubselectFetchEnabled();
    }

    @Override
    public void setFetchBatchSize(int batchSize) {
        this.loadQueryInfluencers.setBatchSize(batchSize);
    }

    @Override
    public int getFetchBatchSize() {
        return this.loadQueryInfluencers.getBatchSize();
    }

    @Override
    public LobHelper getLobHelper() {
        return Hibernate.getLobHelper();
    }

    @Override
    public void beforeTransactionCompletion() {
        log.trace("SessionImpl#beforeTransactionCompletion()");
        this.flushBeforeTransactionCompletion();
        this.actionQueue.beforeTransactionCompletion();
        this.beforeTransactionCompletionEvents();
        super.beforeTransactionCompletion();
    }

    @Override
    public void afterTransactionCompletion(boolean successful, boolean delayed) {
        boolean notClosed;
        if (log.isTraceEnabled()) {
            log.tracef("SessionImpl#afterTransactionCompletion(successful=%s, delayed=%s)", successful, delayed);
        }
        if ((notClosed = this.isOpenOrWaitingForAutoClose()) && (!successful || this.autoClear)) {
            this.internalClear();
        }
        this.persistenceContext.afterTransactionCompletion();
        this.actionQueue.afterTransactionCompletion(successful);
        this.afterTransactionCompletionEvents(successful);
        if (!delayed && notClosed && this.shouldAutoClose()) {
            this.managedClose();
        }
        super.afterTransactionCompletion(successful, delayed);
    }

    @Override
    protected void addSharedSessionTransactionObserver(TransactionCoordinator transactionCoordinator) {
        this.transactionObserver = new TransactionObserver(){

            @Override
            public void afterBegin() {
            }

            @Override
            public void beforeCompletion() {
                if (SessionImpl.this.isOpen() && SessionImpl.this.getHibernateFlushMode() != FlushMode.MANUAL) {
                    SessionImpl.this.managedFlush();
                }
                SessionImpl.this.actionQueue.beforeTransactionCompletion();
                SessionImpl.this.beforeTransactionCompletionEvents();
            }

            @Override
            public void afterCompletion(boolean successful, boolean delayed) {
                SessionImpl.this.afterTransactionCompletion(successful, delayed);
                if (!SessionImpl.this.isClosed() && SessionImpl.this.autoClose) {
                    SessionImpl.this.managedClose();
                }
            }
        };
        transactionCoordinator.addObserver(this.transactionObserver);
    }

    @Override
    protected void removeSharedSessionTransactionObserver(TransactionCoordinator transactionCoordinator) {
        super.removeSharedSessionTransactionObserver(transactionCoordinator);
        transactionCoordinator.removeObserver(this.transactionObserver);
    }

    @Override
    public void startTransactionBoundary() {
        this.checkOpenOrWaitingForAutoClose();
        super.startTransactionBoundary();
    }

    @Override
    public void afterTransactionBegin() {
        this.checkOpenOrWaitingForAutoClose();
        this.afterTransactionBeginEvents();
    }

    @Override
    public void flushBeforeTransactionCompletion() {
        if (this.mustFlushBeforeCompletion()) {
            try {
                this.managedFlush();
            }
            catch (RuntimeException re) {
                throw ExceptionMapperStandardImpl.INSTANCE.mapManagedFlushFailure("error during managed flush", re, this);
            }
        }
    }

    private boolean mustFlushBeforeCompletion() {
        return this.isTransactionFlushable() && this.getHibernateFlushMode() != FlushMode.MANUAL;
    }

    private boolean isTransactionFlushable() {
        if (this.getCurrentTransaction() == null) {
            return true;
        }
        TransactionStatus status = this.getCurrentTransaction().getStatus();
        return status == TransactionStatus.ACTIVE || status == TransactionStatus.COMMITTING;
    }

    @Override
    public SessionImplementor getSession() {
        return this;
    }

    @Override
    public void remove(Object entity) {
        this.checkOpen();
        try {
            this.fireDelete(new DeleteEvent(entity, this));
        }
        catch (MappingException e) {
            throw this.getExceptionConverter().convert(new IllegalArgumentException(e.getMessage(), (Throwable)((Object)e)));
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public <T> T find(Class<T> entityClass, Object primaryKey) {
        return this.find(entityClass, primaryKey, (LockOptions)null, null);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        return this.find(entityClass, primaryKey, (LockOptions)null, properties);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockModeType) {
        return this.find(entityClass, primaryKey, lockModeType, null);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockModeType, Map<String, Object> properties) {
        this.checkOpen();
        if (lockModeType == null) {
            throw new IllegalArgumentException("Given LockModeType was null");
        }
        LockMode lockMode = LockModeTypeHelper.getLockMode(lockModeType);
        this.checkTransactionNeededForLock(lockMode);
        return this.find(entityClass, primaryKey, this.buildLockOptions(lockMode, properties), properties);
    }

    private <T> T find(Class<T> entityClass, Object primaryKey, LockOptions lockOptions, Map<String, Object> properties) {
        try {
            this.loadQueryInfluencers.getEffectiveEntityGraph().applyConfiguredGraph(properties);
            this.loadQueryInfluencers.setReadOnly(SessionImpl.readOnlyHint(properties));
            Object t = ((IdentifierLoadAccessImpl)this.byId((Class)entityClass)).with(this.determineAppropriateLocalCacheMode(properties)).with(lockOptions).load(primaryKey);
            return t;
        }
        catch (FetchNotFoundException e) {
            throw e;
        }
        catch (EntityFilterException e) {
            throw e;
        }
        catch (EntityNotFoundException e) {
            SessionImpl.logIgnoringEntityNotFound(entityClass, primaryKey);
            T t = null;
            return t;
        }
        catch (ObjectDeletedException e) {
            T t = null;
            return t;
        }
        catch (ObjectNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (ClassCastException | MappingException | TypeMismatchException e) {
            throw this.getExceptionConverter().convert(new IllegalArgumentException(((Throwable)e).getMessage(), (Throwable)e));
        }
        catch (JDBCException e) {
            if (this.accessTransaction().isActive() && this.accessTransaction().getRollbackOnly()) {
                log.jdbcExceptionThrownWithTransactionRolledBack(e);
                T t = null;
                return t;
            }
            throw this.getExceptionConverter().convert(e, lockOptions);
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e, lockOptions);
        }
        finally {
            this.loadQueryInfluencers.getEffectiveEntityGraph().clear();
            this.loadQueryInfluencers.setReadOnly(null);
        }
    }

    protected static <T> void logIgnoringEntityNotFound(Class<T> entityClass, Object primaryKey) {
        if (log.isDebugEnabled()) {
            log.ignoringEntityNotFound(entityClass != null ? entityClass.getName() : null, primaryKey != null ? primaryKey.toString() : null);
        }
    }

    private <T> void setLoadAccessOptions(FindOption[] options, IdentifierLoadAccessImpl<T> loadAccess) {
        Object factoryHint;
        CacheStoreMode storeMode = this.getCacheStoreMode();
        CacheRetrieveMode retrieveMode = this.getCacheRetrieveMode();
        LockOptions lockOptions = this.copySessionLockOptions();
        for (FindOption option : options) {
            if (option instanceof CacheStoreMode) {
                CacheStoreMode cacheStoreMode;
                storeMode = cacheStoreMode = (CacheStoreMode)option;
                continue;
            }
            if (option instanceof CacheRetrieveMode) {
                CacheRetrieveMode cacheRetrieveMode;
                retrieveMode = cacheRetrieveMode = (CacheRetrieveMode)option;
                continue;
            }
            if (option instanceof CacheMode) {
                CacheMode cacheMode = (CacheMode)option;
                storeMode = cacheMode.getJpaStoreMode();
                retrieveMode = cacheMode.getJpaRetrieveMode();
                continue;
            }
            if (option instanceof LockModeType) {
                LockModeType lockModeType = (LockModeType)option;
                lockOptions.setLockMode(LockModeTypeHelper.getLockMode(lockModeType));
                continue;
            }
            if (option instanceof LockMode) {
                LockMode lockMode = (LockMode)option;
                lockOptions.setLockMode(lockMode);
                continue;
            }
            if (option instanceof LockOptions) {
                LockOptions lockOpts;
                lockOptions = lockOpts = (LockOptions)option;
                continue;
            }
            if (option instanceof Locking.Scope) {
                Locking.Scope lockScope = (Locking.Scope)option;
                lockOptions.setScope(lockScope);
                continue;
            }
            if (option instanceof PessimisticLockScope) {
                PessimisticLockScope pessimisticLockScope = (PessimisticLockScope)option;
                lockOptions.setScope(Locking.Scope.fromJpaScope(pessimisticLockScope));
                continue;
            }
            if (option instanceof Locking.FollowOn) {
                Locking.FollowOn followOn = (Locking.FollowOn)option;
                lockOptions.setFollowOnStrategy(followOn);
                continue;
            }
            if (option instanceof Timeout) {
                Timeout timeout = (Timeout)option;
                lockOptions.setTimeout(timeout);
                continue;
            }
            if (option instanceof EnabledFetchProfile) {
                EnabledFetchProfile enabledFetchProfile = (EnabledFetchProfile)option;
                loadAccess.enableFetchProfile(enabledFetchProfile.profileName());
                continue;
            }
            if (!(option instanceof ReadOnlyMode)) continue;
            loadAccess.withReadOnly(option == ReadOnlyMode.READ_ONLY);
        }
        if (lockOptions.getLockMode().isPessimistic() && lockOptions.getTimeOut() == -1 && (factoryHint = this.getFactory().getProperties().get("jakarta.persistence.lock.timeout")) != null) {
            lockOptions.setTimeOut(Timeouts.fromHint(factoryHint));
        }
        ((IdentifierLoadAccessImpl)loadAccess.with(lockOptions)).with(CacheModeHelper.interpretCacheMode(storeMode, retrieveMode));
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, FindOption ... options) {
        IdentifierLoadAccess loadAccess = this.byId((Class)entityClass);
        this.setLoadAccessOptions(options, (IdentifierLoadAccessImpl<T>)loadAccess);
        return ((IdentifierLoadAccessImpl)loadAccess).load(primaryKey);
    }

    public <T> T find(EntityGraph<T> entityGraph, Object primaryKey, FindOption ... options) {
        RootGraph graph = (RootGraph)entityGraph;
        ManagedDomainType type = graph.getGraphedType();
        IdentifierLoadAccess loadAccess = switch (type.getRepresentationMode()) {
            default -> throw new IncompatibleClassChangeError();
            case RepresentationMode.MAP -> this.byId(type.getTypeName());
            case RepresentationMode.POJO -> this.byId(type.getJavaType());
        };
        this.setLoadAccessOptions(options, (IdentifierLoadAccessImpl<T>)loadAccess);
        return loadAccess.withLoadGraph(graph).load(primaryKey);
    }

    protected void checkTransactionNeededForLock(LockMode lockMode) {
        if (lockMode.greaterThan(LockMode.READ)) {
            this.checkTransactionNeededForUpdateOperation();
        }
    }

    protected static Boolean readOnlyHint(Map<String, Object> properties) {
        if (properties == null) {
            return null;
        }
        Object value = properties.get("org.hibernate.readOnly");
        return value == null ? null : ConfigurationHelper.getBoolean(value);
    }

    protected CacheMode determineAppropriateLocalCacheMode(Map<String, Object> localProperties) {
        CacheRetrieveMode retrieveMode = null;
        CacheStoreMode storeMode = null;
        if (localProperties != null) {
            retrieveMode = SessionImpl.determineCacheRetrieveMode(localProperties);
            storeMode = SessionImpl.determineCacheStoreMode(localProperties);
        }
        if (retrieveMode == null) {
            retrieveMode = this.getSessionFactoryOptions().getCacheRetrieveMode(this.properties);
        }
        if (storeMode == null) {
            storeMode = this.getSessionFactoryOptions().getCacheStoreMode(this.properties);
        }
        return CacheModeHelper.interpretCacheMode(storeMode, retrieveMode);
    }

    private static CacheRetrieveMode determineCacheRetrieveMode(Map<String, Object> settings) {
        CacheRetrieveMode cacheRetrieveMode = (CacheRetrieveMode)settings.get("javax.persistence.cache.retrieveMode");
        return cacheRetrieveMode == null ? (CacheRetrieveMode)settings.get("jakarta.persistence.cache.retrieveMode") : cacheRetrieveMode;
    }

    private static CacheStoreMode determineCacheStoreMode(Map<String, Object> settings) {
        CacheStoreMode cacheStoreMode = (CacheStoreMode)settings.get("javax.persistence.cache.storeMode");
        return cacheStoreMode == null ? (CacheStoreMode)settings.get("jakarta.persistence.cache.storeMode") : cacheStoreMode;
    }

    private void checkTransactionNeededForUpdateOperation() {
        this.checkTransactionNeededForUpdateOperation("No active transaction");
    }

    @Override
    public Object find(String entityName, Object primaryKey) {
        IdentifierLoadAccess loadAccess = this.byId(entityName);
        return ((IdentifierLoadAccessImpl)loadAccess).load(primaryKey);
    }

    @Override
    public Object find(String entityName, Object primaryKey, FindOption ... options) {
        IdentifierLoadAccess loadAccess = this.byId(entityName);
        this.setLoadAccessOptions(options, (IdentifierLoadAccessImpl)loadAccess);
        return ((IdentifierLoadAccessImpl)loadAccess).load(primaryKey);
    }

    @Override
    public <T> T getReference(Class<T> entityClass, Object id) {
        this.checkOpen();
        try {
            return ((IdentifierLoadAccessImpl)this.byId((Class)entityClass)).getReference(id);
        }
        catch (ClassCastException | MappingException | TypeMismatchException e) {
            throw this.getExceptionConverter().convert(new IllegalArgumentException(((Throwable)e).getMessage(), (Throwable)e));
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public Object getReference(String entityName, Object id) {
        this.checkOpen();
        try {
            return ((IdentifierLoadAccessImpl)this.byId(entityName)).getReference(id);
        }
        catch (ClassCastException | MappingException | TypeMismatchException e) {
            throw this.getExceptionConverter().convert(new IllegalArgumentException(((Throwable)e).getMessage(), (Throwable)e));
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    public void lock(Object entity, LockModeType lockModeType) {
        this.lock(entity, LockModeTypeHelper.getLockMode(lockModeType));
    }

    public void lock(Object entity, LockModeType lockModeType, Map<String, Object> properties) {
        this.lock(entity, this.buildLockOptions(LockModeTypeHelper.getLockMode(lockModeType), properties));
    }

    public void lock(Object entity, LockModeType lockModeType, LockOption ... options) {
        this.lock(entity, this.buildLockOptions(LockModeTypeHelper.getLockMode(lockModeType), options));
    }

    private LockOptions buildLockOptions(LockMode lockMode, LockOption[] options) {
        LockOptions lockOptions = this.copySessionLockOptions();
        lockOptions.setLockMode(lockMode);
        for (LockOption option : options) {
            if (option instanceof PessimisticLockScope) {
                PessimisticLockScope lockScope = (PessimisticLockScope)option;
                lockOptions.setLockScope(lockScope);
                continue;
            }
            if (!(option instanceof Timeout)) continue;
            Timeout timeout = (Timeout)option;
            lockOptions.setTimeOut(timeout.milliseconds());
        }
        return lockOptions;
    }

    private LockOptions buildLockOptions(LockMode lockMode, Map<String, Object> properties) {
        LockOptions lockOptions = this.copySessionLockOptions();
        lockOptions.setLockMode(lockMode);
        if (properties != null) {
            LockOptionsHelper.applyPropertiesToLockOptions(properties, () -> lockOptions);
        }
        return lockOptions;
    }

    private LockOptions copySessionLockOptions() {
        LockOptions copiedLockOptions = new LockOptions();
        if (this.lockOptions != null) {
            LockOptions.copy(this.lockOptions, copiedLockOptions);
        }
        return copiedLockOptions;
    }

    public void refresh(Object entity, LockModeType lockModeType) {
        this.refresh(entity, LockModeTypeHelper.getLockMode(lockModeType));
    }

    public void refresh(Object entity, Map<String, Object> properties) {
        this.refresh(entity, null, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity, LockModeType lockModeType, Map<String, Object> properties) {
        this.checkOpen();
        CacheMode previousCacheMode = this.getCacheMode();
        CacheMode refreshCacheMode = this.determineAppropriateLocalCacheMode(properties);
        try {
            this.setCacheMode(refreshCacheMode);
            if (lockModeType == null) {
                this.refresh(entity);
            } else {
                this.refresh(entity, this.buildLockOptions(LockModeTypeHelper.getLockMode(lockModeType), properties));
            }
        }
        finally {
            this.setCacheMode(previousCacheMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity, RefreshOption ... options) {
        CacheStoreMode storeMode = this.getCacheStoreMode();
        LockOptions lockOptions = this.copySessionLockOptions();
        for (RefreshOption option : options) {
            if (option instanceof CacheStoreMode) {
                CacheStoreMode cacheStoreMode;
                storeMode = cacheStoreMode = (CacheStoreMode)option;
                continue;
            }
            if (option instanceof LockModeType) {
                LockModeType lockModeType = (LockModeType)option;
                lockOptions.setLockMode(LockModeTypeHelper.getLockMode(lockModeType));
                continue;
            }
            if (option instanceof LockMode) {
                LockMode lockMode = (LockMode)option;
                lockOptions.setLockMode(lockMode);
                continue;
            }
            if (option instanceof LockOptions) {
                LockOptions lockOpts;
                lockOptions = lockOpts = (LockOptions)option;
                continue;
            }
            if (option instanceof PessimisticLockScope) {
                PessimisticLockScope pessimisticLockScope = (PessimisticLockScope)option;
                lockOptions.setLockScope(pessimisticLockScope);
                continue;
            }
            if (!(option instanceof Timeout)) continue;
            Timeout timeout = (Timeout)option;
            lockOptions.setTimeOut(timeout.milliseconds());
        }
        CacheMode previousCacheMode = this.getCacheMode();
        if (storeMode != null) {
            this.setCacheStoreMode(storeMode);
        }
        try {
            this.refresh(entity, lockOptions);
        }
        finally {
            this.setCacheMode(previousCacheMode);
        }
    }

    @Override
    public void detach(Object entity) {
        this.checkOpen();
        try {
            this.evict(entity);
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    public LockModeType getLockMode(Object entity) {
        this.checkOpen();
        if (!this.isTransactionInProgress()) {
            throw new TransactionRequiredException("No active transaction");
        }
        if (entity == null) {
            throw new IllegalArgumentException("Entity may not be null");
        }
        if (!this.contains(entity)) {
            throw this.getExceptionConverter().convert(new IllegalArgumentException("Given entity is not associated with the persistence context"));
        }
        return LockModeTypeHelper.getLockModeType(this.getCurrentLockMode(entity));
    }

    @Override
    public void setProperty(String propertyName, Object value) {
        this.checkOpen();
        if (!(value instanceof Serializable)) {
            log.warnf("Property '%s' is not serializable, value won't be set", propertyName);
            return;
        }
        if (propertyName == null) {
            log.warn("Property having key null is illegal, value won't be set");
            return;
        }
        if (this.properties == null) {
            this.properties = this.computeCurrentProperties();
        }
        this.properties.put(propertyName, value);
        this.interpretProperty(propertyName, value);
    }

    private void interpretProperty(String propertyName, Object value) {
        switch (propertyName) {
            case "org.hibernate.flushMode": {
                this.setHibernateFlushMode(ConfigurationHelper.getFlushMode(value, FlushMode.AUTO));
                break;
            }
            case "javax.persistence.lock.scope": 
            case "jakarta.persistence.lock.scope": {
                this.properties.put("javax.persistence.lock.scope", value);
                this.properties.put("jakarta.persistence.lock.scope", value);
                LockOptionsHelper.applyPropertiesToLockOptions(this.properties, this::getLockOptionsForWrite);
                break;
            }
            case "javax.persistence.lock.timeout": 
            case "jakarta.persistence.lock.timeout": {
                this.properties.put("javax.persistence.lock.timeout", value);
                this.properties.put("jakarta.persistence.lock.timeout", value);
                LockOptionsHelper.applyPropertiesToLockOptions(this.properties, this::getLockOptionsForWrite);
                break;
            }
            case "javax.persistence.cache.retrieveMode": 
            case "jakarta.persistence.cache.retrieveMode": {
                this.properties.put("javax.persistence.cache.retrieveMode", value);
                this.properties.put("jakarta.persistence.cache.retrieveMode", value);
                this.setCacheMode(CacheModeHelper.interpretCacheMode(SessionImpl.determineCacheStoreMode(this.properties), (CacheRetrieveMode)value));
                break;
            }
            case "javax.persistence.cache.storeMode": 
            case "jakarta.persistence.cache.storeMode": {
                this.properties.put("javax.persistence.cache.storeMode", value);
                this.properties.put("jakarta.persistence.cache.storeMode", value);
                this.setCacheMode(CacheModeHelper.interpretCacheMode((CacheStoreMode)value, SessionImpl.determineCacheRetrieveMode(this.properties)));
                break;
            }
            case "hibernate.criteria.copy_tree": {
                this.setCriteriaCopyTreeEnabled(Boolean.parseBoolean(value.toString()));
                break;
            }
            case "org.hibernate.fetchProfile": {
                this.enableFetchProfile((String)value);
                break;
            }
            case "hibernate.use_subselect_fetch": 
            case "org.hibernate.enableSubselectFetch": {
                this.setSubselectFetchingEnabled(Boolean.parseBoolean(value.toString()));
                break;
            }
            case "hibernate.default_batch_fetch_size": 
            case "org.hibernate.batchFetchSize": {
                this.setFetchBatchSize(Integer.parseInt(value.toString()));
                break;
            }
            case "hibernate.jdbc.batch_size": 
            case "org.hibernate.jdbcBatchSize": {
                this.setJdbcBatchSize(Integer.parseInt(value.toString()));
            }
        }
    }

    private Map<String, Object> computeCurrentProperties() {
        HashMap<String, Object> map = new HashMap<String, Object>(this.getDefaultProperties());
        map.put("org.hibernate.flushMode", (Object)this.getHibernateFlushMode());
        return map;
    }

    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = this.computeCurrentProperties();
        }
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public ProcedureCall createNamedStoredProcedureQuery(String name) {
        this.checkOpen();
        try {
            NamedCallableQueryMemento memento = this.getFactory().getQueryEngine().getNamedObjectRepository().getCallableQueryMemento(name);
            if (memento == null) {
                throw new IllegalArgumentException("No @NamedStoredProcedureQuery was found with that name : " + name);
            }
            return memento.makeProcedureCall(this);
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public ProcedureCall createStoredProcedureQuery(String procedureName) {
        try {
            return this.createStoredProcedureCall(procedureName);
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    public ProcedureCall createStoredProcedureQuery(String procedureName, Class ... resultClasses) {
        try {
            return this.createStoredProcedureCall(procedureName, resultClasses);
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public ProcedureCall createStoredProcedureQuery(String procedureName, String ... resultSetMappings) {
        this.checkOpen();
        try {
            try {
                return this.createStoredProcedureCall(procedureName, resultSetMappings);
            }
            catch (UnknownSqlResultSetMappingException e) {
                throw new IllegalArgumentException(e.getMessage(), (Throwable)((Object)e));
            }
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public <T> T unwrap(Class<T> type) {
        this.checkOpen();
        if (type.isInstance(this)) {
            return type.cast(this);
        }
        if (type.isInstance(this.persistenceContext)) {
            return type.cast(this.persistenceContext);
        }
        throw new PersistenceException("Hibernate cannot unwrap '" + this.getClass().getName() + "' as '" + type.getName() + "'");
    }

    public Object getDelegate() {
        this.checkOpen();
        return this;
    }

    public SessionFactoryImplementor getEntityManagerFactory() {
        this.checkOpen();
        return this.getFactory();
    }

    public Metamodel getMetamodel() {
        this.checkOpen();
        return this.getFactory().getJpaMetamodel();
    }

    @Override
    public Collection<?> getManagedEntities() {
        return this.persistenceContext.getEntityHoldersByKey().values().stream().map(EntityHolder::getManagedObject).toList();
    }

    @Override
    public Collection<?> getManagedEntities(String entityName) {
        return this.persistenceContext.getEntityHoldersByKey().entrySet().stream().filter(entry -> ((EntityKey)entry.getKey()).getEntityName().equals(entityName)).map(entry -> ((EntityHolder)entry.getValue()).getManagedObject()).toList();
    }

    @Override
    public <E> Collection<E> getManagedEntities(Class<E> entityType) {
        return this.persistenceContext.getEntityHoldersByKey().entrySet().stream().filter(entry -> ((EntityKey)entry.getKey()).getPersister().getMappedClass().equals(entityType)).map(entry -> ((EntityHolder)entry.getValue()).getManagedObject()).toList();
    }

    @Override
    public <E> Collection<E> getManagedEntities(EntityType<E> entityType) {
        String entityName = ((EntityDomainType)entityType).getHibernateEntityName();
        return this.persistenceContext.getEntityHoldersByKey().entrySet().stream().filter(entry -> ((EntityKey)entry.getKey()).getEntityName().equals(entityName)).map(entry -> ((EntityHolder)entry.getValue()).getManagedObject()).toList();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (log.isTraceEnabled()) {
            log.tracef("Serializing Session [%s]", this.getSessionIdentifier());
        }
        oos.defaultWriteObject();
        PersistenceContexts.serialize(this.persistenceContext, oos);
        this.actionQueue.serialize(oos);
        oos.writeObject(this.loadQueryInfluencers);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException, SQLException {
        if (log.isTraceEnabled()) {
            log.tracef("Deserializing Session [%s]", this.getSessionIdentifier());
        }
        ois.defaultReadObject();
        this.persistenceContext = PersistenceContexts.deserialize(ois, this);
        this.actionQueue = ActionQueue.deserialize(ois, this);
        this.loadQueryInfluencers = (LoadQueryInfluencers)ois.readObject();
        for (String filterName : this.loadQueryInfluencers.getEnabledFilterNames()) {
            ((FilterImpl)this.loadQueryInfluencers.getEnabledFilter(filterName)).afterDeserialize(this.getFactory());
        }
        this.eventListenerGroups = this.getFactory().getEventListenerGroups();
    }

    protected Boolean getReadOnlyFromLoadQueryInfluencers() {
        return this.loadQueryInfluencers != null ? this.loadQueryInfluencers.getReadOnly() : null;
    }

    private static class SharedSessionBuilderImpl
    extends SessionFactoryImpl.SessionBuilderImpl
    implements SharedSessionBuilder,
    SharedSessionCreationOptions {
        private final SessionImpl session;
        private boolean shareTransactionContext;
        private boolean tenantIdChanged;

        private SharedSessionBuilderImpl(SessionImpl session) {
            super((SessionFactoryImpl)session.getFactory());
            this.session = session;
            super.tenantIdentifier(session.getTenantIdentifierValue());
            super.identifierRollback(session.isIdentifierRollbackEnabled());
        }

        @Override
        public SessionImpl openSession() {
            if (this.session.getSessionFactoryOptions().isMultiTenancyEnabled() && this.tenantIdChanged && this.shareTransactionContext) {
                throw new SessionException("Cannot redefine the tenant identifier on a child session if the connection is reused");
            }
            return super.openSession();
        }

        @Override
        @Deprecated(forRemoval=true)
        public SharedSessionBuilderImpl tenantIdentifier(String tenantIdentifier) {
            super.tenantIdentifier(tenantIdentifier);
            this.tenantIdChanged = true;
            return this;
        }

        @Override
        public SharedSessionBuilderImpl tenantIdentifier(Object tenantIdentifier) {
            super.tenantIdentifier(tenantIdentifier);
            this.tenantIdChanged = true;
            return this;
        }

        @Override
        public SharedSessionBuilderImpl interceptor() {
            super.interceptor(this.session.getInterceptor());
            return this;
        }

        @Override
        public SharedSessionBuilderImpl interceptor(Interceptor interceptor) {
            super.interceptor(interceptor);
            return this;
        }

        @Override
        public SharedSessionBuilderImpl noInterceptor() {
            super.noInterceptor();
            return this;
        }

        @Override
        public SharedSessionBuilderImpl connection() {
            this.shareTransactionContext = true;
            return this;
        }

        @Override
        public SharedSessionBuilderImpl connection(Connection connection) {
            super.connection(connection);
            return this;
        }

        private PhysicalConnectionHandlingMode getConnectionHandlingMode() {
            return this.session.getJdbcCoordinator().getLogicalConnection().getConnectionHandlingMode();
        }

        @Override
        @Deprecated(since="6.0")
        public SharedSessionBuilderImpl connectionReleaseMode() {
            PhysicalConnectionHandlingMode handlingMode = PhysicalConnectionHandlingMode.interpret(ConnectionAcquisitionMode.AS_NEEDED, this.getConnectionHandlingMode().getReleaseMode());
            this.connectionHandlingMode(handlingMode);
            return this;
        }

        @Override
        public SharedSessionBuilderImpl connectionHandlingMode() {
            this.connectionHandlingMode(this.getConnectionHandlingMode());
            return this;
        }

        @Override
        public SharedSessionBuilderImpl autoJoinTransactions() {
            super.autoJoinTransactions(this.session.shouldAutoJoinTransaction());
            return this;
        }

        @Override
        public SharedSessionBuilderImpl autoJoinTransactions(boolean autoJoinTransactions) {
            super.autoJoinTransactions(autoJoinTransactions);
            return this;
        }

        @Override
        public SharedSessionBuilderImpl autoClose(boolean autoClose) {
            super.autoClose(autoClose);
            return this;
        }

        @Override
        public SharedSessionBuilderImpl flushMode() {
            this.flushMode(this.session.getHibernateFlushMode());
            return this;
        }

        @Override
        public SharedSessionBuilderImpl autoClose() {
            this.autoClose(this.session.isAutoCloseSessionEnabled());
            return this;
        }

        @Override
        public SharedSessionBuilderImpl identifierRollback(boolean identifierRollback) {
            super.identifierRollback(identifierRollback);
            return this;
        }

        @Override
        public SharedSessionBuilderImpl jdbcTimeZone(TimeZone timeZone) {
            super.jdbcTimeZone(timeZone);
            return this;
        }

        @Override
        public SharedSessionBuilderImpl clearEventListeners() {
            super.clearEventListeners();
            return this;
        }

        @Override
        public SharedSessionBuilderImpl flushMode(FlushMode flushMode) {
            super.flushMode(flushMode);
            return this;
        }

        @Override
        public SharedSessionBuilderImpl autoClear(boolean autoClear) {
            super.autoClear(autoClear);
            return this;
        }

        @Override
        @Deprecated
        public SharedSessionBuilderImpl statementInspector(StatementInspector statementInspector) {
            super.statementInspector(statementInspector);
            return this;
        }

        @Override
        public SessionBuilder statementInspector(UnaryOperator<String> operator) {
            super.statementInspector(operator);
            return this;
        }

        @Override
        @Deprecated
        public SharedSessionBuilderImpl connectionHandlingMode(PhysicalConnectionHandlingMode connectionHandlingMode) {
            super.connectionHandlingMode(connectionHandlingMode);
            return this;
        }

        @Override
        @Deprecated
        public SharedSessionBuilderImpl connectionHandling(ConnectionAcquisitionMode acquisitionMode, ConnectionReleaseMode releaseMode) {
            super.connectionHandling(acquisitionMode, releaseMode);
            return this;
        }

        @Override
        public SharedSessionBuilderImpl eventListeners(SessionEventListener ... listeners) {
            super.eventListeners(listeners);
            return this;
        }

        @Override
        public boolean isTransactionCoordinatorShared() {
            return this.shareTransactionContext;
        }

        @Override
        public TransactionCoordinator getTransactionCoordinator() {
            return this.shareTransactionContext ? this.session.getTransactionCoordinator() : null;
        }

        @Override
        public JdbcCoordinator getJdbcCoordinator() {
            return this.shareTransactionContext ? this.session.getJdbcCoordinator() : null;
        }

        @Override
        public Transaction getTransaction() {
            return this.shareTransactionContext ? this.session.getCurrentTransaction() : null;
        }

        @Override
        public ActionQueue.TransactionCompletionProcesses getTransactionCompletionProcesses() {
            return this.shareTransactionContext ? this.session.getActionQueue().getTransactionCompletionProcesses() : null;
        }
    }
}

