/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.generator.internal;

import java.util.EnumSet;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.EventType;
import org.hibernate.generator.EventTypeSets;
import org.hibernate.metamodel.mapping.EntityVersionMapping;

public class VersionGeneration
implements BeforeExecutionGenerator {
    private final EntityVersionMapping versionMapping;

    public VersionGeneration(EntityVersionMapping versionMapping) {
        this.versionMapping = versionMapping;
    }

    @Override
    public EnumSet<EventType> getEventTypes() {
        return EventTypeSets.ALL;
    }

    @Override
    public Object generate(SharedSessionContractImplementor session, Object owner, Object current, EventType eventType) {
        return eventType == EventType.INSERT ? Versioning.seed(this.versionMapping, session) : Versioning.increment(current, this.versionMapping, session);
    }
}

