/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.util.completer;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.container.CommandContainer;
import org.aesh.command.impl.container.AeshCommandContainerBuilder;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.util.completer.FileCompleterGenerator;

@CommandDefinition(name="completer", description="Generates a complete file for a command for posix systems")
public class CompleterCommand
implements Command<CommandInvocation> {
    @Option(hasValue=false)
    private boolean help;
    @Argument(required=true, description="Command class name")
    private String command;

    @Override
    public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
        if (this.help) {
            commandInvocation.println(commandInvocation.getHelpInfo("completer"));
            return CommandResult.SUCCESS;
        }
        Class<Command<CommandInvocation>> clazz = this.loadCommand(this.command);
        if (clazz != null) {
            AeshCommandContainerBuilder builder = new AeshCommandContainerBuilder();
            try {
                CommandContainer container = builder.create(clazz);
                FileCompleterGenerator completerGenerator = new FileCompleterGenerator();
                Files.write(Paths.get(container.getParser().getProcessedCommand().name().toLowerCase() + "_complete.bash", new String[0]), completerGenerator.generateCompleterFile(container.getParser()).getBytes(), StandardOpenOption.CREATE);
            }
            catch (IOException | CommandLineParserException e) {
                e.printStackTrace();
            }
        } else {
            commandInvocation.println("Could not load command: " + this.command);
        }
        return CommandResult.SUCCESS;
    }

    private Class<Command<CommandInvocation>> loadCommand(String commandName) {
        try {
            return Class.forName(commandName);
        }
        catch (ClassCastException | ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

