/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.ArrayList;
import twitter4j.HttpResponse;
import twitter4j.ParseUtil;
import twitter4j.RateLimitStatusJSONImpl;
import twitter4j.TwitterResponse;
import twitter4j.v1.RateLimitStatus;
import twitter4j.v1.ResponseList;

class ResponseListImpl<T>
extends ArrayList<T>
implements ResponseList<T> {
    private static final long serialVersionUID = 9105950888010803544L;
    private transient RateLimitStatus rateLimitStatus = null;
    private transient TwitterResponse.AccessLevel accessLevel;

    ResponseListImpl(HttpResponse res) {
        this.init(res);
    }

    ResponseListImpl(int size, HttpResponse res) {
        super(size);
        this.init(res);
    }

    ResponseListImpl(RateLimitStatus rateLimitStatus, TwitterResponse.AccessLevel accessLevel) {
        this.rateLimitStatus = rateLimitStatus;
        this.accessLevel = accessLevel;
    }

    private void init(HttpResponse res) {
        this.rateLimitStatus = RateLimitStatusJSONImpl.createFromResponseHeader(res);
        this.accessLevel = ParseUtil.toAccessLevel(res);
    }

    @Override
    public RateLimitStatus getRateLimitStatus() {
        return this.rateLimitStatus;
    }

    @Override
    public TwitterResponse.AccessLevel getAccessLevel() {
        return this.accessLevel;
    }
}

