/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.io.Flushable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Permission;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.LoggingPermission;
import org.jboss.logmanager.AtomicArray;
import org.jboss.logmanager.ExtFormatter;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.errormanager.OnlyOnceErrorManager;

public abstract class ExtHandler
extends Handler
implements AutoCloseable,
Flushable {
    private static final ErrorManager DEFAULT_ERROR_MANAGER = new OnlyOnceErrorManager();
    private static final Permission CONTROL_PERMISSION = new LoggingPermission("control", null);
    protected final ReentrantLock lock = new ReentrantLock();
    private volatile Filter filter;
    private volatile Formatter formatter;
    private volatile Level level = Level.ALL;
    private volatile ErrorManager errorManager;
    private volatile boolean autoFlush = true;
    private volatile boolean enabled = true;
    private volatile boolean closeChildren;
    private volatile Charset charset = StandardCharsets.UTF_8;
    protected volatile Handler[] handlers;
    protected static final AtomicArray<ExtHandler, Handler> handlersUpdater = AtomicArray.create(AtomicReferenceFieldUpdater.newUpdater(ExtHandler.class, Handler[].class, "handlers"), Handler.class);

    protected ExtHandler() {
        handlersUpdater.clear(this);
        this.closeChildren = true;
        this.errorManager = DEFAULT_ERROR_MANAGER;
    }

    @Override
    public void publish(LogRecord record) {
        if (this.enabled && record != null && this.isLoggable(record)) {
            this.doPublish(ExtLogRecord.wrap(record));
        }
    }

    public void publish(ExtLogRecord record) {
        if (this.enabled && record != null && this.isLoggable(record)) {
            try {
                this.doPublish(record);
            }
            catch (Exception e) {
                this.reportError("Handler publication threw an exception", e, 1);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void publishToNestedHandlers(ExtLogRecord record) {
        if (record != null) {
            ExtLogRecord oldRecord = null;
            for (Handler handler : this.getHandlers()) {
                try {
                    if (handler == null) continue;
                    if (handler instanceof ExtHandler || handler.getFormatter() instanceof ExtFormatter) {
                        handler.publish(record);
                        continue;
                    }
                    if (oldRecord == null) {
                        if (record.getFormatStyle() == ExtLogRecord.FormatStyle.PRINTF) {
                            oldRecord = new ExtLogRecord(record);
                            oldRecord.setMessage(record.getFormattedMessage(), ExtLogRecord.FormatStyle.NO_FORMAT);
                            oldRecord.setParameters(null);
                        } else {
                            oldRecord = record;
                        }
                    }
                    handler.publish(oldRecord);
                }
                catch (Exception e) {
                    ExtHandler.reportError(handler, "Nested handler publication threw an exception", e, 1);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    protected void doPublish(ExtLogRecord record) {
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void addHandler(Handler handler) throws SecurityException {
        ExtHandler.checkAccess();
        if (handler == null) {
            throw new NullPointerException("handler is null");
        }
        handlersUpdater.add(this, handler);
    }

    public void removeHandler(Handler handler) throws SecurityException {
        ExtHandler.checkAccess();
        if (handler == null) {
            return;
        }
        handlersUpdater.remove(this, handler, true);
    }

    public Handler[] getHandlers() {
        Handler[] handlers = this.handlers;
        return handlers.length > 0 ? (Handler[])handlers.clone() : handlers;
    }

    public Handler[] clearHandlers() throws SecurityException {
        ExtHandler.checkAccess();
        Handler[] handlers = this.handlers;
        handlersUpdater.clear(this);
        return handlers.length > 0 ? (Handler[])handlers.clone() : handlers;
    }

    public Handler[] setHandlers(Handler[] newHandlers) throws SecurityException {
        if (newHandlers == null) {
            throw new IllegalArgumentException("newHandlers is null");
        }
        if (newHandlers.length == 0) {
            return this.clearHandlers();
        }
        ExtHandler.checkAccess();
        Handler[] handlers = handlersUpdater.getAndSet(this, (Handler[])newHandlers);
        return handlers.length > 0 ? (Handler[])handlers.clone() : handlers;
    }

    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    public void setAutoFlush(boolean autoFlush) throws SecurityException {
        ExtHandler.checkAccess();
        this.autoFlush = autoFlush;
        if (autoFlush) {
            this.flush();
        }
    }

    public final void setEnabled(boolean enabled) throws SecurityException {
        ExtHandler.checkAccess();
        this.enabled = enabled;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public boolean isCloseChildren() {
        return this.closeChildren;
    }

    public void setCloseChildren(boolean closeChildren) {
        ExtHandler.checkAccess();
        this.closeChildren = closeChildren;
    }

    protected static void checkAccess() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CONTROL_PERMISSION);
        }
    }

    @Deprecated
    protected static void checkAccess(ExtHandler handler) throws SecurityException {
        ExtHandler.checkAccess();
    }

    @Override
    public void flush() {
        for (Handler handler : this.handlers) {
            try {
                handler.flush();
            }
            catch (Exception ex) {
                this.reportError("Failed to flush child handler", ex, 2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void close() throws SecurityException {
        ExtHandler.checkAccess();
        if (this.closeChildren) {
            for (Handler handler : this.handlers) {
                try {
                    handler.close();
                }
                catch (Exception ex) {
                    this.reportError("Failed to close child handler", ex, 3);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void setFormatter(Formatter newFormatter) throws SecurityException {
        ExtHandler.checkAccess();
        Objects.requireNonNull(newFormatter);
        this.lock.lock();
        try {
            this.formatter = newFormatter;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Formatter getFormatter() {
        return this.formatter;
    }

    @Override
    public void setFilter(Filter newFilter) throws SecurityException {
        ExtHandler.checkAccess();
        this.lock.lock();
        try {
            this.filter = newFilter;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setEncoding(String encoding) throws SecurityException, UnsupportedEncodingException {
        if (encoding != null) {
            try {
                this.setCharset(Charset.forName(encoding));
            }
            catch (IllegalArgumentException e) {
                UnsupportedEncodingException e2 = new UnsupportedEncodingException("Unable to set encoding to \"" + encoding + "\"");
                e2.initCause(e);
                throw e2;
            }
        } else {
            this.setCharset(StandardCharsets.UTF_8);
        }
    }

    @Override
    public String getEncoding() {
        return this.getCharset().name();
    }

    public void setCharset(Charset charset) throws SecurityException {
        ExtHandler.checkAccess();
        this.setCharsetPrivate(charset);
    }

    protected void setCharsetPrivate(Charset charset) throws SecurityException {
        Objects.requireNonNull(charset, "charset");
        this.lock.lock();
        try {
            this.charset = charset;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public void setErrorManager(ErrorManager em) {
        Objects.requireNonNull(em);
        ExtHandler.checkAccess();
        this.lock.lock();
        try {
            this.errorManager = em;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public ErrorManager getErrorManager() {
        return this.errorManager;
    }

    @Override
    public void setLevel(Level newLevel) throws SecurityException {
        Objects.requireNonNull(newLevel);
        ExtHandler.checkAccess();
        this.lock.lock();
        try {
            this.level = newLevel;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    public boolean isCallerCalculationRequired() {
        Formatter formatter = this.getFormatter();
        if (ExtHandler.formatterRequiresCallerCalculation(formatter)) {
            return true;
        }
        for (Handler handler : this.getHandlers()) {
            if (!(handler instanceof ExtHandler ? ((ExtHandler)handler).isCallerCalculationRequired() : ExtHandler.formatterRequiresCallerCalculation(formatter = handler.getFormatter()))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void reportError(String msg, Exception ex, int code) {
        ErrorManager errorManager = this.errorManager;
        errorManager.error(msg, ex, code);
    }

    public static void reportError(Handler handler, String msg, Exception ex, int code) {
        ErrorManager errorManager;
        if (handler != null && (errorManager = handler.getErrorManager()) != null) {
            try {
                errorManager.error(msg, ex, code);
            }
            catch (Exception ex2) {
                System.err.println("Handler.reportError caught:");
                ex2.printStackTrace();
            }
        }
    }

    private static boolean formatterRequiresCallerCalculation(Formatter formatter) {
        return formatter != null && (!(formatter instanceof ExtFormatter) || ((ExtFormatter)formatter).isCallerCalculationRequired());
    }
}

