/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.usertx;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.logging.Logger;
import org.jboss.tm.usertx.UserTransactionListener;
import org.jboss.tm.usertx.UserTransactionProvider;

public class UserTransactionRegistry {
    private static final Logger log = Logger.getLogger(UserTransactionRegistry.class);
    private Collection<UserTransactionProvider> providers = new CopyOnWriteArraySet<UserTransactionProvider>();
    private Collection<UserTransactionListener> listeners = new CopyOnWriteArraySet<UserTransactionListener>();

    public void addListener(UserTransactionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        this.listeners.add(listener);
        log.debug((Object)(this + " addListener " + listener));
    }

    public void removeListener(UserTransactionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        this.listeners.remove(listener);
        log.debug((Object)(this + " removeListener " + listener));
    }

    public void addProvider(UserTransactionProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Null provider");
        }
        provider.setTransactionRegistry(this);
        this.providers.add(provider);
        log.debug((Object)(this + " addProvider " + provider));
    }

    public void removeProvider(UserTransactionProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Null provider");
        }
        if (this.providers.remove(provider)) {
            provider.setTransactionRegistry(null);
            log.debug((Object)(this + " removeProvider " + provider));
        }
    }

    public void userTransactionStarted() {
        if (!this.listeners.isEmpty()) {
            for (UserTransactionListener listener : this.listeners) {
                if (listener == null) continue;
                try {
                    listener.userTransactionStarted();
                }
                catch (Throwable t) {
                    log.warn((Object)("Error notifying listener " + listener + " of userTransactionStarted"), t);
                }
            }
        }
    }
}

