/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.index.chain.MonotoneChain;
import org.locationtech.jts.index.chain.MonotoneChainBuilder;
import org.locationtech.jts.index.chain.MonotoneChainSelectAction;
import org.locationtech.jts.index.strtree.STRtree;

class SegmentMCIndex {
    private STRtree index;

    public SegmentMCIndex(Coordinate[] segs) {
        this.index = this.buildIndex(segs);
    }

    private STRtree buildIndex(Coordinate[] segs) {
        STRtree index = new STRtree();
        List segChains = MonotoneChainBuilder.getChains(segs, segs);
        for (MonotoneChain mc : segChains) {
            index.insert(mc.getEnvelope(), (Object)mc);
        }
        return index;
    }

    public void query(final Envelope env, final MonotoneChainSelectAction action) {
        this.index.query(env, new ItemVisitor(){

            @Override
            public void visitItem(Object item) {
                MonotoneChain testChain = (MonotoneChain)item;
                testChain.select(env, action);
            }
        });
    }
}

