/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize;

import java.util.Random;
import javajs.util.V3d;

public class Util {
    public static final double RAD_TO_DEG = 57.29577951308232;
    public static final double DEG_TO_RAD = Math.PI / 180;
    static final double max_squarable_double = 1.0E150;
    static final double min_squarable_double = 1.0E-150;

    public static void sub(double[] a, double[] b, V3d result) {
        result.set(a[0] - b[0], a[1] - b[1], a[2] - b[2]);
    }

    public static void putCoord(V3d v, double[] c) {
        c[0] = v.x;
        c[1] = v.y;
        c[2] = v.z;
    }

    public static double distance2(double[] a, double[] b) {
        double dx = a[0] - b[0];
        double dy = a[1] - b[1];
        double dz = a[2] - b[2];
        return dx * dx + dy * dy + dz * dz;
    }

    public static double distance2V(V3d a, V3d b) {
        double dx = a.x - b.x;
        double dy = a.y - b.y;
        double dz = a.z - b.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public static double getAngleRadiansABC(double[] a, double[] b, double[] c) {
        double ab2 = Util.distance2(a, b);
        double bc2 = Util.distance2(b, c);
        double ac2 = Util.distance2(a, c);
        return Util.isNearZero2(ab2, 0.001) || Util.isNearZero2(bc2, 0.001) ? 0.0 : Math.acos(Math.min(Math.max((ab2 + bc2 - ac2) / 2.0 / Math.sqrt(ab2 * bc2), -1.0), 1.0));
    }

    public static boolean isApprox(V3d a, V3d b, double precision) {
        return Util.distance2V(a, b) <= precision * precision * Math.min(a.lengthSquared(), b.lengthSquared());
    }

    public static boolean canBeSquared(double x) {
        double d;
        if (x == 0.0) {
            return true;
        }
        x = Math.abs(x);
        return d < 1.0E150 && x > 1.0E-150;
    }

    public static boolean isNegligible(double a, double b) {
        return Util.isNegligible3(a, b, 1.0E-11);
    }

    public static boolean isFinite(double a) {
        return !Double.isInfinite(a) && !Double.isNaN(a);
    }

    public static boolean isNegligible3(double a, double b, double precision) {
        return Math.abs(a) <= precision * Math.abs(b);
    }

    public static boolean isNear(double a, double b) {
        return Util.isNear3(a, b, 2.0E-6);
    }

    public static boolean isNear3(double a, double b, double epsilon) {
        return Math.abs(a - b) < epsilon;
    }

    public static boolean isNearZero(double a) {
        return Util.isNearZero2(a, 2.0E-6);
    }

    public static boolean isNearZero2(double a, double epsilon) {
        return Math.abs(a) < epsilon;
    }

    public static boolean canBeNormalized(V3d a) {
        if (a.x == 0.0 && a.y == 0.0 && a.z == 0.0) {
            return false;
        }
        return Util.canBeSquared(a.x) && Util.canBeSquared(a.y) && Util.canBeSquared(a.z);
    }

    public static double pointPlaneAngleRadians(V3d a, V3d b, V3d c, V3d d, V3d v1, V3d v2, V3d norm, boolean fixTheta) {
        v1.sub2(b, c);
        v2.sub2(b, d);
        norm.cross(v1, v2);
        v2.add(v1);
        v1.sub2(b, a);
        double angleA_CD = fixTheta ? Util.vectorAngleRadians(v2, v1) : Math.PI;
        double angleNorm = Util.vectorAngleRadians(norm, v1);
        if (angleNorm > 1.5707963267948966) {
            angleNorm = Math.PI - angleNorm;
        }
        double val = 1.5707963267948966 + (angleA_CD > 1.5707963267948966 ? -angleNorm : angleNorm);
        return val;
    }

    private static double vectorAngleRadians(V3d v1, V3d v2) {
        double l1 = v1.length();
        double l2 = v2.length();
        return Util.isNearZero(l1) || Util.isNearZero(l2) ? 0.0 : Math.acos(v1.dot(v2) / (l1 * l2));
    }

    public static double getTorsionAngleRadians(double[] a, double[] b, double[] c, double[] d, V3d r1, V3d r2, V3d r3) {
        Util.sub(b, a, r1);
        Util.sub(c, b, r2);
        r2.normalize();
        r1.cross(r1, r2);
        Util.sub(d, c, r3);
        r3.cross(r2, r3);
        double p1dotp2 = r1.dot(r3);
        r1.cross(r3, r1);
        double theta = Math.atan2(-r2.dot(r1), p1dotp2);
        return theta;
    }

    public static double restorativeForceAndDistance(V3d a, V3d b, V3d vab) {
        vab.sub2(a, b);
        double rab = vab.length();
        if (rab < 0.1) {
            Util.randomizeUnitVector(vab);
            rab = 0.1;
        }
        vab.normalize();
        a.setT(vab);
        a.scale(-1.0);
        b.setT(vab);
        return rab;
    }

    private static void randomizeUnitVector(V3d v) {
        double l;
        Random ptr = new Random();
        do {
            v.set((double)ptr.nextFloat() - 0.5, (double)ptr.nextFloat() - 0.5, (double)ptr.nextFloat() - 0.5);
        } while ((l = v.lengthSquared()) > 1.0 || l < 1.0E-4);
        v.normalize();
    }

    public static double restorativeForceAndAngleRadians(V3d i, V3d j, V3d k) {
        double theta;
        i.sub(j);
        k.sub(j);
        double length1 = i.length();
        double length2 = k.length();
        if (Util.isNearZero(length1) || Util.isNearZero(length2)) {
            i.set(0.0, 0.0, 0.0);
            j.set(0.0, 0.0, 0.0);
            k.set(0.0, 0.0, 0.0);
            return 0.0;
        }
        double inverse_length_v1 = 1.0 / length1;
        double inverse_length_v2 = 1.0 / length2;
        i.scale(inverse_length_v1);
        k.scale(inverse_length_v2);
        j.cross(i, k);
        double length = j.length();
        if (Util.isNearZero(length)) {
            i.set(0.0, 0.0, 0.0);
            j.set(0.0, 0.0, 0.0);
            k.set(0.0, 0.0, 0.0);
            return 0.0;
        }
        j.scale(1.0 / length);
        double costheta = i.dot(k);
        if (costheta > 1.0) {
            theta = 0.0;
            costheta = 1.0;
        } else if (costheta < -1.0) {
            theta = Math.PI;
            costheta = -1.0;
        } else {
            theta = Math.acos(costheta);
        }
        i.cross(i, j);
        i.normalize();
        j.cross(k, j);
        j.normalize();
        i.scale(-inverse_length_v1);
        j.scale(inverse_length_v2);
        k.setT(j);
        j.add(i);
        j.scale(-1.0);
        return theta;
    }

    public static double restorativeForceAndOutOfPlaneAngleRadians(V3d i, V3d j, V3d k, V3d l, V3d an, V3d bn, V3d cn) {
        i.sub2(i, j);
        k.sub2(k, j);
        l.sub2(l, j);
        double length_ji = i.length();
        double length_jk = k.length();
        double length_jl = l.length();
        if (Util.isNearZero(length_ji) || Util.isNearZero(length_jk) || Util.isNearZero(length_jl)) {
            i.set(0.0, 0.0, 0.0);
            j.set(0.0, 0.0, 0.0);
            k.set(0.0, 0.0, 0.0);
            l.set(0.0, 0.0, 0.0);
            return 0.0;
        }
        i.normalize();
        k.normalize();
        l.normalize();
        double cos_theta = i.dot(k);
        double theta = Math.acos(cos_theta);
        if (Util.isNearZero(theta) || Util.isNearZero(Math.abs(theta - Math.PI))) {
            i.set(0.0, 0.0, 0.0);
            j.set(0.0, 0.0, 0.0);
            k.set(0.0, 0.0, 0.0);
            l.set(0.0, 0.0, 0.0);
            return 0.0;
        }
        double csc_theta = 1.0 / Math.sin(theta);
        an.cross(i, k);
        bn.cross(k, l);
        cn.cross(l, i);
        double sin_dl = an.dot(l) * csc_theta;
        double dl = Math.asin(sin_dl);
        double cos_dl = Math.cos(dl);
        if (cos_dl < 1.0E-4 || Util.isNearZero(dl) || Util.isNearZero(Math.abs(dl - Math.PI))) {
            i.set(0.0, 0.0, 0.0);
            j.set(0.0, 0.0, 0.0);
            k.set(0.0, 0.0, 0.0);
            l.set(0.0, 0.0, 0.0);
            return dl;
        }
        l.scaleAdd2(-sin_dl / csc_theta, l, an);
        l.scale(csc_theta / length_jl);
        j.setT(i);
        i.scaleAdd2(-cos_theta, k, i);
        i.scaleAdd2(-sin_dl * csc_theta, i, bn);
        i.scale(csc_theta / length_ji);
        k.scaleAdd2(-cos_theta, j, k);
        k.scaleAdd2(-sin_dl * csc_theta, k, cn);
        k.scale(csc_theta / length_jk);
        j.setT(i);
        j.add(k);
        j.add(l);
        j.scale(-1.0);
        return dl;
    }

    public static double restorativeForceAndTorsionAngleRadians(V3d i, V3d j, V3d k, V3d l) {
        i.sub2(j, i);
        j.sub2(k, j);
        k.sub2(l, k);
        double len_ij = i.length();
        double len_jk = j.length();
        double len_kl = k.length();
        if (Util.isNearZero(len_ij) || Util.isNearZero(len_jk) || Util.isNearZero(len_kl)) {
            i.set(0.0, 0.0, 0.0);
            j.set(0.0, 0.0, 0.0);
            k.set(0.0, 0.0, 0.0);
            l.set(0.0, 0.0, 0.0);
            return 0.0;
        }
        double ang = Util.vectorAngleRadians(i, j);
        double sin_j = Math.sin(ang);
        double cos_j = Math.cos(ang);
        ang = Util.vectorAngleRadians(j, k);
        double sin_k = Math.sin(ang);
        double cos_k = Math.cos(ang);
        i.normalize();
        j.normalize();
        k.normalize();
        i.cross(i, j);
        l.cross(j, k);
        k.cross(i, l);
        double theta = -Math.atan2(k.dot(j), i.dot(l));
        i.scale(1.0 / len_ij / sin_j / sin_j);
        l.scale(-1.0 / len_kl / sin_k / sin_k);
        j.setT(i);
        j.scale(-len_ij / len_jk * cos_j - 1.0);
        k.setT(l);
        k.scale(-len_kl / len_jk * cos_k);
        j.sub(k);
        k.setT(i);
        k.add(j);
        k.add(l);
        k.scale(-1.0);
        return theta;
    }
}

