/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Modify an image's geometric meta-data, changing its "physical"
extent.


The TransformGeometryImageFilter "physically" changes the image in space using the given
transformation. The resulting image is an image with the same voxel
values as the input, but with different physical space representation
as affected by the transform.

The specific transformation type can be any type derived from the MatrixOffsetTransformBase and the TranslationTransform . The modification of the geometric meta-data is an alternative to
resampling the moving image onto the fixed image grid, after
registration. The advantages of using this approach over resampling
are two-fold, it does not introduce artifacts into the result because
the original intensity information is not modified, and it is
computationally more efficient.

When the filter is used with a rigid or translation transformation the
resulting image can be saved in any desired format. When the filter is
used with an affine transformation the resulting image should be saved
in a format that supports a non ortho-normal direction cosine matrix
(e.g. nrrd).

Let us call the transform operation from the fixed image to moving
image TfmF2M . Given a set of points from the fixed image in physical
space (i.e. physicalFixedImagePoints ), the aim is to convert those
points into the moving image physical space as
physicalMovingImagePoints = TfmF2M( physicalFixedImagePoints ) , and
then be able to get the image values as movingContinuousIndexPoints =
movingImage-&gt;TransformPhysicalPointToContinuousIndex(
physicalMovingImagePoints ) .

We desire to change the moving image direction cosine $\\mathbf{D}$ and origin $\\mathbf{o}$ such that we can compute the moving image points as
movingContinuousIndexPoints =
newMovingImage-&gt;TransformPhysicalPointToContinuousIndex(
physicalFixedImagePoints )

Let us introduce the notation that will be used to formalize the
transformation:


Image-related parameters:

$\\mathbf{D}$ : direction cosine matrix

$\\mathbf{o}$ : origin vector

$\\mathbf{S}$ : spacing

$\\mathbf{ci}$ : continuous index

$\\mathbf{D}^{'}$ : new direction cosine matrix

$\\mathbf{o}^{'}$ : new origin vector

Image content in corresponding space:

$\\mathbf{f}_{p}$ : fixed image points in physical space

$\\mathbf{m}_{p}$ : moving image points in physical space

Rigid transform-related parameters:

$\\mathbf{R}$ : rotation matrix

$\\mathbf{c}$ : center of rotation vector

$\\mathbf{t}$ : translation vector
 The TransformPhysicalPointToContinuousIndex method performs then:
\\begin{eqnarray*} \\mathbf{ci} &amp;=
\\mathbf{S}^{-1}\\mathbf{D}^{-1}( \\mathbf{m}_{p} -
\\mathbf{o} ) \\ \\mathbf{m}_{p} &amp;=
\\mathbf{R}(\\mathbf{f}_{p} - \\mathbf{c}) + \\mathbf{c} +
\\mathbf{t} \\end{eqnarray*}

After substitution:

\\begin{eqnarray*} \\mathbf{m}_{c} &amp;=
\\underbrace{\\mathbf{R}^{-1}\\mathbf{D}}_\\text{new
cosine}\\mathbf{S} * \\mathbf{i} +
\\underbrace{\\mathbf{R}^{-1} * \\mathbf{o} - \\mathbf{R}^{-1}
* \\mathbf{c} - \\mathbf{R}^{-1}*t}_\\text{new origin} +
\\mathbf{c} \\ \\ \\mathbf{D}^{'} &amp;=
\\mathbf{R}^{-1}\\mathbf{D} \\ \\mathbf{o}^{'} &amp;=
\\mathbf{R}^{-1} * ( \\mathbf{o} - \\mathbf{c} - \\mathbf{t} )
+ \\mathbf{c} \\end{eqnarray*}
See:
 itk::simple::TransformGeometry for the procedural interface

 itk::TransformGeometryImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkTransformGeometryImageFilter.h
*/
public class TransformGeometryImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected TransformGeometryImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.TransformGeometryImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(TransformGeometryImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(TransformGeometryImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::TransformGeometryImageFilter::~TransformGeometryImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_TransformGeometryImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::TransformGeometryImageFilter::TransformGeometryImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  TransformGeometryImageFilter() {
    this(SimpleITKJNI.new_TransformGeometryImageFilter(), true);
  }

  /**
std::string itk::simple::TransformGeometryImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.TransformGeometryImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::TransformGeometryImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.TransformGeometryImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::TransformGeometryImageFilter::Execute(Image &amp;&amp;image, const Transform &amp;transform)

Execute the filter on the input image

*/
public  Image execute(Image image, Transform transform) {
    return new Image(SimpleITKJNI.TransformGeometryImageFilter_execute(swigCPtr, this, Image.getCPtr(image), image, Transform.getCPtr(transform), transform), true);
  }

}
