/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

CenteredTransformInitializerFilter is a helper class intended to initialize the center of rotation and
the translation of Transforms having the center of rotation among
their parameters.


This class is connected to the fixed image, moving image and transform
involved in the registration. Two modes of operation are possible:


Geometrical,

Center of mass
 In the first mode, the geometrical center of the moving image is
passed as initial center of rotation to the transform and the vector
from the center of the fixed image to the center of the moving image
is passed as the initial translation. This mode basically assumes that
the anatomical objects to be registered are centered in their
respective images. Hence the best initial guess for the registration
is the one that superimposes those two centers.

In the second mode, the moments of gray level values are computed for
both images. The center of mass of the moving image is then used as
center of rotation. The vector between the two centers of mass is
passes as the initial translation to the transform. This second
approach assumes that the moments of the anatomical objects are
similar for both images and hence the best initial guess for
registration is to superimpose both mass centers. Note that this
assumption will probably not hold in multi-modality registration.


See:
 itk::CenteredTransformInitializer


C++ includes: sitkCenteredTransformInitializerFilter.h
*/
public class CenteredTransformInitializerFilter extends ProcessObject {
  private transient long swigCPtr;

  protected CenteredTransformInitializerFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.CenteredTransformInitializerFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(CenteredTransformInitializerFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(CenteredTransformInitializerFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
itk::simple::CenteredTransformInitializerFilter::~CenteredTransformInitializerFilter() override

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_CenteredTransformInitializerFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::CenteredTransformInitializerFilter::CenteredTransformInitializerFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  CenteredTransformInitializerFilter() {
    this(SimpleITKJNI.new_CenteredTransformInitializerFilter(), true);
  }

  /**
Self&amp; itk::simple::CenteredTransformInitializerFilter::SetOperationMode(OperationModeType OperationMode)
*/
public  void setOperationMode(CenteredTransformInitializerFilter.OperationModeType OperationMode) {
    SimpleITKJNI.CenteredTransformInitializerFilter_setOperationMode(swigCPtr, this, OperationMode.swigValue());
  }

  /**
OperationModeType itk::simple::CenteredTransformInitializerFilter::GetOperationMode() const
*/
public  CenteredTransformInitializerFilter.OperationModeType getOperationMode() {
    return CenteredTransformInitializerFilter.OperationModeType.swigToEnum(SimpleITKJNI.CenteredTransformInitializerFilter_getOperationMode(swigCPtr, this));
  }

  /**
std::string itk::simple::CenteredTransformInitializerFilter::GetName() const override

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.CenteredTransformInitializerFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::CenteredTransformInitializerFilter::ToString() const override

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.CenteredTransformInitializerFilter_toString(swigCPtr, this);
  }

  /**
Transform itk::simple::CenteredTransformInitializerFilter::Execute(const Image &amp;fixedImage, const Image &amp;movingImage, const
Transform &amp;transform)

Execute the filter on the input image

*/
public  Transform execute(Image fixedImage, Image movingImage, Transform transform) {
    return new Transform(SimpleITKJNI.CenteredTransformInitializerFilter_execute(swigCPtr, this, Image.getCPtr(fixedImage), fixedImage, Image.getCPtr(movingImage), movingImage, Transform.getCPtr(transform), transform), true);
  }

  /**
Self&amp; itk::simple::CenteredTransformInitializerFilter::MomentsOn()

Select between using the geometrical center of the images or using the
center of mass given by the image intensities.

*/
public  void momentsOn() {
    SimpleITKJNI.CenteredTransformInitializerFilter_momentsOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::CenteredTransformInitializerFilter::GeometryOn()

Select between using the geometrical center of the images or using the
center of mass given by the image intensities.

*/
public  void geometryOn() {
    SimpleITKJNI.CenteredTransformInitializerFilter_geometryOn(swigCPtr, this);
  }

  public final static class OperationModeType {
    public final static CenteredTransformInitializerFilter.OperationModeType GEOMETRY = new CenteredTransformInitializerFilter.OperationModeType("GEOMETRY");
    public final static CenteredTransformInitializerFilter.OperationModeType MOMENTS = new CenteredTransformInitializerFilter.OperationModeType("MOMENTS");

    public final int swigValue() {
      return swigValue;
    }

    public String toString() {
      return swigName;
    }

    public static OperationModeType swigToEnum(int swigValue) {
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (int i = 0; i < swigValues.length; i++)
        if (swigValues[i].swigValue == swigValue)
          return swigValues[i];
      throw new IllegalArgumentException("No enum " + OperationModeType.class + " with value " + swigValue);
    }

    private OperationModeType(String swigName) {
      this.swigName = swigName;
      this.swigValue = swigNext++;
    }

    private OperationModeType(String swigName, int swigValue) {
      this.swigName = swigName;
      this.swigValue = swigValue;
      swigNext = swigValue+1;
    }

    private OperationModeType(String swigName, OperationModeType swigEnum) {
      this.swigName = swigName;
      this.swigValue = swigEnum.swigValue;
      swigNext = this.swigValue+1;
    }

    private static OperationModeType[] swigValues = { GEOMETRY, MOMENTS };
    private static int swigNext = 0;
    private final int swigValue;
    private final String swigName;
  }

}
