/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.DirectContextKt;
import org.jetbrains.skia.GLBackendState;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.impl.Library;
import org.jetbrains.skia.impl.Native;
import org.jetbrains.skia.impl.Native_jvmKt;
import org.jetbrains.skia.impl.RefCnt;
import org.jetbrains.skia.impl.Stats;
import org.jetbrains.skiko.OpenGLLibrary_jvmKt;
import org.jetbrains.skiko.RenderException;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0015\b\u0000\u0012\n\u0010\u0002\u001a\u00060\u0004j\u0002`\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\u0000J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u0000J\u0006\u0010\u000b\u001a\u00020\u0000J\u001f\u0010\f\u001a\u00020\u00002\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0016\u001a\u00020\u0012R$\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u0006\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/skia/DirectContext;", "Lorg/jetbrains/skia/impl/RefCnt;", "ptr", "Lorg/jetbrains/skia/impl/NativePointer;", "", "<init>", "(J)V", "flush", "surface", "Lorg/jetbrains/skia/Surface;", "resetAll", "resetGLAll", "resetGL", "states", "", "Lorg/jetbrains/skia/GLBackendState;", "([Lorg/jetbrains/skia/GLBackendState;)Lorg/jetbrains/skia/DirectContext;", "submit", "", "syncCpu", "", "flushAndSubmit", "abandon", "value", "resourceCacheLimit", "getResourceCacheLimit", "()J", "setResourceCacheLimit", "Companion", "skiko"})
public final class DirectContext
extends RefCnt {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public DirectContext(long ptr) {
        super(ptr);
    }

    @NotNull
    public final DirectContext flush() {
        Stats.INSTANCE.onNativeCall();
        DirectContextKt.access$DirectContext_nFlushDefault(this.get_ptr$skiko());
        return this;
    }

    @NotNull
    public final DirectContext flush(@NotNull Surface surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        Stats.INSTANCE.onNativeCall();
        DirectContextKt.access$DirectContext_nFlush(this.get_ptr$skiko(), surface.get_ptr$skiko());
        return this;
    }

    @NotNull
    public final DirectContext resetAll() {
        Stats.INSTANCE.onNativeCall();
        DirectContextKt.access$_nReset(this.get_ptr$skiko(), -1);
        return this;
    }

    @NotNull
    public final DirectContext resetGLAll() {
        Stats.INSTANCE.onNativeCall();
        DirectContextKt.access$_nReset(this.get_ptr$skiko(), 65535);
        return this;
    }

    @NotNull
    public final DirectContext resetGL(GLBackendState ... states) {
        Intrinsics.checkNotNullParameter((Object)states, (String)"states");
        Stats.INSTANCE.onNativeCall();
        int flags = 0;
        for (GLBackendState state2 : states) {
            flags |= state2.get_bit$skiko();
        }
        DirectContextKt.access$_nReset(this.get_ptr$skiko(), flags);
        return this;
    }

    public final void submit(boolean syncCpu) {
        Stats.INSTANCE.onNativeCall();
        DirectContextKt.access$_nSubmit(this.get_ptr$skiko(), syncCpu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flushAndSubmit(@NotNull Surface surface, boolean syncCpu) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        try {
            Stats.INSTANCE.onNativeCall();
            DirectContextKt.access$_nFlushAndSubmit(this.get_ptr$skiko(), surface.get_ptr$skiko(), syncCpu);
        }
        finally {
            Native_jvmKt.reachabilityBarrier(this);
        }
    }

    public static /* synthetic */ void flushAndSubmit$default(DirectContext directContext, Surface surface, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        directContext.flushAndSubmit(surface, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void abandon() {
        try {
            Stats.INSTANCE.onNativeCall();
            DirectContextKt.access$_nAbandon(this.get_ptr$skiko(), 0);
        }
        finally {
            Native_jvmKt.reachabilityBarrier(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getResourceCacheLimit() {
        try {
            Stats.INSTANCE.onNativeCall();
            long l = DirectContextKt.access$DirectContext_nGetResourceCacheLimit(this.get_ptr$skiko());
            return l;
        }
        finally {
            Native_jvmKt.reachabilityBarrier(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setResourceCacheLimit(long value) {
        try {
            Stats.INSTANCE.onNativeCall();
            DirectContextKt.access$DirectContext_nSetResourceCacheLimit(this.get_ptr$skiko(), value);
        }
        finally {
            Native_jvmKt.reachabilityBarrier(this);
        }
    }

    static {
        Library.Companion.staticLoad();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J#\u0010\u0006\u001a\u00020\u00052\n\u0010\u0007\u001a\u00060\tj\u0002`\b2\n\u0010\n\u001a\u00060\tj\u0002`\b\u00a2\u0006\u0002\u0010\u000bJ/\u0010\f\u001a\u00020\u00052\n\u0010\r\u001a\u00060\tj\u0002`\b2\n\u0010\u0007\u001a\u00060\tj\u0002`\b2\n\u0010\n\u001a\u00060\tj\u0002`\b\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/skia/DirectContext$Companion;", "", "<init>", "()V", "makeGL", "Lorg/jetbrains/skia/DirectContext;", "makeMetal", "devicePtr", "Lorg/jetbrains/skia/impl/NativePointer;", "", "queuePtr", "(JJ)Lorg/jetbrains/skia/DirectContext;", "makeDirect3D", "adapterPtr", "(JJJ)Lorg/jetbrains/skia/DirectContext;", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DirectContext makeGL() {
            Stats.INSTANCE.onNativeCall();
            OpenGLLibrary_jvmKt.loadOpenGLLibrary();
            long ptr = DirectContextKt.access$_nMakeGL();
            if (ptr == Native.Companion.getNullPointer()) {
                throw new RenderException("Can't create OpenGL DirectContext", null, 2, null);
            }
            return new DirectContext(ptr);
        }

        @NotNull
        public final DirectContext makeMetal(long devicePtr, long queuePtr) {
            Stats.INSTANCE.onNativeCall();
            return new DirectContext(DirectContextKt.access$_nMakeMetal(devicePtr, queuePtr));
        }

        @NotNull
        public final DirectContext makeDirect3D(long adapterPtr, long devicePtr, long queuePtr) {
            Stats.INSTANCE.onNativeCall();
            return new DirectContext(DirectContextKt.access$_nMakeDirect3D(adapterPtr, devicePtr, queuePtr));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

