/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.settings.pandoc;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.settings.pandoc.PandocExecutableDetector;
import org.intellij.plugins.markdown.settings.pandoc.PandocSettings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0018\u001a\u00020\u0012H\u0003J(\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u000e\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u001fH\u0002J\u0006\u0010 \u001a\u00020\u001aJ\u0006\u0010!\u001a\u00020\"J\b\u0010#\u001a\u00020\u001aH\u0002J\u0006\u0010$\u001a\u00020\u001aJ\b\u0010%\u001a\u00020\u001aH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0011\u001a\t\u0018\u00010\u0012\u00a2\u0006\u0002\b\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0016\u001a\t\u0018\u00010\u0012\u00a2\u0006\u0002\b\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015\u00a8\u0006&"}, d2={"Lorg/intellij/plugins/markdown/settings/pandoc/PandocSettingsPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "executablePathSelector", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "testButton", "Ljavax/swing/JButton;", "infoPanel", "imagesPathSelector", "settings", "Lorg/intellij/plugins/markdown/settings/pandoc/PandocSettings;", "getSettings", "()Lorg/intellij/plugins/markdown/settings/pandoc/PandocSettings;", "executablePath", "", "Lorg/jetbrains/annotations/NotNull;", "getExecutablePath", "()Ljava/lang/String;", "imagesPath", "getImagesPath", "getLabelText", "setupFileChooser", "", "browser", "descriptor", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "defaultValue", "Lkotlin/Function0;", "apply", "isModified", "", "updateExecutablePathSelectorEmptyText", "reset", "dispose", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nPandocSettingsPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PandocSettingsPanel.kt\norg/intellij/plugins/markdown/settings/pandoc/PandocSettingsPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n1#2:157\n*E\n"})
public final class PandocSettingsPanel
extends JPanel
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final TextFieldWithBrowseButton executablePathSelector;
    @NotNull
    private final JButton testButton;
    @NotNull
    private final JPanel infoPanel;
    @NotNull
    private final TextFieldWithBrowseButton imagesPathSelector;

    /*
     * WARNING - void declaration
     */
    public PandocSettingsPanel(@NotNull Project project) {
        void $this$infoPanel_u24lambda_u240;
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(new GridBagLayout());
        this.project = project;
        this.executablePathSelector = new TextFieldWithBrowseButton();
        this.testButton = new JButton(MarkdownBundle.message("markdown.settings.pandoc.executable.test", new Object[0]));
        JPanel jPanel2 = jPanel = new JPanel();
        PandocSettingsPanel pandocSettingsPanel = this;
        boolean bl = false;
        $this$infoPanel_u24lambda_u240.setLayout(new BoxLayout((Container)$this$infoPanel_u24lambda_u240, 1));
        pandocSettingsPanel.infoPanel = jPanel;
        this.imagesPathSelector = new TextFieldWithBrowseButton();
        Disposer.register((Disposable)this, (Disposable)((Disposable)this.executablePathSelector));
        Disposer.register((Disposable)this, (Disposable)((Disposable)this.imagesPathSelector));
        JPanel $this$_init__u24lambda_u240 = jPanel2 = new GridBag();
        boolean bl2 = false;
        $this$_init__u24lambda_u240.setDefaultAnchor(17);
        $this$_init__u24lambda_u240.setDefaultFill(2);
        $this$_init__u24lambda_u240.nextLine().next();
        JPanel gb = jPanel2;
        this.add((Component)new JBLabel(MarkdownBundle.message("markdown.settings.pandoc.executable.label", new Object[0])), gb.insets((Insets)JBUI.insetsRight((int)10)));
        this.add((Component)this.executablePathSelector, gb.next().fillCellHorizontally().weightx(1.0).insets(0, 0, 1, 0));
        this.add((Component)this.testButton, gb.next());
        gb.nextLine().next();
        this.add((Component)this.infoPanel, gb.next().insets(4, 4, 0, 0));
        gb.nextLine().next();
        this.add((Component)new JBLabel(MarkdownBundle.message("markdown.settings.pandoc.resource.path.label", new Object[0])), gb.insets((Insets)JBUI.insetsRight((int)10)));
        this.add((Component)this.imagesPathSelector, gb.next().coverLine().insets(0, 0, 1, 0));
        this.testButton.addActionListener(arg_0 -> PandocSettingsPanel._init_$lambda$1(this, arg_0));
        this.setupFileChooser(this.executablePathSelector, new FileChooserDescriptor(true, false, true, true, false, false), (Function0<String>)((Function0)() -> PandocSettingsPanel._init_$lambda$2(this)));
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor, (String)"createSingleFolderDescriptor(...)");
        this.setupFileChooser(this.imagesPathSelector, fileChooserDescriptor, (Function0<String>)((Function0)() -> PandocSettingsPanel._init_$lambda$3(this)));
        this.reset();
    }

    private final PandocSettings getSettings() {
        return PandocSettings.Companion.getInstance(this.project);
    }

    private final String getExecutablePath() {
        String string;
        String it = string = this.executablePathSelector.getText();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        return ((CharSequence)it).length() > 0 ? string : null;
    }

    private final String getImagesPath() {
        String string;
        String it = string = this.imagesPathSelector.getText();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        return ((CharSequence)it).length() > 0 ? string : null;
    }

    @NlsSafe
    private final String getLabelText() {
        String path;
        String string = this.getExecutablePath();
        if (string == null) {
            string = PandocExecutableDetector.INSTANCE.detect(this.project);
        }
        if ((path = string) == null) {
            String string2 = MarkdownBundle.message("markdown.settings.pandoc.executable.run.in.safe.mode", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            return string2;
        }
        String detectedVersion = PandocExecutableDetector.INSTANCE.obtainPandocVersion(this.project, path);
        if (detectedVersion == null) {
            Object[] objectArray = new Object[]{path};
            String string3 = MarkdownBundle.message("markdown.settings.pandoc.executable.error.msg", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            return string3;
        }
        Object[] objectArray = new Object[]{detectedVersion};
        String string4 = MarkdownBundle.message("markdown.settings.pandoc.executable.success.msg", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        return string4;
    }

    private final void setupFileChooser(TextFieldWithBrowseButton browser, FileChooserDescriptor descriptor, Function0<String> defaultValue) {
        String string = (String)defaultValue.invoke();
        if (string != null) {
            String string2;
            String it = string2 = string;
            boolean bl = false;
            string = ((CharSequence)it).length() > 0 ? string2 : null;
            if (string != null) {
                it = string;
                boolean bl2 = false;
                this.imagesPathSelector.setText(it);
            }
        }
        browser.addActionListener(arg_0 -> PandocSettingsPanel.setupFileChooser$lambda$2(browser, descriptor, this, arg_0));
        FileChooserFactory.getInstance().installFileCompletion(browser.getTextField(), descriptor, true, (Disposable)browser);
    }

    public final void apply() {
        this.getSettings().setPathToPandoc(this.getExecutablePath());
        this.getSettings().setPathToImages(this.getImagesPath());
    }

    public final boolean isModified() {
        return !Intrinsics.areEqual((Object)this.getExecutablePath(), (Object)this.getSettings().getPathToPandoc()) || !Intrinsics.areEqual((Object)this.getImagesPath(), (Object)this.getSettings().getPathToImages());
    }

    private final void updateExecutablePathSelectorEmptyText() {
        String string = PandocExecutableDetector.INSTANCE.detect(this.project);
        if (string == null) {
            return;
        }
        String detectedPath = string;
        if (((CharSequence)detectedPath).length() > 0) {
            JTextField jTextField = this.executablePathSelector.getTextField();
            Intrinsics.checkNotNull((Object)jTextField, (String)"null cannot be cast to non-null type com.intellij.ui.components.JBTextField");
            Object[] objectArray = new Object[]{detectedPath};
            ((JBTextField)jTextField).getEmptyText().setText(MarkdownBundle.message("markdown.settings.pandoc.executable.auto", objectArray));
        } else {
            JTextField jTextField = this.executablePathSelector.getTextField();
            Intrinsics.checkNotNull((Object)jTextField, (String)"null cannot be cast to non-null type com.intellij.ui.components.JBTextField");
            ((JBTextField)jTextField).getEmptyText().setText(MarkdownBundle.message("markdown.settings.pandoc.executable.default.error.msg", new Object[0]));
        }
    }

    public final void reset() {
        String string;
        String path = this.getSettings().getPathToPandoc();
        if (path == null) {
            this.executablePathSelector.setText("");
            this.updateExecutablePathSelectorEmptyText();
        } else {
            this.executablePathSelector.setText(path);
        }
        if ((string = this.getSettings().getPathToImages()) == null) {
            string = "";
        }
        this.imagesPathSelector.setText(string);
    }

    public void dispose() {
    }

    /*
     * WARNING - void declaration
     */
    private static final void _init_$lambda$1(PandocSettingsPanel this$0, ActionEvent it) {
        void $this$lambda_u241_u240;
        JBLabel jBLabel;
        this$0.infoPanel.removeAll();
        String labelText = this$0.getLabelText();
        JBLabel jBLabel2 = jBLabel = new JBLabel(labelText);
        JPanel jPanel = this$0.infoPanel;
        boolean bl = false;
        $this$lambda_u241_u240.setBorder(IdeBorderFactory.createEmptyBorder((Insets)((Insets)JBUI.insetsBottom((int)4))));
        jPanel.add((Component)jBLabel);
    }

    private static final String _init_$lambda$2(PandocSettingsPanel this$0) {
        return this$0.getSettings().getPathToPandoc();
    }

    private static final String _init_$lambda$3(PandocSettingsPanel this$0) {
        return this$0.getSettings().getPathToImages();
    }

    private static final void setupFileChooser$lambda$2(TextFieldWithBrowseButton $browser, FileChooserDescriptor $descriptor, PandocSettingsPanel this$0, ActionEvent it) {
        VirtualFile virtualFile;
        String string;
        String it2 = string = $browser.getText();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it2);
        String string2 = ((CharSequence)it2).length() > 0 ? string : null;
        if (string2 != null) {
            it2 = string2;
            boolean bl2 = false;
            virtualFile = VfsUtil.findFileByIoFile((File)new File(it2), (boolean)false);
        } else {
            virtualFile = null;
        }
        VirtualFile lastFile = virtualFile;
        Object[] objectArray = FileChooser.chooseFiles((FileChooserDescriptor)$descriptor, (Project)this$0.project, lastFile);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"chooseFiles(...)");
        Object[] files = objectArray;
        if (files.length == 1) {
            $browser.setText(((VirtualFile)ArraysKt.first((Object[])files)).getPresentableUrl());
        }
    }
}

