/*
 * Decompiled with CFR 0.152.
 */
package training.git;

import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import git4idea.actions.GitInit;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import training.project.FileUtils;
import training.project.ProjectUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\b\u0010\u0013\u001a\u00020\rH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0002J \u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\u0019\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ltraining/git/GitProjectUtil;", "", "<init>", "()V", "remoteProjectName", "", "restoreGitLessonsFiles", "", "project", "Lcom/intellij/openapi/project/Project;", "branch", "checkout", "root", "Ljava/io/File;", "addVcsMappingSynchronously", "gitRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "createRemoteProject", "remoteName", "reCreateRemoteProjectDir", "copyGitProject", "", "destination", "configureRemote", "remoteProjectRoot", "refreshAndGetProjectRoot", "intellij.vcs.git.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nGitProjectUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitProjectUtil.kt\ntraining/git/GitProjectUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n23#2:118\n23#2:120\n1#3:119\n*S KotlinDebug\n*F\n+ 1 GitProjectUtil.kt\ntraining/git/GitProjectUtil\n*L\n69#1:118\n104#1:120\n*E\n"})
public final class GitProjectUtil {
    @NotNull
    public static final GitProjectUtil INSTANCE = new GitProjectUtil();
    @NotNull
    private static final String remoteProjectName = "RemoteLearningProject";

    private GitProjectUtil() {
    }

    public final void restoreGitLessonsFiles(@NotNull Project project, @NotNull String branch) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        VirtualFile learningProjectRoot = this.refreshAndGetProjectRoot();
        VirtualFile gitProjectRoot = (VirtualFile)ActionsKt.invokeAndWaitIfNeeded$default(null, () -> GitProjectUtil.restoreGitLessonsFiles$lambda$0(project, learningProjectRoot), (int)1, null);
        File root = gitProjectRoot.toNioPath().toFile();
        Intrinsics.checkNotNull((Object)root);
        if (!this.copyGitProject(root)) {
            throw new IllegalStateException("Failed to copy git project".toString());
        }
        this.checkout(root, branch);
        this.addVcsMappingSynchronously(project, gitProjectRoot);
    }

    private final void checkout(File root, String branch) {
        GitLineHandler handler = new GitLineHandler(null, root, GitCommand.CHECKOUT);
        String[] stringArray = new String[]{branch};
        handler.addParameters(stringArray);
        handler.endOptions();
        Git.getInstance().runCommand(handler).throwOnError(new int[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addVcsMappingSynchronously(Project project, VirtualFile gitRoot) {
        CompletableFuture updateFinishedFuture = new CompletableFuture();
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(VcsRepositoryManager.VCS_REPOSITORY_MAPPING_UPDATED, () -> GitProjectUtil.addVcsMappingSynchronously$lambda$0(updateFinishedFuture));
        GitInit.refreshAndConfigureVcsMappings((Project)project, (VirtualFile)gitRoot, (String)gitRoot.getPath());
        try {
            updateFinishedFuture.get(3L, TimeUnit.SECONDS);
        }
        catch (TimeoutException ex) {
            GitProjectUtil $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(GitProjectUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Repository mappings update didn't happened", (Throwable)ex);
        }
        finally {
            connection.disconnect();
        }
    }

    @NotNull
    public final File createRemoteProject(@NotNull String remoteName, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)remoteName, (String)"remoteName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        File root = this.reCreateRemoteProjectDir();
        if (this.copyGitProject(root)) {
            this.configureRemote(remoteName, root, project);
            return root;
        }
        throw new IllegalStateException(("Failed to create remote project at path: " + root.getPath()).toString());
    }

    private final File reCreateRemoteProjectDir() {
        File file;
        block9: {
            File projectsRoot;
            block8: {
                File file2;
                File file3;
                block7: {
                    projectsRoot = ProjectUtils.INSTANCE.getLearningProjectsPath().toFile();
                    File[] fileArray = projectsRoot.listFiles();
                    if (fileArray != null) {
                        File[] fileArray2 = fileArray;
                        int n = fileArray2.length;
                        for (int i = 0; i < n; ++i) {
                            File file4;
                            File it = file4 = fileArray2[i];
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)remoteProjectName)) continue;
                            file3 = file4;
                            break block7;
                        }
                        file3 = null;
                    } else {
                        file3 = null;
                    }
                }
                File it = file3;
                boolean bl = false;
                file = it;
                if (file == null) break block8;
                File $this$reCreateRemoteProjectDir_u24lambda_u241_u240 = file2 = file;
                boolean bl2 = false;
                FilesKt.deleteRecursively((File)$this$reCreateRemoteProjectDir_u24lambda_u241_u240);
                file = file2;
                if (file != null) break block9;
            }
            file = new File(projectsRoot.getAbsolutePath() + File.separator + remoteProjectName);
        }
        File remoteProjectRoot = file;
        remoteProjectRoot.mkdir();
        return remoteProjectRoot;
    }

    private final boolean copyGitProject(File destination) {
        URL uRL = this.getClass().getClassLoader().getResource("learnProjects/GitProject");
        if (uRL == null) {
            throw new IllegalStateException("GitProject not found".toString());
        }
        URL gitProjectURL = uRL;
        return FileUtils.copyResourcesRecursively$default(FileUtils.INSTANCE, gitProjectURL, destination, null, 4, null);
    }

    private final void configureRemote(String remoteName, File remoteProjectRoot, Project project) {
        Git git = Git.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)git, (String)"getInstance(...)");
        Git git2 = git;
        List list = GitRepositoryManager.getInstance((Project)project).getRepositories();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRepositories(...)");
        GitRepository repository = (GitRepository)CollectionsKt.first((List)list);
        String remoteUrl = "file://" + FileUtilKt.getSystemIndependentPath((File)remoteProjectRoot);
        GitProjectUtil $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(GitProjectUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Add remote repository with URL: " + remoteUrl);
        git2.addRemote(repository, remoteName, remoteUrl).throwOnError(new int[0]);
        repository.update();
        Collection collection = repository.getRemotes();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRemotes(...)");
        git2.fetch(repository, (GitRemote)CollectionsKt.first((Iterable)collection), CollectionsKt.emptyList(), new String[0]).throwOnError(new int[0]);
        git2.setUpstream(repository, remoteName + "/main", "main").throwOnError(new int[0]);
        repository.update();
    }

    private final VirtualFile refreshAndGetProjectRoot() {
        Path path = ProjectUtils.INSTANCE.getCurrentLearningProjectRoot().toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
        Path learningProjectPath = path;
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(learningProjectPath);
        if (virtualFile == null) {
            throw new IllegalStateException("Learning project not found".toString());
        }
        return virtualFile;
    }

    private static final VirtualFile restoreGitLessonsFiles$lambda$0(Project $project, VirtualFile $learningProjectRoot) {
        return (VirtualFile)ActionsKt.runWriteAction(() -> GitProjectUtil.restoreGitLessonsFiles$lambda$0$0($project, $learningProjectRoot));
    }

    private static final VirtualFile restoreGitLessonsFiles$lambda$0$0(Project $project, VirtualFile $learningProjectRoot) {
        VirtualFile virtualFile;
        ProjectLevelVcsManager.Companion.getInstance($project).setDirectoryMappings((List)new ArrayList());
        VirtualFile virtualFile2 = $learningProjectRoot.findChild("git");
        if (virtualFile2 != null) {
            VirtualFile virtualFile3;
            VirtualFile $this$restoreGitLessonsFiles_u24lambda_u240_u240_u240 = virtualFile3 = virtualFile2;
            boolean bl = false;
            VirtualFile virtualFile4 = $this$restoreGitLessonsFiles_u24lambda_u240_u240_u240.findChild(".git");
            if (virtualFile4 != null) {
                virtualFile4.delete((Object)$this$restoreGitLessonsFiles_u24lambda_u240_u240_u240);
            }
            virtualFile = virtualFile3;
        } else {
            VirtualFile virtualFile5 = $learningProjectRoot.createChildDirectory((Object)INSTANCE, "git");
            virtualFile = virtualFile5;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile5, (String)"createChildDirectory(...)");
        }
        return virtualFile;
    }

    private static final void addVcsMappingSynchronously$lambda$0(CompletableFuture $updateFinishedFuture) {
        $updateFinishedFuture.complete(true);
    }
}

