/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.NameUtilCore;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassFinder {
    private static final List<String> IGNORED_CLASS_NAMES = Arrays.asList("com.intellij.tests.BootstrapTests", "com.intellij.AllTests");
    private final List<String> classNameList;
    private final Path classPathRoot;
    private final boolean includeUnconventionallyNamedTests;

    public ClassFinder(Path classPathRoot, String rootPackage, boolean includeUnconventionallyNamedTests) {
        this.classPathRoot = classPathRoot;
        this.includeUnconventionallyNamedTests = includeUnconventionallyNamedTests;
        String directoryOffset = rootPackage.replace(".", classPathRoot.getFileSystem().getSeparator());
        this.classNameList = Files.isRegularFile(classPathRoot, new LinkOption[0]) ? this.findAndStoreTestClassesFromJar(directoryOffset) : this.findAndStoreTestClasses(directoryOffset);
    }

    @Nullable
    private String computeClassName(@NotNull Path path, @NotNull Path root) {
        if (path == null) {
            ClassFinder.$$$reportNull$$$0(0);
        }
        if (root == null) {
            ClassFinder.$$$reportNull$$$0(1);
        }
        Path absPath = path.toAbsolutePath();
        String fileName = absPath.getFileName().toString();
        if (!this.includeUnconventionallyNamedTests) {
            if (fileName.endsWith("Test.class")) {
                return ClassFinder.getClassFQN(absPath, root);
            }
            return null;
        }
        if (!FileUtilRt.extensionEquals((String)fileName, (String)"class")) {
            return null;
        }
        if (ClassFinder.isSuitableTestClassName(FileUtilRt.getNameWithoutExtension((String)fileName), this.includeUnconventionallyNamedTests)) {
            return ClassFinder.getClassFQN(absPath, root);
        }
        return null;
    }

    static boolean isSuitableTestClassName(@NotNull String className, boolean includeUnconventionallyNamedTests) {
        if (className == null) {
            ClassFinder.$$$reportNull$$$0(2);
        }
        if (!includeUnconventionallyNamedTests) {
            return className.endsWith("Test");
        }
        if (!className.contains("Test") && !className.contains("Suite")) {
            return false;
        }
        className = StringsKt.substringAfterLast((String)className, (char)'.', (String)className);
        List<String> names = Arrays.asList(className.split("\\$"));
        Collections.reverse(names);
        for (String name : names) {
            if (!Character.isUpperCase(name.charAt(0))) {
                return false;
            }
            List<String> words = Arrays.asList(NameUtilCore.nameToWords((String)name));
            if (!words.contains("Test") && !words.contains("Tests") && !words.contains("Suite")) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static String getClassFQN(@NotNull Path path, @NotNull Path root) {
        String fqn;
        if (path == null) {
            ClassFinder.$$$reportNull$$$0(3);
        }
        if (root == null) {
            ClassFinder.$$$reportNull$$$0(4);
        }
        return IGNORED_CLASS_NAMES.contains(fqn = StringUtil.trimEnd((String)root.relativize(path).toString(), (String)".class").replace(path.getFileSystem().getSeparator(), ".")) ? null : fqn;
    }

    private List<String> findAndStoreTestClasses(@NotNull String directoryOffset) {
        List<String> list;
        block10: {
            Path current;
            if (directoryOffset == null) {
                ClassFinder.$$$reportNull$$$0(5);
            }
            if (!Files.exists(current = this.classPathRoot.resolve(directoryOffset), new LinkOption[0])) {
                return Collections.emptyList();
            }
            Stream<Path> walk = Files.walk(current, new FileVisitOption[0]);
            try {
                list = walk.filter(path -> Files.isRegularFile(path, new LinkOption[0])).map(path -> this.computeClassName((Path)path, this.classPathRoot)).filter(name -> name != null).toList();
                if (walk == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (walk != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            walk.close();
        }
        return list;
    }

    private List<String> findAndStoreTestClassesFromJar(@NotNull String directoryOffset) {
        if (directoryOffset == null) {
            ClassFinder.$$$reportNull$$$0(6);
        }
        if (!Files.exists(this.classPathRoot, new LinkOption[0])) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        try (FileSystem fs = FileSystems.newFileSystem(this.classPathRoot);){
            for (Path root : fs.getRootDirectories()) {
                Path offset = root.resolve(directoryOffset);
                if (!Files.exists(offset, new LinkOption[0])) continue;
                Stream<Path> walk = Files.walk(offset, new FileVisitOption[0]);
                try {
                    result.addAll(walk.filter(path -> Files.isRegularFile(path, new LinkOption[0])).map(it -> this.computeClassName((Path)it, root)).filter(name -> name != null).toList());
                }
                finally {
                    if (walk == null) continue;
                    walk.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public Collection<String> getClasses() {
        return this.classNameList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryOffset";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ClassFinder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "computeClassName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuitableTestClassName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getClassFQN";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findAndStoreTestClasses";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findAndStoreTestClassesFromJar";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

