/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext;

import java.util.Objects;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.SyncContext;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named.NamedLockFactoryAdapter;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named.NamedLockFactoryAdapterFactory;
import org.jetbrains.kotlin.org.eclipse.aether.spi.locator.Service;
import org.jetbrains.kotlin.org.eclipse.aether.spi.locator.ServiceLocator;
import org.jetbrains.kotlin.org.eclipse.aether.spi.synccontext.SyncContextFactory;

@Singleton
@Named
public final class DefaultSyncContextFactory
implements Service,
SyncContextFactory {
    private static final String ADAPTER_KEY = DefaultSyncContextFactory.class.getName() + ".adapter";
    private NamedLockFactoryAdapterFactory namedLockFactoryAdapterFactory;

    @Deprecated
    public DefaultSyncContextFactory() {
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.namedLockFactoryAdapterFactory = Objects.requireNonNull(locator.getService(NamedLockFactoryAdapterFactory.class));
    }

    @Override
    public SyncContext newInstance(RepositorySystemSession session, boolean shared) {
        Objects.requireNonNull(session, "session cannot be null");
        NamedLockFactoryAdapter adapter = (NamedLockFactoryAdapter)session.getData().computeIfAbsent(ADAPTER_KEY, () -> this.namedLockFactoryAdapterFactory.getAdapter(session));
        return adapter.newInstance(session, shared);
    }
}

