/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.elements;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.actions.AnnotationRequest;
import com.intellij.lang.jvm.actions.CreateMethodRequest;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.JvmPsiUtilKt;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.TemplatesKt;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.template.expressions.ChooseTypeExpression;
import org.jetbrains.plugins.groovy.template.expressions.ParameterNameExpression;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0006\u0010\u0019\u001a\u00020\u0018J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/intentions/elements/MethodRenderer;", "", "project", "Lcom/intellij/openapi/project/Project;", "abstract", "", "targetClass", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;", "request", "Lcom/intellij/lang/jvm/actions/CreateMethodRequest;", "<init>", "(Lcom/intellij/openapi/project/Project;ZLorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;Lcom/intellij/lang/jvm/actions/CreateMethodRequest;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getAbstract", "()Z", "getTargetClass", "()Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;", "getRequest", "()Lcom/intellij/lang/jvm/actions/CreateMethodRequest;", "execute", "", "setupTemplate", "method", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrMethod;", "renderMethod", "insertMethod", "intellij.groovy"})
@SourceDebugExtension(value={"SMAP\nCreateMethodAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateMethodAction.kt\norg/jetbrains/plugins/groovy/annotator/intentions/elements/MethodRenderer\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,123:1\n37#2,2:124\n37#2,2:126\n*S KotlinDebug\n*F\n+ 1 CreateMethodAction.kt\norg/jetbrains/plugins/groovy/annotator/intentions/elements/MethodRenderer\n*L\n76#1:124,2\n77#1:126,2\n*E\n"})
final class MethodRenderer {
    @NotNull
    private final Project project;
    private final boolean abstract;
    @NotNull
    private final GrTypeDefinition targetClass;
    @NotNull
    private final CreateMethodRequest request;

    public MethodRenderer(@NotNull Project project, boolean bl, @NotNull GrTypeDefinition targetClass, @NotNull CreateMethodRequest request) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)targetClass, (String)"targetClass");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.project = project;
        this.abstract = bl;
        this.targetClass = targetClass;
        this.request = request;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final boolean getAbstract() {
        return this.abstract;
    }

    @NotNull
    public final GrTypeDefinition getTargetClass() {
        return this.targetClass;
    }

    @NotNull
    public final CreateMethodRequest getRequest() {
        return this.request;
    }

    public final void execute() {
        GrMethod method = this.renderMethod();
        method = this.insertMethod(method);
        GrMethod grMethod = (GrMethod)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)method);
        if (grMethod == null) {
            return;
        }
        method = grMethod;
        this.setupTemplate(method);
    }

    private final void setupTemplate(GrMethod method) {
        List list = this.request.getExpectedParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExpectedParameters(...)");
        List parameters = list;
        Collection $this$toTypedArray$iv = TemplatesKt.setupParameters(method, parameters);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ChooseTypeExpression[] typeExpressions = thisCollection$iv.toArray(new ChooseTypeExpression[0]);
        Collection $this$toTypedArray$iv2 = TemplatesKt.setupNameExpressions(parameters, this.project);
        boolean $i$f$toTypedArray2 = false;
        Collection thisCollection$iv2 = $this$toTypedArray$iv2;
        ParameterNameExpression[] nameExpressions = thisCollection$iv2.toArray(new ParameterNameExpression[0]);
        List list2 = this.request.getReturnType();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getReturnType(...)");
        ChooseTypeExpression returnExpression = TemplatesKt.setupTypeElement(method, JvmPsiUtilKt.createConstraints(this.project, list2));
        IntentionUtils.createTemplateForMethod(typeExpressions, nameExpressions, method, this.targetClass, returnExpression, false, this.request.isStartTemplate(), null);
    }

    @NotNull
    public final GrMethod renderMethod() {
        GrMethod method;
        block7: {
            GroovyPsiElementFactory groovyPsiElementFactory = GroovyPsiElementFactory.getInstance(this.project);
            Intrinsics.checkNotNullExpressionValue((Object)groovyPsiElementFactory, (String)"getInstance(...)");
            GroovyPsiElementFactory factory = groovyPsiElementFactory;
            GrMethod grMethod = factory.createMethod(this.request.getMethodName(), (PsiType)PsiTypes.voidType());
            Intrinsics.checkNotNullExpressionValue((Object)grMethod, (String)"createMethod(...)");
            method = grMethod;
            Collection collection = this.request.getModifiers();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getModifiers(...)");
            List modifiersToRender = CollectionsKt.toMutableList((Collection)collection);
            if (this.targetClass.isInterface()) {
                CollectionsKt.removeAll((Collection)modifiersToRender, (Iterable)SetsKt.plus(JvmPsiUtilKt.getVisibilityModifiers(), (Object)JvmModifier.ABSTRACT));
            } else if (this.abstract) {
                if (modifiersToRender.remove(JvmModifier.PRIVATE)) {
                    ((Collection)modifiersToRender).add(JvmModifier.PROTECTED);
                }
                ((Collection)modifiersToRender).add(JvmModifier.ABSTRACT);
            }
            ((Collection)modifiersToRender).remove(JvmModifier.PUBLIC);
            GrModifierList grModifierList = method.getModifierList();
            Intrinsics.checkNotNullExpressionValue((Object)grModifierList, (String)"getModifierList(...)");
            GrModifierList modifierList = grModifierList;
            for (JvmModifier modifier : modifiersToRender) {
                Intrinsics.checkNotNull((Object)modifier);
                modifierList.setModifierProperty(JvmPsiUtilKt.toPsiModifier(modifier), true);
            }
            modifierList.setModifierProperty("def", true);
            for (AnnotationRequest annotation : this.request.getAnnotations()) {
                modifierList.addAnnotation(annotation.getQualifiedName());
            }
            if (!this.abstract) break block7;
            PsiCodeBlock psiCodeBlock = method.getBody();
            if (psiCodeBlock != null) {
                psiCodeBlock.delete();
            }
        }
        return method;
    }

    private final GrMethod insertMethod(GrMethod method) {
        GrMethod grMethod;
        PsiElement elementToReplace = this.request.getElementToReplace();
        if (elementToReplace != null && elementToReplace.isValid()) {
            PsiElement psiElement = elementToReplace.replace((PsiElement)method);
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod");
            grMethod = (GrMethod)psiElement;
        } else {
            PsiElement psiElement = this.targetClass.add(method);
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod");
            grMethod = (GrMethod)psiElement;
        }
        return grMethod;
    }
}

